/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.FileInputStream;
import javaforce.XML;

public class BuildTools {
    private XML xml;
    private BuildTools versions;

    public boolean loadXML(String buildfile) {
        this.xml = new XML();
        try {
            this.xml.read(new FileInputStream(buildfile));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
            return false;
        }
    }

    public String getTag(String name) {
        XML.XMLTag tag = this.xml.getTag(new String[]{"project", name});
        if (tag == null) {
            return "";
        }
        return tag.content;
    }

    public String getProperty(String name) {
        int cnt = this.xml.root.getChildCount();
        for (int a = 0; a < cnt; ++a) {
            XML.XMLTag tag = this.xml.root.getChildAt(a);
            if (!tag.name.equals("property")) continue;
            int attrs = tag.attrs.size();
            String attrName = null;
            String attrValue = null;
            for (int b = 0; b < attrs; ++b) {
                XML.XMLAttr attr = tag.attrs.get(b);
                if (attr.name.equals("name")) {
                    attrName = attr.value;
                }
                if (attr.name.equals("value")) {
                    attrValue = attr.value;
                }
                if (!attr.name.equals("location")) continue;
                attrValue = attr.value;
            }
            if (attrName == null || !attrName.equals(name)) continue;
            if (attrValue.equals("${javaforce-version}")) {
                if (this.versions == null) {
                    this.versions = new BuildTools();
                    this.versions.loadXML("versions.xml");
                }
                attrValue = this.versions.getProperty("javaforce-version");
            }
            return attrValue;
        }
        return "";
    }
}

