/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.File;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.utils.BuildTools;
import javaforce.utils.ResourceManager;
import javaforce.utils.WinPE;

public class GenExecutable {
    private BuildTools tools;

    public static void chmod(String file) {
        new File(file).setExecutable(true);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage:GenExecutable build.xml");
            System.exit(1);
        }
        try {
            new GenExecutable().run(args[0]);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void run(String buildfile) throws Exception {
        Object cfg;
        this.tools = new BuildTools();
        if (!this.tools.loadXML(buildfile)) {
            throw new Exception("error loading " + buildfile);
        }
        String home = this.tools.getProperty("home");
        String app = this.tools.getProperty("app");
        String apptype = this.tools.getProperty("apptype");
        Object ico = this.tools.getProperty("ico");
        if (((String)ico).length() == 0) {
            ico = app + ".ico";
        }
        if (((String)(cfg = this.tools.getProperty("cfg"))).length() == 0) {
            cfg = app + ".cfg";
        }
        try {
            if (JF.isWindows()) {
                String ext = "";
                switch (apptype) {
                    case "c": 
                    case "console": {
                        ext = "c";
                        break;
                    }
                    case "s": 
                    case "service": {
                        ext = "s";
                    }
                }
                if (!JF.copyFile(home + "/native/win64" + ext + ".exe", app + ".exe")) {
                    throw new Exception("copy error:" + app + ".exe");
                }
                if (!new File(app + ".exe").exists()) {
                    throw new Exception("copy error:" + app + ".exe");
                }
                WinPE.main(new String[]{app + ".exe", ico, cfg});
            } else if (JF.isMac()) {
                JF.copyFile(home + "/native/mac64.bin", app);
                GenExecutable.chmod(app);
            } else {
                JF.copyFile(home + "/native/linux64.bin", app + ".bin");
                ResourceManager.main(new String[]{app + ".bin", cfg});
                GenExecutable.chmod("/usr/bin/" + app);
            }
            System.out.println("Native Executable generated!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.doSubProjects();
    }

    private void doSubProjects() {
        for (int a = 2; a <= 5; ++a) {
            String project = this.tools.getProperty("project" + a);
            if (project.length() == 0) continue;
            GenExecutable.main(new String[]{project + ".xml"});
        }
    }
}

