/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import javaforce.HTTP;
import javaforce.HTTPS;
import javaforce.JFLog;
import javaforce.XML;

public class JNLP {
    private static boolean debug = false;
    private static String version = "0.4";

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) {
        if (args == null || args.length < 1) {
            System.out.println("Desc: JavaForce JNLP Launcher/" + version);
            System.out.println("Usage: JNLP file.jnlp [--nowait]");
            System.out.println("Where: --nowait = Do not wait for JNLP app to exit");
            System.out.println("Author: Peter Quiring");
            System.out.println("WebSite: http://github.com/pquiring/javaforce");
            return;
        }
        boolean wait = true;
        if (args.length > 1 && args[1].equals("--nowait")) {
            wait = false;
        }
        try {
            XML xml = new XML();
            xml.read(args[0]);
            XML.XMLTag jnlp = xml.getTag(new String[]{"jnlp"});
            if (jnlp == null) {
                throw new Exception("no jnlp tag");
            }
            XML.XMLTag res = xml.getTag(new String[]{"jnlp", "resources"});
            if (res == null) {
                throw new Exception("no resources tag");
            }
            XML.XMLTag app = xml.getTag(new String[]{"jnlp", "application-desc"});
            if (app == null) {
                throw new Exception("no application-desc tag");
            }
            String codebase = jnlp.getArg("codebase");
            if (codebase == null) {
                throw new Exception("no codebase attr");
            }
            String proto = "";
            if (codebase.startsWith("http://")) {
                proto = "http";
                codebase = codebase.substring(7);
            } else if (codebase.startsWith("https://")) {
                proto = "https";
                codebase = codebase.substring(8);
            } else {
                throw new Exception("Unknown protocol");
            }
            String host = "";
            Object uri = "";
            int i0 = codebase.indexOf(47);
            if (i0 == -1) {
                host = codebase;
                uri = "/";
            } else {
                host = codebase.substring(0, i0);
                uri = codebase.substring(i0);
                if (!((String)uri).endsWith("/")) {
                    uri = (String)uri + "/";
                }
            }
            if (debug) {
                JFLog.log("host=" + host);
            }
            int port = 80;
            int i1 = host.indexOf(58);
            if (i1 != -1) {
                if (debug) {
                    JFLog.log("port=" + host.substring(i1 + 1));
                }
                port = Integer.valueOf(host.substring(i1 + 1));
                host = host.substring(0, i1);
            }
            ArrayList<String> jars = new ArrayList<String>();
            ArrayList<String> files = new ArrayList<String>();
            ArrayList<Object> cmd = new ArrayList<Object>();
            cmd.add(System.getProperty("java.home") + "/bin/java");
            int rescnt = res.getChildCount();
            block18: for (int i2 = 0; i2 < rescnt; ++i2) {
                XML.XMLTag child = res.getChildAt(i2);
                switch (child.name) {
                    case "jar": {
                        String jar = child.getArg("href");
                        jars.add(jar);
                        int i3 = jar.lastIndexOf(47);
                        if (i3 != -1) {
                            files.add(jar.substring(i3 + 1));
                            continue block18;
                        }
                        files.add(jar);
                        continue block18;
                    }
                    case "property": {
                        String name = child.getArg("name");
                        String value = child.getArg("value");
                        cmd.add("-D" + name + "=" + value);
                        continue block18;
                    }
                    default: {
                        JFLog.log("Unknown resource:" + child.name);
                    }
                }
            }
            String main = app.getArg("main-class");
            String classpath = String.join((CharSequence)File.pathSeparator, files);
            cmd.add("-cp");
            cmd.add(classpath);
            cmd.add(main);
            for (String string : jars) {
                void var20_26;
                if (debug) break;
                HTTP http = null;
                switch (proto) {
                    case "http": {
                        http = new HTTP();
                        break;
                    }
                    case "https": {
                        http = new HTTPS();
                    }
                }
                http.open(host, port);
                byte[] data = http.get((String)uri + string);
                if (data == null || data.length == 0) {
                    JFLog.log("Download Error:" + (String)uri + string);
                }
                http.close();
                int i4 = string.lastIndexOf(47);
                if (i4 != -1) {
                    String string2 = string.substring(i4 + 1);
                }
                FileOutputStream fos = new FileOutputStream((String)var20_26);
                fos.write(data);
                fos.close();
            }
            if (debug) {
                JFLog.log("executing jnlp:");
                for (String string : cmd) {
                    JFLog.log(string);
                }
            }
            Process p = Runtime.getRuntime().exec(cmd.toArray(new String[cmd.size()]));
            if (wait) {
                p.waitFor();
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }
}

