/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import java.util.Arrays;
import javaforce.JFLog;
import javaforce.voip.Packet;
import javaforce.voip.RTP;
import javaforce.voip.RTPChannel;
import javaforce.voip.RTPCodec;

public class RTPJPEG
extends RTPCodec {
    private Packet packet = new Packet();
    private static final int mtu = 1438;
    private int seqnum;
    private int timestamp;
    private int ssrc = this.random.nextInt();
    private byte[] partial;

    @Override
    public byte[][] encode(byte[] jpeg, int x, int y, int id) {
        int cnt = (jpeg.length + 1438 - 1) / 1438;
        int len = jpeg.length;
        byte[][] packets = new byte[cnt][];
        int offset = 0;
        for (int a = 0; a < cnt; ++a) {
            int packetLength = len > 1438 ? 1438 : len;
            packets[a] = new byte[packetLength + 12 + 8];
            RTPChannel.buildHeader(packets[a], RTP.CODEC_JPEG.id, this.seqnum, this.timestamp, this.ssrc, a == cnt - 1);
            RTPJPEG.buildHeader(packets[a], x, y, offset);
            System.arraycopy(jpeg, offset, packets[a], 20, packetLength);
            offset += packetLength;
            len -= packetLength;
        }
        byte[] byArray = packets[cnt - 1];
        byArray[1] = (byte)(byArray[1] | 0x80);
        ++this.seqnum;
        this.timestamp += 100;
        return packets;
    }

    @Override
    public Packet decode(byte[] rtp, int offset, int length) {
        if (rtp.length < 20) {
            return null;
        }
        if (this.partial == null) {
            this.partial = new byte[0];
        }
        int off = rtp[13] & 0xFF;
        off <<= 8;
        off += rtp[14] & 0xFF;
        off <<= 8;
        if ((off += rtp[15] & 0xFF) != this.partial.length) {
            JFLog.log("RTPJPEG:decode:lost a packet or not in order");
            this.partial = null;
            return null;
        }
        int jpegLength = rtp.length - 12 - 8;
        int partialLength = this.partial.length;
        this.partial = Arrays.copyOf(this.partial, this.partial.length + jpegLength);
        System.arraycopy(rtp, 20, this.partial, partialLength, jpegLength);
        if ((rtp[1] & 0x80) == 128) {
            this.packet.data = this.partial;
            this.partial = null;
            return this.packet;
        }
        return null;
    }

    private static void buildHeader(byte[] data, int x, int y, int offset) {
        data[12] = 0;
        data[13] = (byte)((offset & 0xFF0000) >> 16);
        data[14] = (byte)((offset & 0xFF00) >> 8);
        data[15] = (byte)(offset & 0xFF);
        data[16] = 0;
        data[17] = 0;
        data[18] = (byte)(x / 8);
        data[19] = (byte)(y / 8);
    }
}

