/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import java.util.ArrayList;
import java.util.Arrays;
import javaforce.JFLog;
import javaforce.voip.Packet;
import javaforce.voip.RTPChannel;
import javaforce.voip.RTPCodec;

public class RTPVP8
extends RTPCodec {
    private Packet packet = new Packet();
    private static final int mtu = 1445;
    private int seqnum;
    private int timestamp;
    private final int ssrc = this.random.nextInt();
    private byte[] partial;
    private int lastseqnum = -1;

    @Override
    public byte[][] encode(byte[] data, int x, int y, int id) {
        int packetLength;
        ArrayList<byte[]> packets = new ArrayList<byte[]>();
        int offset = 0;
        for (int len = data.length; len > 0; len -= packetLength) {
            packetLength = len > 1445 ? 1445 : len;
            byte[] packet = new byte[packetLength + 1 + 12];
            RTPChannel.buildHeader(packet, id, this.seqnum++, this.timestamp, this.ssrc, len == packetLength);
            packet[12] = (byte)(packets.size() == 0 ? 16 : 0);
            System.arraycopy(data, offset, packet, 13, packetLength);
            packets.add(packet);
            offset += packetLength;
        }
        this.timestamp += 100;
        return (byte[][])packets.toArray((T[])new byte[0][0]);
    }

    @Override
    public Packet decode(byte[] rtp, int offset, int length) {
        if (rtp.length < 14) {
            return null;
        }
        int vp8Length = rtp.length - 12;
        int payloadOffset = 12;
        if (this.partial == null) {
            this.partial = new byte[0];
        }
        byte x = rtp[12];
        ++payloadOffset;
        --vp8Length;
        if ((x & 0x80) == 128) {
            byte ilt = rtp[13];
            ++payloadOffset;
            --vp8Length;
            if ((ilt & 0x80) == 128) {
                ++payloadOffset;
                --vp8Length;
            }
            if ((ilt & 0x40) == 64) {
                ++payloadOffset;
                --vp8Length;
            }
            if ((ilt & 0x20) == 32) {
                ++payloadOffset;
                --vp8Length;
            }
        }
        int partialLength = this.partial.length;
        this.partial = Arrays.copyOf(this.partial, this.partial.length + vp8Length);
        System.arraycopy(rtp, payloadOffset, this.partial, partialLength, vp8Length);
        int thisseqnum = RTPChannel.getseqnum(rtp, 0);
        if (this.lastseqnum != -1 && thisseqnum != this.lastseqnum + 1) {
            JFLog.log("VP8:Received packet out of order, discarding frame.");
            this.partial = null;
            this.lastseqnum = -1;
            return null;
        }
        this.lastseqnum = thisseqnum;
        if ((rtp[1] & 0x80) == 128) {
            this.packet.data = this.partial;
            this.partial = null;
            this.lastseqnum = -1;
            return this.packet;
        }
        return null;
    }
}

