/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.PackageTree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TreeScanner;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.util.ElementScanner9;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class JFCompiler {
    public static void usage() {
        System.out.println("Usage:JFCompiler compile|parse|analyze inFolder [outFolder]");
        System.out.println("  outFolder for compile only");
        System.exit(0);
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            JFCompiler.usage();
        }
        switch (args[0]) {
            case "compile": {
                if (args.length < 3) {
                    JFCompiler.usage();
                }
                JFCompiler.compile(args[1], args[2]);
                break;
            }
            case "parse": {
                JFCompiler.parse(args[1], new TScanner());
                break;
            }
            case "analyze": {
                JFCompiler.analyze(args[1], new EScanner());
            }
        }
    }

    private static File[] getFiles(String path) {
        ArrayList<File> files = new ArrayList<File>();
        files = new ArrayList();
        JFCompiler.addFolder(new File(path), files);
        return files.toArray(new File[0]);
    }

    private static void addFolder(File folder, ArrayList<File> files) {
        File[] list = folder.listFiles();
        for (int a = 0; a < list.length; ++a) {
            if (list[a].isDirectory()) {
                JFCompiler.addFolder(list[a], files);
                continue;
            }
            files.add(list[a]);
        }
    }

    public static boolean compile(String inFolder, String outFolder) {
        System.out.println("Compiling:" + inFolder);
        try {
            File[] files = JFCompiler.getFiles(inFolder);
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
            Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(Arrays.asList(files));
            List<String> options = Arrays.asList("-cp", System.getProperty("java.class.path"), "-d", outFolder);
            JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, null, options, null, compilationUnits);
            return task.call();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean parse(String inFolder, TreeScanner scanner) {
        System.out.println("Parsing:" + inFolder);
        try {
            File[] files = JFCompiler.getFiles(inFolder);
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
            Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(Arrays.asList(files));
            List<String> options = Arrays.asList("-cp", System.getProperty("java.class.path"));
            JavacTask task = (JavacTask)compiler.getTask(null, fileManager, null, options, null, compilationUnits);
            Iterable<? extends CompilationUnitTree> tree = task.parse();
            System.out.println("Trees:");
            tree.forEach(node -> node.accept(scanner, null));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean analyze(String inFolder, ElementScanner9 scanner) {
        System.out.println("Analyzing:" + inFolder);
        try {
            File[] files = JFCompiler.getFiles(inFolder);
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
            Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(Arrays.asList(files));
            List<String> options = Arrays.asList("-cp", System.getProperty("java.class.path"));
            JavacTask task = (JavacTask)compiler.getTask(null, fileManager, null, options, null, compilationUnits);
            Iterable<? extends Element> elements = task.analyze();
            System.out.println("Elements:");
            elements.forEach(node -> node.accept(scanner, null));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static class TScanner<R, P>
    extends TreeScanner<R, P> {
        @Override
        public R visitCompilationUnit(CompilationUnitTree node, P p) {
            System.out.println("unit:" + String.valueOf(node.getSourceFile()));
            return super.visitCompilationUnit(node, p);
        }

        @Override
        public R visitPackage(PackageTree node, P p) {
            System.out.println("package:" + String.valueOf(node.getPackageName()));
            return super.visitPackage(node, p);
        }

        @Override
        public R visitImport(ImportTree node, P p) {
            System.out.println("import:" + String.valueOf(node.getQualifiedIdentifier()));
            return super.visitImport(node, p);
        }

        @Override
        public R visitClass(ClassTree node, P p) {
            System.out.println("class:" + String.valueOf(node.getSimpleName()));
            return super.visitClass(node, p);
        }

        @Override
        public R visitMethod(MethodTree node, P p) {
            System.out.println("method:" + String.valueOf(node.getName()));
            return super.visitMethod(node, p);
        }
    }

    public static class EScanner<R, P>
    extends ElementScanner9<R, P> {
        @Override
        public R visitModule(ModuleElement e, P p) {
            System.out.println("module:" + String.valueOf(e.getSimpleName()));
            return super.visitModule(e, p);
        }
    }
}

