/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ansi.server;

import javaforce.ansi.server.ANSI;
import javaforce.ansi.server.Button;
import javaforce.ansi.server.CheckBox;
import javaforce.ansi.server.Dialog;
import javaforce.ansi.server.Field;
import javaforce.ansi.server.TextField;

public class InputDialog
implements Dialog {
    private ANSI ansi;
    private boolean closed = false;
    private boolean cancel = false;
    private Field[] fields;
    private int field = 0;
    private String action;
    private String title;
    private String[] msg;
    private String[] initValues;
    private String opts;
    public static final String ENTER_ESC = "Press <Enter> to accept or <ESC> to cancel";

    public InputDialog(ANSI ansi, String title, String[] msg, String[] initValue, String opts) {
        this.ansi = ansi;
        this.msg = msg;
        this.title = title;
        this.initValues = initValue;
        this.opts = opts;
    }

    @Override
    public void draw() {
        int a;
        int w = 48;
        int h = this.msg.length * 2 + 1;
        for (int a2 = 0; a2 < this.msg.length; ++a2) {
            if (!this.msg[a2].startsWith("{checkbox}") && !this.msg[a2].startsWith("<")) continue;
            --h;
        }
        int x = (this.ansi.width - w) / 2;
        int y = (this.ansi.height - h) / 2;
        String[] lines = new String[this.msg.length * 2 + 1];
        int pos = 0;
        for (a = 0; a < this.msg.length; ++a) {
            if (this.msg[a].startsWith("{checkbox}")) {
                lines[pos++] = this.msg[a] + ANSI.repeat(46 - this.msg[a].length() + 9, ' ');
                continue;
            }
            if (this.msg[a].startsWith("<")) {
                lines[pos++] = this.msg[a] + ANSI.repeat(46 - this.msg[a].length(), ' ');
                continue;
            }
            lines[pos++] = this.msg[a];
            lines[pos++] = "[" + ANSI.repeat(46, ' ') + "]";
        }
        lines[pos] = this.opts;
        if (this.fields != null) {
            this.initValues = new String[this.msg.length];
            for (a = 0; a < this.msg.length; ++a) {
                if (this.fields[a] instanceof TextField) {
                    this.initValues[a] = ((TextField)this.fields[a]).getText();
                }
                if (!(this.fields[a] instanceof CheckBox)) continue;
                this.initValues[a] = Boolean.toString(((CheckBox)this.fields[a]).isChecked());
            }
        }
        this.fields = this.ansi.drawWindow(x, y, w + 2, h + 2, lines);
        if (this.initValues != null) {
            for (a = 0; a < this.initValues.length; ++a) {
                if (this.initValues[a] == null) continue;
                if (this.fields[a] instanceof TextField) {
                    TextField text = (TextField)this.fields[a];
                    text.setText(this.initValues[a]);
                    text.draw();
                }
                if (!(this.fields[a] instanceof CheckBox)) continue;
                CheckBox cb = (CheckBox)this.fields[a];
                cb.setChecked(this.initValues[a].equals("true"));
                cb.draw();
            }
            this.initValues = null;
        }
    }

    @Override
    public void keyPressed(int keyCode, int keyMods) {
        block0 : switch (keyMods) {
            case 0: {
                switch (keyCode) {
                    case 27: {
                        this.closed = true;
                        this.cancel = true;
                        break block0;
                    }
                }
                this.fields[this.field].keyPressed(keyCode, keyMods);
            }
        }
    }

    @Override
    public void keyTyped(char key) {
        switch (key) {
            case '\t': {
                ++this.field;
                if (this.field == this.fields.length) {
                    this.field = 0;
                }
                this.fields[this.field].gotoCurrentPos();
                break;
            }
            case '\n': {
                this.closed = true;
                if (!(this.fields[this.field] instanceof Button)) break;
                this.action = ((Button)this.fields[this.field]).action;
                if (!this.action.equals("ESC")) break;
                this.cancel = true;
                break;
            }
            case ' ': {
                if (!(this.fields[this.field] instanceof CheckBox)) break;
                CheckBox cb = (CheckBox)this.fields[this.field];
                cb.toggle();
                cb.draw();
                break;
            }
            default: {
                this.fields[this.field].keyTyped(key);
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public boolean isCancelled() {
        return this.cancel;
    }

    public void nextField() {
        if (this.fields.length < 2) {
            return;
        }
        ++this.field;
        if (this.field == this.fields.length) {
            this.field = 0;
        }
        this.fields[this.field].gotoCurrentPos();
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getText(int idx) {
        if (this.cancel) {
            return null;
        }
        return ((TextField)this.fields[idx]).getText();
    }

    public boolean isChecked(int idx) {
        if (this.cancel) {
            return false;
        }
        return ((CheckBox)this.fields[idx]).isChecked();
    }

    public void setOptions(String ops) {
        this.opts = this.opts;
    }
}

