/*
 * Decompiled with CFR 0.152.
 */
package javaforce.net;

import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import javaforce.BE;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.jni.JFNative;
import javaforce.jni.Library;

public class PacketCapture {
    public static boolean debug = false;
    public static int TYPE_IP4 = 2048;
    public static int TYPE_ARP = 2054;
    public static int TYPE_IP6 = 34525;
    private byte[] local_mac;
    private byte[] local_ip;
    public static int ethernet_size = 14;
    public static byte[] mac_broadcast = new byte[]{-1, -1, -1, -1, -1, -1};
    public static byte[] mac_zero = new byte[]{0, 0, 0, 0, 0, 0};
    public static byte[] ip_broadcast = new byte[]{-1, -1, -1, -1};
    public static byte[] ip_zero = new byte[]{0, 0, 0, 0};
    public static int ARP_REQUEST = 1;
    public static int ARP_REPLY = 2;
    public static int arp_size = 28;
    private static String nic_ip = null;
    private static String timeout = "2000";

    public static native boolean ninit(String var0, String var1);

    public static boolean init() {
        if (JF.isWindows()) {
            String windir = System.getenv("windir").replaceAll("\\\\", "/");
            String dll1 = windir + "/system32/npcap/packet.dll";
            String dll2 = windir + "/system32/npcap/wpcap.dll";
            if (new File(dll1).exists() && new File(dll2).exists()) {
                return PacketCapture.ninit(dll1, dll2);
            }
            dll1 = windir + "/system32/packet.dll";
            dll2 = windir + "/system32/wpcap.dll";
            if (new File(dll1).exists() && new File(dll2).exists()) {
                return PacketCapture.ninit(dll1, dll2);
            }
            return false;
        }
        if (JF.isUnix()) {
            Library so1 = new Library("packet");
            Library so2 = new Library("pcap");
            JFNative.findLibraries(new File[]{new File("/usr/lib")}, new Library[]{so1, so2}, ".so", 2);
            return PacketCapture.ninit(so1.path, so2.path);
        }
        return false;
    }

    public static native String[] listLocalInterfaces();

    public String findInterface(String ip) {
        String[] ifs = PacketCapture.listLocalInterfaces();
        if (debug) {
            JFLog.log("local interfaces:" + ifs.length + " found");
        }
        for (int a = 0; a < ifs.length; ++a) {
            String[] dev_ips = ifs[a].split("[,]");
            if (debug) {
                JFLog.log("local interface:" + dev_ips[0]);
            }
            for (int b = 1; b < dev_ips.length; ++b) {
                if (!dev_ips[b].equals(ip)) continue;
                return dev_ips[0];
            }
        }
        return null;
    }

    private static native long nstart(String var0);

    public long start(String local_interface, String local_ip) {
        this.local_ip = PacketCapture.decode_ip(local_ip);
        this.local_mac = this.get_mac(local_ip);
        return PacketCapture.nstart(local_interface);
    }

    public static native void stop(long var0);

    public static native boolean compile(long var0, String var2);

    public static native byte[] read(long var0);

    public static native boolean write(long var0, byte[] var2, int var3, int var4);

    public static void print_mac(byte[] mac) {
        if (mac == null) {
            JFLog.log("null");
            return;
        }
        for (int a = 0; a < mac.length; ++a) {
            if (a > 0) {
                System.out.print(":");
            }
            System.out.print(String.format("%02x", mac[a]));
        }
        JFLog.log("");
    }

    public byte[] get_mac(String ip) {
        try {
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                NetworkInterface interf = nics.nextElement();
                if (interf.isLoopback()) continue;
                Enumeration<InetAddress> nic_ips = interf.getInetAddresses();
                while (nic_ips.hasMoreElements()) {
                    String nic_ip = nic_ips.nextElement().getHostAddress();
                    if (!nic_ip.equals(ip)) continue;
                    byte[] mac = interf.getHardwareAddress();
                    if (debug) {
                        JFLog.log("IP=" + ip);
                        PacketCapture.print_mac(mac);
                    }
                    return mac;
                }
            }
            JFLog.log("Error:mac not found:" + ip);
            return mac_zero;
        }
        catch (Exception e) {
            JFLog.log("Exception:" + String.valueOf(e));
            return null;
        }
    }

    public static String build_mac(byte[] mac) {
        StringBuilder sb = new StringBuilder();
        for (int a = 0; a < mac.length; ++a) {
            if (a > 0) {
                sb.append(':');
            }
            sb.append(String.format("%02x", mac[a] & 0xFF));
        }
        return sb.toString();
    }

    public static boolean valid_ip(String ip) {
        String[] p = ip.split("[.]");
        if (p.length != 4) {
            return false;
        }
        int[] o = new int[4];
        for (int a = 0; a < 4; ++a) {
            String s = p[a];
            if (s.length() == 0) {
                return false;
            }
            if (s.charAt(0) == '0' && s.length() > 1) {
                return false;
            }
            if (s.length() > 3) {
                return false;
            }
            try {
                int value = Integer.valueOf(s);
                if (value < 0 || value > 255) {
                    return false;
                }
                o[a] = value;
                continue;
            }
            catch (Exception e) {
                return false;
            }
        }
        return o[0] != 0;
    }

    public static byte[] decode_ip(String ip) {
        String[] ips = ip.split("[.]");
        byte[] ret = new byte[ips.length];
        for (int a = 0; a < ips.length; ++a) {
            ret[a] = (byte)Integer.valueOf(ips[a]).intValue();
        }
        return ret;
    }

    public static String build_ip(byte[] ip) {
        StringBuilder sb = new StringBuilder();
        for (int a = 0; a < ip.length; ++a) {
            if (a > 0) {
                sb.append('.');
            }
            sb.append(String.format("%d", ip[a] & 0xFF));
        }
        return sb.toString();
    }

    public static boolean compare_ip(byte[] ip1, byte[] ip2) {
        if (ip1.length != ip2.length) {
            return false;
        }
        for (int a = 0; a < ip1.length; ++a) {
            if (ip1[a] == ip2[a]) continue;
            return false;
        }
        return true;
    }

    public static void increment_ip(byte[] ip) {
        int pos = ip.length - 1;
        while ((ip[pos] & 0xFF) == 255) {
            ip[pos] = 0;
            if (--pos != -1) continue;
            pos = ip.length - 1;
        }
        int n = pos;
        ip[n] = (byte)(ip[n] + 1);
    }

    public static int get_ip_range_length(byte[] ip_start, byte[] ip_end) {
        int start32 = BE.getuint32(ip_start, 0);
        int end32 = BE.getuint32(ip_end, 0);
        if (end32 < start32) {
            return -1;
        }
        return end32 - start32 + 1;
    }

    public void build_ethernet(byte[] pkt, byte[] dest, byte[] src, int type) {
        int offset = 0;
        System.arraycopy(dest, 0, pkt, offset, 6);
        System.arraycopy(src, 0, pkt, offset += 6, 6);
        BE.setuint16(pkt, offset += 6, type);
        offset += 2;
    }

    public int get_ethernet_type(byte[] pkt) {
        return BE.getuint16(pkt, 12);
    }

    public void build_arp(byte[] pkt, byte[] src_mac, byte[] src_ip, byte[] request_ip) {
        int offset = ethernet_size;
        BE.setuint16(pkt, offset, 1);
        BE.setuint16(pkt, offset += 2, 2048);
        pkt[offset += 2] = 6;
        pkt[++offset] = 4;
        BE.setuint16(pkt, ++offset, ARP_REQUEST);
        System.arraycopy(src_mac, 0, pkt, offset += 2, 6);
        System.arraycopy(src_ip, 0, pkt, offset += 6, 4);
        System.arraycopy(mac_zero, 0, pkt, offset += 4, 6);
        System.arraycopy(request_ip, 0, pkt, offset += 6, 4);
        offset += 4;
    }

    public int get_arp_opcode(byte[] pkt) {
        return BE.getuint16(pkt, ethernet_size + 6);
    }

    public boolean arp_ip_equals(byte[] pkt, byte[] ip) {
        int pkt_offset = ethernet_size + arp_size - 14;
        for (int a = 0; a < ip.length; ++a) {
            if (pkt[pkt_offset++] == ip[a]) continue;
            return false;
        }
        return true;
    }

    public byte[] get_arp_mac(byte[] pkt) {
        int pkt_offset = ethernet_size + arp_size - 20;
        byte[] ret = new byte[6];
        System.arraycopy(pkt, pkt_offset, ret, 0, 6);
        return ret;
    }

    public byte[] arp(long handle, String target_ip, int ms) {
        if (debug) {
            JFLog.log("arp.timeout=" + ms);
        }
        byte[] ip = PacketCapture.decode_ip(target_ip);
        byte[] pkt = new byte[ethernet_size + arp_size + 18];
        this.build_ethernet(pkt, mac_broadcast, this.local_mac, TYPE_ARP);
        this.build_arp(pkt, this.local_mac, this.local_ip, ip);
        if (debug) {
            JFLog.log("arp.write()");
        }
        PacketCapture.write(handle, pkt, 0, pkt.length);
        int pkt_length = ethernet_size + arp_size;
        for (int time = 0; time < ms; time += 100) {
            do {
                if (debug) {
                    JFLog.log("arp.read()");
                }
                pkt = PacketCapture.read(handle);
                if (debug) {
                    JFLog.log("arp.pkt=" + String.valueOf(pkt));
                }
                if (pkt == null || pkt.length < pkt_length || this.get_ethernet_type(pkt) != TYPE_ARP || this.get_arp_opcode(pkt) != ARP_REPLY || !this.arp_ip_equals(pkt, ip)) continue;
                return this.get_arp_mac(pkt);
            } while (pkt != null);
            JF.sleep(100);
        }
        return null;
    }

    private static void parse_opts(String[] args) {
        block8: for (int a = 0; a < args.length; ++a) {
            if (!args[a].startsWith("-")) continue;
            switch (args[a]) {
                case "-i": {
                    nic_ip = args[a + 1];
                    continue block8;
                }
                case "-t": {
                    timeout = args[a + 1];
                }
            }
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            JFLog.log("Usage : PacketCapture cmd [...] [opts]");
            JFLog.log("  cmd : list");
            JFLog.log("      : arp {ip}");
            JFLog.log(" opts : -i interface_ip");
            JFLog.log("      : -t timeout");
            return;
        }
        JFNative.load();
        if (!PacketCapture.init()) {
            JFLog.log("init failed");
            return;
        }
        try {
            switch (args[0]) {
                case "list": {
                    PacketCapture.cmd_list();
                    break;
                }
                case "arp": {
                    PacketCapture.parse_opts(args);
                    PacketCapture.cmd_arp(args[1]);
                    break;
                }
                default: {
                    JFLog.log("Unknown cmd:" + args[0]);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void cmd_list() {
        PacketCapture cap = new PacketCapture();
        String[] ifs = cap.listLocalInterfaces();
        for (int a = 0; a < ifs.length; ++a) {
            JFLog.log(ifs[a]);
        }
    }

    public static void cmd_arp(String ip) {
        PacketCapture cap = new PacketCapture();
        String[] nics = cap.listLocalInterfaces();
        int nicidx = 0;
        if (nic_ip != null) {
            nicidx = -1;
            block0: for (int a = 0; a < nics.length; ++a) {
                String sif = nics[a];
                String[] pif = sif.split(",");
                for (int b = 1; b < pif.length; ++b) {
                    if (!pif[b].equals(nic_ip)) continue;
                    nicidx = a;
                    continue block0;
                }
            }
        }
        if (nicidx == -1) {
            JFLog.log("Interface not found for IP:" + nic_ip);
            return;
        }
        String sif = nics[nicidx];
        String[] pif = sif.split(",");
        long id = cap.start(pif[0], pif[1]);
        PacketCapture.compile(id, "arp");
        byte[] mac = cap.arp(id, ip, Integer.valueOf(timeout));
        PacketCapture.stop(id);
        System.out.print("MAC=");
        PacketCapture.print_mac(mac);
    }
}

