/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import javaforce.BE;
import javaforce.JFLog;
import javaforce.service.MQTTEvents;

public class MQTT
extends Thread {
    private boolean active;
    private ArrayList<Reader> readers = new ArrayList();
    private MQTTEvents events;
    private ServerSocket ss;
    private static int bufsiz = 4096;
    private static final byte CMD_CONNECT = 1;
    private static final byte CMD_CONNECT_ACK = 2;
    private static final byte CMD_PUBLISH = 3;
    private static final byte CMD_PUBLISH_ACK = 4;
    private static final byte CMD_PUBLISH_REC = 5;
    private static final byte CMD_PUBLISH_REL = 6;
    private static final byte CMD_PUBLISH_CMP = 7;
    private static final byte CMD_SUBSCRIBE = 8;
    private static final byte CMD_SUBSCRIBE_ACK = 9;
    private static final byte CMD_UNSUBSCRIBE = 10;
    private static final byte CMD_UNSUBSCRIBE_ACK = 11;
    private static final byte CMD_PING = 12;
    private static final byte CMD_PONG = 13;
    private static final byte CMD_DISCONNECT = 14;

    public void setListener(MQTTEvents events) {
        this.events = events;
    }

    public void cancel() {
        this.active = false;
    }

    @Override
    public void run() {
        this.active = true;
        try {
            this.ss = new ServerSocket(1883);
            while (this.active) {
                Socket s = this.ss.accept();
                Worker worker = new Worker(s);
                worker.start();
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    private Reader getReader(String ip) {
        for (Reader reader : this.readers) {
            if (!reader.ip.equals(ip)) continue;
            return reader;
        }
        return null;
    }

    private int getPacketLength(byte[] data, int length) {
        int next;
        int multi = 1;
        int value = 0;
        int pos = 1;
        do {
            if (pos >= length) {
                return -1;
            }
            next = data[pos++] & 0xFF;
            value += (next & 0x7F) * multi;
            multi *= 128;
        } while (next >= 128);
        return value;
    }

    private int getTopicLength(byte[] data, int topicPosition) {
        return BE.getuint16(data, topicPosition);
    }

    private short getPacketID(byte[] data, int idPosition) {
        return (short)BE.getuint16(data, idPosition);
    }

    private void setPacketLength(byte[] in, byte[] out) {
        int value = in.length;
        int pos = 1;
        do {
            byte ebyte = (byte)(value % 128);
            if ((value /= 128) > 0) {
                ebyte = (byte)(ebyte | 0x80);
            }
            out[pos++] = ebyte;
        } while (value != 0);
    }

    private void setPacketLength(byte[] packet) {
        int value = packet.length - 2;
        int pos = 1;
        do {
            byte ebyte = (byte)(value % 128);
            if ((value /= 128) > 0) {
                ebyte = (byte)(ebyte | 0x80);
            }
            packet[pos++] = ebyte;
        } while (value > 0);
    }

    private void setPacketID(byte[] data, short id) {
        BE.setuint16(data, 2, id);
    }

    private int getLengthBytes(int length) {
        if (length <= 127) {
            return 1;
        }
        if (length <= 1023) {
            return 2;
        }
        if (length <= 0x1FFFFF) {
            return 3;
        }
        if (length <= 0xFFFFFFF) {
            return 4;
        }
        return -1;
    }

    private class Worker
    extends Thread {
        public Socket s;
        public InputStream is;
        public OutputStream os;
        public String ip;
        public Reader reader;

        public Worker(Socket s) {
            this.s = s;
        }

        @Override
        public void run() {
            try {
                this.is = this.s.getInputStream();
                this.os = this.s.getOutputStream();
                this.ip = this.s.getInetAddress().getHostAddress();
                this.reader = MQTT.this.getReader(this.ip);
                if (this.reader == null) {
                    throw new Exception("reader not configured:" + this.ip);
                }
                JFLog.log("connect:" + this.ip);
                byte[] buf = new byte[bufsiz];
                block4: while (MQTT.this.active) {
                    int totalRead = 0;
                    int packetLength = -1;
                    int totalLength = -1;
                    Arrays.fill(buf, (byte)0);
                    while (MQTT.this.active) {
                        int read = packetLength == -1 ? this.is.read(buf, totalRead, 1) : this.is.read(buf, totalRead, totalLength - totalRead);
                        JFLog.log("read=" + read);
                        if (read == -1) {
                            throw new Exception("bad read");
                        }
                        if ((totalRead += read) < 2) continue;
                        if (packetLength == -1 && (packetLength = MQTT.this.getPacketLength(buf, totalRead)) != -1) {
                            totalLength = 1 + MQTT.this.getLengthBytes(packetLength) + packetLength;
                            JFLog.log("totalLength=" + totalLength);
                        }
                        if (packetLength == -1 || totalRead < totalLength) continue;
                        try {
                            this.process(buf, totalLength, packetLength);
                        }
                        catch (Exception e) {
                            JFLog.log(e);
                        }
                        continue block4;
                    }
                }
            }
            catch (Exception e) {
                JFLog.log(e);
            }
            JFLog.log("disconnect:" + this.ip);
        }

        private void process(byte[] packet, int totalLength, int packetLength) throws Exception {
            byte[] reply = null;
            byte cmd = (byte)((packet[0] & 0xF0) >> 4);
            JFLog.log("cmd=" + cmd);
            switch (cmd) {
                case 1: {
                    reply = new byte[4];
                    reply[0] = 32;
                    MQTT.this.setPacketLength(reply);
                    break;
                }
                case 3: {
                    int topicPosition = 1 + MQTT.this.getLengthBytes(packetLength);
                    int topicLength = MQTT.this.getTopicLength(packet, topicPosition);
                    JFLog.log("topic=" + topicPosition + "/" + topicLength);
                    String topic = new String(packet, topicPosition + 2, topicLength);
                    int idPosition = topicPosition + 2 + topicLength;
                    short id = MQTT.this.getPacketID(packet, idPosition);
                    JFLog.log("id=" + id);
                    int msgPosition = idPosition + 2;
                    int msgLength = totalLength - msgPosition;
                    JFLog.log("msg=" + msgPosition + "/" + msgLength);
                    String msg = new String(packet, msgPosition, msgLength);
                    JFLog.log("PUBLISH:" + this.ip + ":" + topic + ":" + msg + "!");
                    reply = new byte[4];
                    reply[0] = 64;
                    MQTT.this.setPacketLength(reply);
                    MQTT.this.setPacketID(reply, id);
                    if (MQTT.this.events == null) break;
                    MQTT.this.events.message(topic, msg);
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    int idPosition = 1 + MQTT.this.getLengthBytes(packetLength);
                    short id = MQTT.this.getPacketID(packet, idPosition);
                    JFLog.log("id=" + id);
                    int topicPosition = idPosition + 2;
                    int topicLength = MQTT.this.getTopicLength(packet, topicPosition);
                    JFLog.log("topic=" + topicPosition + "/" + topicLength);
                    String topic = new String(packet, topicPosition + 2, topicLength);
                    int msgPosition = topicPosition + 2 + topicLength;
                    int msgLength = totalLength - msgPosition;
                    JFLog.log("msg=" + msgPosition + "/" + msgLength);
                    String msg = new String(packet, msgPosition, msgLength);
                    JFLog.log("SUBSCRIBE:" + this.ip + ":" + topic + ":" + msg + "!");
                    reply = new byte[5];
                    reply[0] = -112;
                    MQTT.this.setPacketLength(reply);
                    MQTT.this.setPacketID(reply, id);
                    break;
                }
                case 10: {
                    int idPosition = 1 + MQTT.this.getLengthBytes(packetLength);
                    short id = MQTT.this.getPacketID(packet, idPosition);
                    JFLog.log("id=" + id);
                    int topicPosition = idPosition + 2;
                    int topicLength = MQTT.this.getTopicLength(packet, topicPosition);
                    JFLog.log("topic=" + topicPosition + "/" + topicLength);
                    String topic = new String(packet, topicPosition + 2, topicLength);
                    int msgPosition = topicPosition + 2 + topicLength;
                    int msgLength = totalLength - msgPosition;
                    JFLog.log("msg=" + msgPosition + "/" + msgLength);
                    String msg = new String(packet, msgPosition, msgLength);
                    JFLog.log("UNSUB:" + this.ip + ":" + topic + ":" + msg);
                    reply = new byte[4];
                    reply[0] = -80;
                    MQTT.this.setPacketLength(reply);
                    MQTT.this.setPacketID(reply, id);
                    break;
                }
                case 12: {
                    reply = new byte[2];
                    reply[0] = -48;
                    JFLog.log("PING:" + this.ip);
                    break;
                }
            }
            if (reply == null) {
                throw new Exception("bad cmd:" + cmd);
            }
            this.send(reply);
        }

        private void send(byte[] reply) throws Exception {
            this.os.write(reply);
        }
    }

    private static class Reader {
        public String ip;

        private Reader() {
        }
    }
}

