/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ui;

import javaforce.ui.ChangeListener;
import javaforce.ui.Column;
import javaforce.ui.Dimension;
import javaforce.ui.Font;
import javaforce.ui.ListItem;

public class ListBox
extends Column {
    private Font font = Font.getSystemFont();
    private boolean multiSelection;
    private ChangeListener change;

    public ListBox() {
        this.setBorderStyle(1);
    }

    @Override
    public Dimension getMinSize() {
        int width = 0;
        int height = 0;
        for (ListItem item : this.getChildren()) {
            Dimension size = item.getMinSize();
            if (size.width > width) {
                width = size.width;
            }
            height += size.height;
        }
        if (this.getBorderStyle() != 0) {
            width += 2;
            height += 2;
        }
        return new Dimension(width, height);
    }

    public int getItemHeight() {
        return this.font.getMaxHeight();
    }

    public boolean isMultiSelection() {
        return this.multiSelection;
    }

    public void setMultiSelection(boolean state) {
        this.multiSelection = state;
        this.setSelectedIndex(-1);
    }

    private void clearSelectionExcept(ListItem selected) {
        for (ListItem item : this.getChildren()) {
            if (item == selected || !item.isSelected()) continue;
            item.setSelected(false);
        }
    }

    public void addItem(String text) {
        this.removeItem(text);
        ListItem item = new ListItem(text);
        item.setFont(this.font);
        item.setActionListener(cmp -> {
            if (!this.multiSelection || !this.getKeyState(341) && !this.getKeyState(345)) {
                this.clearSelectionExcept((ListItem)cmp);
            }
            if (this.change != null) {
                this.change.changed(this);
            }
        });
        this.add(item);
    }

    public void setChangeListener(ChangeListener listener) {
        this.change = listener;
    }

    public void removeItem(String text) {
        for (ListItem item : this.getChildren(new ListItem[this.getChildCount()])) {
            if (!item.getText().equals(text)) continue;
            this.remove(item);
            return;
        }
    }

    public ListItem[] getChildren() {
        return this.getChildren(new ListItem[this.getChildCount()]);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        for (ListItem item : this.getChildren()) {
            item.setFont(font);
        }
    }

    public int getSelectedIndex() {
        int idx = 0;
        for (ListItem item : this.getChildren()) {
            if (item.isSelected()) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public int[] getSelectedIndexes() {
        int idx = 0;
        int cnt = 0;
        for (ListItem item : this.getChildren()) {
            if (!item.isSelected()) continue;
            ++cnt;
        }
        int[] list = new int[cnt];
        int pos = 0;
        for (ListItem item : this.getChildren()) {
            if (item.isSelected()) {
                list[pos++] = idx;
            }
            ++idx;
        }
        return list;
    }

    public String getSelectedItem() {
        int idx = this.getSelectedIndex();
        if (idx == -1) {
            return null;
        }
        ListItem item = (ListItem)this.getChild(idx);
        return item.getText();
    }

    public void setSelectedIndex(int index) {
        int idx = 0;
        for (ListItem item : this.getChildren()) {
            if (idx == index) {
                if (!item.isSelected()) {
                    item.setSelected(true);
                }
            } else if (item.isSelected()) {
                item.setSelected(false);
            }
            ++idx;
        }
    }

    @Override
    public String toString() {
        return "ListBox";
    }
}

