/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Properties;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.ShellProcess;
import javaforce.ShellProcessListener;
import javaforce.utils.BuildTools;

public class ExecProject
implements ShellProcessListener {
    private BuildTools tools;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("ExecProject : Runs project using java");
            System.out.println("  Usage : ExecProject buildfile");
            System.exit(1);
        }
        try {
            new ExecProject().run(args[0]);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void run(String buildfile) throws Exception {
        this.tools = new BuildTools();
        if (!this.tools.loadXML(buildfile)) {
            throw new Exception("error loading " + buildfile);
        }
        String app = this.tools.getProperty("app");
        Object cfg = this.tools.getProperty("cfg");
        if (((String)cfg).length() == 0) {
            cfg = app + ".cfg";
        }
        String home = this.tools.getProperty("home");
        Object exec = "jfexec";
        if (JF.isWindows()) {
            String apptype = this.tools.getProperty("apptype");
            if (apptype == null) {
                apptype = "window";
            }
            Objects.requireNonNull(apptype);
            exec = (String)exec + ".exe";
        }
        Properties props = new Properties();
        FileInputStream fis = new FileInputStream((String)cfg);
        props.load(fis);
        fis.close();
        String classpath = props.getProperty("CLASSPATH");
        String mainclass = props.getProperty("MAINCLASS");
        ShellProcess sp = new ShellProcess();
        sp.addListener(this);
        ArrayList<Object> cmd = new ArrayList<Object>();
        cmd.add(home + File.separator + "bin" + File.separator + (String)exec);
        cmd.add("-cp");
        if (JF.isWindows()) {
            cmd.add(classpath);
        } else {
            cmd.add(classpath.replaceAll("[;]", ":"));
        }
        cmd.add(mainclass);
        sp.run(cmd.toArray(new String[0]), true);
    }

    @Override
    public void shellProcessOutput(String str) {
        System.out.print(str);
    }
}

