/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.util.Timer;
import java.util.TimerTask;
import javaforce.JFLog;
import javaforce.awt.JFAWT;
import javaforce.awt.JFImage;
import javaforce.jni.JFNative;
import javaforce.media.Camera;
import javaforce.media.MediaCoder;
import javaforce.media.MediaEncoder;
import javaforce.media.MediaIO;
import javaforce.webui.Component;
import javaforce.webui.Panel;
import javaforce.webui.Video;
import javaforce.webui.WebUIClient;
import javaforce.webui.WebUIHandler;
import javaforce.webui.WebUIServer;
import javaforce.webui.event.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;

public class TestCamera
extends JFrame
implements WebUIHandler,
MediaIO {
    private JComboBox<String> cameraList;
    private JLabel preview;
    private JButton start;
    private JButton stop;
    private JCheckBox transcodeBox;
    private JButton webView;
    private Camera camera;
    private Timer timer;
    private int frameCount = 0;
    private int encoderCount = 1;
    private int fps = 10;
    private JFImage img;
    private int width;
    private int height;
    private MediaEncoder encoder_dash;
    private MediaEncoder encoder_h264;
    private WebUIClient client;
    private Video video;
    private Video video_capture;
    private byte[] init_segment;
    private boolean transcode;

    public TestCamera() {
        JFNative.load();
        if (!MediaCoder.init()) {
            JFAWT.showError("Error", "FFmpeg init failed");
            System.exit(1);
        }
        this.initComponents();
        this.pack();
        this.listCameras();
        new WebUIServer().start(this, 8080, false);
        this.encoder_dash = new MediaEncoder();
        this.encoder_dash.setProfileLevel(2);
        this.encoder_h264 = new MediaEncoder();
        this.encoder_h264.setProfileLevel(2);
    }

    private void initComponents() {
        this.start = new JButton();
        this.stop = new JButton();
        this.preview = new JLabel();
        this.webView = new JButton();
        this.cameraList = new JComboBox();
        this.transcodeBox = new JCheckBox();
        this.setDefaultCloseOperation(3);
        this.setTitle("Camera Test");
        this.start.setFont(new Font("Tahoma", 0, 18));
        this.start.setText("Start");
        this.start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestCamera.this.startActionPerformed(evt);
            }
        });
        this.stop.setFont(new Font("Tahoma", 0, 18));
        this.stop.setText("Stop");
        this.stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestCamera.this.stopActionPerformed(evt);
            }
        });
        this.webView.setFont(new Font("Tahoma", 0, 18));
        this.webView.setText("Web Stream");
        this.webView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestCamera.this.webViewActionPerformed(evt);
            }
        });
        this.cameraList.setFont(new Font("Tahoma", 1, 18));
        this.transcodeBox.setFont(new Font("Tahoma", 1, 18));
        this.transcodeBox.setText("transcode h264 -> dash");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.preview, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.start, -2, 248, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.stop, -2, 245, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cameraList, 0, 370, Short.MAX_VALUE).addComponent(this.transcodeBox, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.webView, -2, 166, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.start, -1, 98, Short.MAX_VALUE).addComponent(this.webView, -1, -1, Short.MAX_VALUE).addComponent(this.stop, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.cameraList, -2, 42, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.transcodeBox))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.preview, -1, 492, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void startActionPerformed(ActionEvent evt) {
        int a;
        int camIdx;
        this.setState(false);
        this.transcode = this.transcodeBox.isSelected();
        this.camera = new Camera();
        if (!this.camera.init()) {
            JFAWT.showError("Error", "Camera init failed");
            return;
        }
        String[] devices = this.camera.listDevices();
        if (devices == null || devices.length == 0) {
            this.camera.uninit();
            JFAWT.showError("Error", "No camera found");
        }
        if ((camIdx = this.cameraList.getSelectedIndex()) >= devices.length) {
            camIdx = 0;
        }
        JFLog.log("camera=" + devices[camIdx]);
        for (a = 0; a < 3; ++a) {
            JFLog.log(" ------------------------------- ");
        }
        this.encoder_dash.start(this, 640, 480, 10, -1, -1, "dash", true, false);
        if (this.transcode) {
            for (a = 0; a < 3; ++a) {
                JFLog.log(" ------------------------------- ");
            }
            this.encoder_h264.start(new MediaIO(){

                @Override
                public int read(MediaCoder coder, byte[] data) {
                    return 0;
                }

                @Override
                public int write(MediaCoder coder, byte[] data) {
                    JFLog.log("h264.write:" + data.length);
                    TestCamera.this.encoder_dash.addVideoEncodedTS(data, 0, data.length, false, TestCamera.this.encoder_h264.getLastDTS(), TestCamera.this.encoder_h264.getLastPTS());
                    TestCamera.this.encoder_dash.flush();
                    return data.length;
                }

                @Override
                public long seek(MediaCoder coder, long pos, int how) {
                    return 0L;
                }
            }, 640, 480, 10, -1, -1, "h264", true, false);
        }
        for (a = 0; a < 3; ++a) {
            JFLog.log(" ------------------------------- ");
        }
        this.camera.start(camIdx, 640, 480);
        this.width = this.camera.getWidth();
        this.height = this.camera.getHeight();
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int[] px = TestCamera.this.camera.getFrame();
                        if (px == null) {
                            return;
                        }
                        if (TestCamera.this.img == null) {
                            TestCamera.this.img = new JFImage(TestCamera.this.width, TestCamera.this.height);
                        }
                        System.arraycopy(px, 0, TestCamera.this.img.getBuffer(), 0, TestCamera.this.width * TestCamera.this.height);
                        TestCamera.this.preview.setIcon(TestCamera.this.img);
                        TestCamera.this.preview.repaint();
                        JFLog.log("addFrame:" + TestCamera.this.frameCount++);
                        if (TestCamera.this.transcode) {
                            TestCamera.this.encoder_h264.addVideo(px);
                            TestCamera.this.encoder_h264.flush();
                        } else {
                            TestCamera.this.encoder_dash.addVideo(px);
                            TestCamera.this.encoder_dash.flush();
                        }
                        JFLog.log("============================");
                    }
                });
            }
        }, 100L, 100L);
    }

    private void stopActionPerformed(ActionEvent evt) {
        if (this.camera == null) {
            return;
        }
        this.timer.cancel();
        this.timer = null;
        this.camera.stop();
        this.camera = null;
        if (this.transcode) {
            this.encoder_h264.stop();
        }
        this.encoder_dash.stop();
        this.setState(true);
    }

    private void webViewActionPerformed(ActionEvent evt) {
        JFAWT.openURL("http://localhost:8080");
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new TestCamera().setVisible(true);
            }
        });
    }

    public void listCameras() {
        this.camera = new Camera();
        if (!this.camera.init()) {
            JFAWT.showError("Error", "Camera init failed");
            return;
        }
        String[] devices = this.camera.listDevices();
        this.camera.uninit();
        if (devices == null || devices.length == 0) {
            JFAWT.showError("Error", "No camera found");
            return;
        }
        JFLog.log("device count=" + devices.length);
        for (int a = 0; a < devices.length; ++a) {
            JFLog.log("device=" + devices[a]);
            this.cameraList.addItem(devices[a]);
        }
    }

    public String getCurrentTime() {
        double currentTime = this.encoderCount;
        return String.format("%.3f", currentTime /= (double)this.fps);
    }

    public void setState(boolean state) {
        this.transcodeBox.setEnabled(state);
        this.cameraList.setEnabled(state);
        this.webView.setEnabled(state);
    }

    @Override
    public void clientConnected(WebUIClient client) {
        JFLog.log("clientConnected:" + String.valueOf(client));
        this.client = client;
        client.setProperty("init-segment", "false");
        client.setProperty("start-segment", "false");
    }

    @Override
    public void clientDisconnected(WebUIClient client) {
        JFLog.log("clientDisconnected:" + String.valueOf(client));
        this.client = null;
    }

    @Override
    public byte[] getResource(String url) {
        return null;
    }

    @Override
    public Panel getRootPanel(final WebUIClient client) {
        Panel panel = new Panel();
        this.video = new Video();
        this.video.setWidth(640);
        this.video.setHeight(480);
        panel.add(this.video);
        this.video.addActionListener(new Action(){

            @Override
            public void action(Component cmp) {
                TestCamera.this.video.setLiveSource(TestCamera.this.encoder_dash.getCodecMimeType("dash", true, false));
            }
        });
        this.video_capture = new Video();
        this.video_capture.setWidth(1024);
        this.video_capture.setHeight(720);
        panel.add(this.video_capture);
        this.video_capture.addActionListener(new Action(){

            @Override
            public void action(Component cmp) {
                TestCamera.this.video_capture.setCapture(true, true);
                try {
                    client.setOutputStream(new FileOutputStream("test.mkv"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return panel;
    }

    @Override
    public int read(MediaCoder coder, byte[] data) {
        JFLog.log("read:" + data.length);
        return -1;
    }

    @Override
    public int write(MediaCoder coder, byte[] data) {
        String type;
        JFLog.log("dash.write:" + data.length + ":" + this.getCurrentTime());
        boolean is_init = this.init_segment == null;
        boolean is_start_segment = false;
        if (data.length >= 8 && (type = new String(data, 4, 4)).equals("styp")) {
            is_start_segment = true;
        }
        if (this.init_segment == null) {
            this.init_segment = new byte[data.length];
            System.arraycopy(data, 0, this.init_segment, 0, data.length);
        }
        if (this.client != null) {
            if (!this.video.isPlaying()) {
                return data.length;
            }
            JFLog.log("send frame:" + data.length);
            if (this.client.getProperty("init-segment").equals("false") && is_init) {
                this.client.setProperty("init-segment", "true");
                this.client.setProperty("start-segment", "true");
            }
            if (!is_start_segment) {
                if (this.client.getProperty("start-segment").equals("false")) {
                    return data.length;
                }
            } else if (this.client.getProperty("start-segment").equals("false")) {
                this.client.setProperty("init-segment", "true");
                this.client.sendDataEvent(this.init_segment, this.video.getID(), "media_add_buffer", null);
                this.client.setProperty("start-segment", "true");
                this.client.sendEvent(this.video.getID(), "media_seek", new String[]{"time=" + this.getCurrentTime()});
            }
            this.client.sendDataEvent(data, this.video.getID(), "media_add_buffer", null);
            if (is_init) {
                this.client.setProperty("init-segment", "true");
            }
        }
        return data.length;
    }

    @Override
    public long seek(MediaCoder coder, long pos, int type) {
        JFLog.log("seek:" + pos + "," + type);
        return pos;
    }
}

