/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Random;
import javaforce.JFLog;
import javaforce.STUN;
import javaforce.voip.RTP;
import javaforce.voip.RTSP;
import javaforce.voip.RTSPClientInterface;
import javaforce.voip.RTSPInterface;
import javaforce.voip.RTSPSession;
import javaforce.voip.TransportType;

public class RTSPClient
extends RTSP
implements RTSPInterface,
STUN.Listener {
    private String remotehost;
    private String remoteip;
    private InetAddress remoteaddr;
    private int remoteport;
    private String user;
    private String pass;
    private RTSPClientInterface iface;
    private String localhost;
    private int localport;
    private static NAT nat = NAT.None;
    private static boolean useNATOnPrivateNetwork = false;
    private static String stunHost;
    private static String stunUser;
    private static String stunPass;
    private RTSPSession sess;
    public Object userobj;
    public int expires;
    private STUN stun;
    private final Object stunLock = new Object();
    private volatile boolean stunWaiting = false;
    private volatile boolean stunResponse = false;

    public String getUser() {
        return this.user;
    }

    public String getRemoteHost() {
        return this.remotehost;
    }

    public String getRemoteIP() {
        return this.remoteip;
    }

    public boolean init(String remotehost, int remoteport, int localport, RTSPClientInterface iface, TransportType type) {
        this.iface = iface;
        this.localport = localport;
        this.remoteport = remoteport;
        this.remotehost = remotehost;
        this.remoteip = this.resolve(remotehost);
        try {
            this.remoteaddr = InetAddress.getByName(this.remoteip);
            if (!(nat != NAT.STUN && nat != NAT.ICE || this.startSTUN())) {
                return false;
            }
            this.findlocalhost();
            JFLog.log(this.log, "localhost = " + this.localhost + " for remotehost = " + remotehost);
            if (this.remotehost.equals("127.0.0.1")) {
                this.remotehost = this.localhost;
                this.remoteip = this.resolve(this.remotehost);
                JFLog.log(this.log, "changed 127.0.0.1 to " + this.remotehost + " " + this.remoteip);
            }
            if (nat == NAT.STUN || nat == NAT.ICE) {
                this.stopSTUN();
            }
            this.sess = new RTSPSession(this.localhost);
            return super.init(this.localhost, localport, this, false, type);
        }
        catch (Exception e) {
            if (this.stun != null) {
                this.stopSTUN();
            }
            JFLog.log(this.log, (Throwable)e);
            return false;
        }
    }

    @Override
    public void uninit() {
        super.uninit();
    }

    public static void setNAT(NAT nat, String host, String user, String pass) {
        RTSPClient.nat = nat;
        stunHost = host;
        stunUser = user;
        stunPass = pass;
    }

    public static void useNATOnPrivateNetwork(boolean state) {
        useNATOnPrivateNetwork = state;
    }

    private String cleanString(String in) {
        return in.replaceAll("\"", "");
    }

    public void keepalive(String url) {
        this.get_parameter(url);
    }

    public static boolean isPrivateNetwork(String ip) {
        if (ip.startsWith("192.168.")) {
            return true;
        }
        if (ip.startsWith("10.")) {
            return true;
        }
        if (ip.startsWith("169.254.")) {
            return true;
        }
        for (int a = 16; a <= 31; ++a) {
            if (!ip.startsWith("172." + a + ".")) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getlocalRTPhost(RTSPSession sess) {
        if (RTP.useTURN) {
            return RTP.getTurnIP();
        }
        return sess.localhost;
    }

    private boolean findlocalhost_webserver(String host) {
        try {
            Socket s = new Socket();
            s.connect(new InetSocketAddress(host, 80), 1000);
            this.localhost = s.getLocalAddress().getHostAddress();
            try {
                s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            JFLog.log(this.log, "Detected IP connecting to WebServer at " + host);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean startSTUN() {
        this.stun = new STUN();
        return this.stun.start(this.localport, stunHost, stunUser, stunPass, this);
    }

    private void stopSTUN() {
        if (this.stun == null) {
            return;
        }
        this.stun.close();
        this.stun = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stunPublicIP(STUN stun, String ip, int port) {
        Object object = this.stunLock;
        synchronized (object) {
            if (this.stunWaiting) {
                this.stunResponse = true;
                this.stunLock.notify();
            }
        }
    }

    @Override
    public void turnAlloc(STUN stun, String ip, int port, byte[] token, int lifetime) {
    }

    @Override
    public void turnBind(STUN stun) {
    }

    @Override
    public void turnRefresh(STUN stun, int lifetime) {
    }

    @Override
    public void turnFailed(STUN stun) {
    }

    @Override
    public void turnData(STUN stun, byte[] data, int offset, int length, short channel) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findlocalhost_stun() {
        this.stunResponse = false;
        this.stunWaiting = true;
        Object object = this.stunLock;
        synchronized (object) {
            this.stun.requestPublicIP();
            try {
                this.stunLock.wait(1000L);
            }
            catch (Exception e) {
                JFLog.log(this.log, (Throwable)e);
            }
            this.stunWaiting = false;
        }
        if (this.stunResponse) {
            JFLog.log(this.log, "Detected IP using STUN");
        }
        return this.stunResponse;
    }

    private boolean findlocalhost_java() {
        try {
            InetAddress local = InetAddress.getLocalHost();
            this.localhost = local.getHostAddress();
            JFLog.log(this.log, "Detected IP using Java:" + this.localhost);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void findlocalhost() {
        JFLog.log(this.log, "Detecting localhost for remotehost = " + this.remotehost);
        if (!(!useNATOnPrivateNetwork && RTSPClient.isPrivateNetwork(this.remoteip) || nat != NAT.STUN && nat != NAT.ICE)) {
            if (this.findlocalhost_stun()) {
                return;
            }
            JFLog.log(this.log, "RTSP:STUN:Failed");
        }
        if (this.findlocalhost_webserver(this.remotehost)) {
            return;
        }
        if (this.findlocalhost_java()) {
            return;
        }
        Random r = new Random();
        this.localhost = "169.254." + r.nextInt(256) + "." + r.nextInt(256);
    }

    private boolean issue(RTSPSession sess, String cmd) {
        return this.issue(sess, cmd, false);
    }

    private boolean issue(RTSPSession sess, String cmd, boolean sessid) {
        JFLog.log(this.log, "sessid:" + sess.id + "\r\nissue command : " + cmd + " from : " + this.user + " to : " + this.remotehost);
        sess.remotehost = this.remoteip;
        sess.remoteport = this.remoteport;
        sess.cmd = cmd;
        StringBuilder req = new StringBuilder();
        req.append(cmd + " " + sess.uri + sess.extra + " RTSP/1.0\r\n");
        req.append("Cseq: " + sess.cseq++ + "\r\n");
        req.append("User-Agent: " + useragent + "\r\n");
        if (sess.epass != null) {
            req.append(sess.epass);
        }
        if (sess.transport != null) {
            req.append(sess.transport);
        }
        if (sessid) {
            req.append("Session: " + sess.id + "\r\n");
        }
        req.append("\r\n");
        return this.send(this.remoteaddr, this.remoteport, req.toString());
    }

    public void setUserPass(String user, String pass) {
        this.user = user;
        this.pass = pass;
    }

    public boolean options(String url) {
        this.sess.uri = url;
        this.sess.extra = "";
        return this.issue(this.sess, "OPTIONS");
    }

    public boolean describe(String url) {
        this.sess.uri = url;
        this.sess.extra = "";
        return this.issue(this.sess, "DESCRIBE");
    }

    public boolean setup(String url, int localrtpport, int trackid) {
        this.sess.transport = "Transport: RTP/AVP;unicast;client_port=" + localrtpport + "-" + (localrtpport + 1) + "\r\n";
        this.sess.uri = url;
        this.sess.extra = "/trackid=" + trackid;
        boolean result = this.issue(this.sess, "SETUP");
        this.sess.transport = null;
        return result;
    }

    public boolean play(String url) {
        this.sess.uri = url;
        this.sess.extra = "/";
        return this.issue(this.sess, "PLAY", true);
    }

    public boolean teardown(String url) {
        if (this.sess == null) {
            return false;
        }
        this.sess.uri = url;
        this.sess.extra = "/";
        return this.issue(this.sess, "TEARDOWN", true);
    }

    public boolean get_parameter(String url) {
        this.sess.uri = url;
        this.sess.extra = "/";
        return this.issue(this.sess, "GET_PARAMETER", true);
    }

    @Override
    public void packet(String[] msg, String remoteip, int remoteport) {
        try {
            if (!remoteip.equals(this.remoteip) || remoteport != this.remoteport) {
                JFLog.log(this.log, "Ignoring packet from unknown host:" + remoteip + ":" + remoteport);
                return;
            }
            String req = null;
            if (remoteip.equals("127.0.0.1")) {
                remoteip = this.sess.localhost;
            }
            this.sess.remotehost = remoteip;
            this.sess.remoteport = remoteport;
            this.sess.remotecseq = this.getcseq(msg);
            String sid = RTSPClient.getHeader("Session:", msg);
            if (sid != null) {
                int idx = sid.indexOf(59);
                if (idx != -1) {
                    sid = sid.substring(0, idx);
                }
                this.sess.id = Long.valueOf(sid);
            }
            this.sess.headers = msg;
            int type = this.getResponseType(msg);
            if (type != -1) {
                JFLog.log(this.log, "id:" + this.sess.id + "\r\nreply=" + type);
            } else {
                req = this.getRequest(msg);
                this.sess.uri = this.getURI(msg);
                JFLog.log(this.log, "id:" + this.sess.id + "\r\nrequest=" + req);
            }
            switch (type) {
                case 200: {
                    if (this.sess.cmd.equals("OPTIONS")) {
                        this.iface.onOptions(this);
                        break;
                    }
                    if (this.sess.cmd.equals("DESCRIBE")) {
                        this.iface.onDescribe(this, this.getSDP(msg));
                        break;
                    }
                    if (this.sess.cmd.equals("SETUP")) {
                        this.iface.onSetup(this);
                        break;
                    }
                    if (this.sess.cmd.equals("PLAY")) {
                        this.iface.onPlay(this);
                        break;
                    }
                    if (this.sess.cmd.equals("TEARDOWN")) {
                        this.iface.onTeardown(this);
                    }
                    break;
                }
                case 401: 
                case 407: {
                    if (this.sess.authsent) {
                        JFLog.log(this.log, "Server Error : Double " + type);
                        break;
                    }
                    this.sess.authstr = RTSPClient.getHeader("WWW-Authenticate:", msg);
                    if (this.sess.authstr == null) {
                        this.sess.authstr = RTSPClient.getHeader("Proxy-Authenticate:", msg);
                    }
                    if (this.sess.authstr == null) {
                        JFLog.log(this.log, "err:401/407 without Authenticate tag");
                        break;
                    }
                    this.sess.epass = this.getAuthResponse(this.sess, this.user, this.pass, this.remotehost, this.sess.cmd, type == 401 ? "Authorization:" : "Proxy-Authorization:");
                    if (this.sess.epass == null) {
                        JFLog.log(this.log, "err:gen auth failed");
                        break;
                    }
                    this.issue(this.sess, this.sess.cmd);
                    this.sess.authsent = true;
                    break;
                }
                default: {
                    this.sess.epass = null;
                    break;
                }
            }
        }
        catch (Exception e) {
            JFLog.log(this.log, (Throwable)e);
        }
    }

    public static enum NAT {
        None,
        STUN,
        TURN,
        ICE;

    }
}

