/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui;

import javaforce.LE;
import javaforce.gl.Matrix;
import javaforce.webui.Canvas;
import javaforce.webui.Panel;
import javaforce.webui.Resource;
import javaforce.webui.WebUIClient;
import javaforce.webui.WebUIHandler;
import javaforce.webui.WebUIServer;

public class TestGL
implements WebUIHandler {
    public Resource img;
    private String vs = "      attribute vec3 aVertexPosition;\n      attribute vec4 aVertexColor;\n\n      uniform mat4 uPMatrix;\n      uniform mat4 uMVMatrix;\n      \n      varying lowp vec4 vColor;\n\n      void main(void) {\n        gl_Position = uPMatrix * uMVMatrix * vec4(aVertexPosition, 1.0);\n        vColor = aVertexColor;\n      }\n";
    private String fs = "      varying lowp vec4 vColor;\n\n      void main(void) {\n        gl_FragColor = vColor;\n      }\n";
    private float[] colors = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f};
    private float[] vertices = new float[]{1.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, -1.0f, 0.0f, -1.0f, -1.0f, 0.0f};

    public static void main(String[] args) {
        new WebUIServer().start(new TestGL(), 8080, false);
    }

    @Override
    public void clientConnected(WebUIClient client) {
    }

    @Override
    public void clientDisconnected(WebUIClient client) {
    }

    @Override
    public byte[] getResource(String url) {
        return null;
    }

    public byte[] convertFloatArray(float[] m) {
        byte[] data = new byte[64];
        int off = 0;
        for (int a = 0; a < m.length; ++a) {
            LE.setuint32(data, off, Float.floatToIntBits(m[a]));
            off += 4;
        }
        return data;
    }

    @Override
    public Panel getRootPanel(WebUIClient client) {
        Panel panel = new Panel(){

            @Override
            public void onLoaded(String[] args) {
                Matrix pMatrix = new Matrix();
                pMatrix.perspective(45.0f, 1.3333334f, 0.1f, 100.0f);
                Matrix mMatrix = new Matrix();
                mMatrix.addTranslate(0.0f, 0.0f, -4.0f);
                Canvas canvas = (Canvas)this.getProperty("canvas");
                canvas.sendEvent("initwebgl", null);
                canvas.sendEvent("loadvs", new String[]{"src=" + TestGL.this.vs});
                canvas.sendEvent("loadfs", new String[]{"src=" + TestGL.this.fs});
                canvas.sendEvent("link", null);
                canvas.sendEvent("getuniform", new String[]{"idx=0", "name=uPMatrix"});
                canvas.sendEvent("getuniform", new String[]{"idx=1", "name=uMVMatrix"});
                canvas.sendEvent("getattrib", new String[]{"idx=0", "name=aVertexPosition"});
                canvas.sendEvent("getattrib", new String[]{"idx=1", "name=aVertexColor"});
                canvas.sendData(TestGL.this.convertFloatArray(pMatrix.m));
                canvas.sendEvent("matrix", new String[]{"idx=0"});
                canvas.sendData(TestGL.this.convertFloatArray(mMatrix.m));
                canvas.sendEvent("matrix", new String[]{"idx=1"});
                canvas.sendData(TestGL.this.convertFloatArray(TestGL.this.vertices));
                canvas.sendEvent("buffer", new String[]{"idx=0"});
                canvas.sendData(TestGL.this.convertFloatArray(TestGL.this.colors));
                canvas.sendEvent("buffer", new String[]{"idx=1"});
                canvas.sendEvent("array", new String[]{"idx=0"});
                canvas.sendEvent("r_matrix", new String[]{"idx=0", "uidx=0", "midx=0"});
                canvas.sendEvent("r_matrix", new String[]{"idx=0", "uidx=1", "midx=1"});
                canvas.sendEvent("r_attrib", new String[]{"idx=0", "aidx=0", "bufidx=0", "cnt=3"});
                canvas.sendEvent("r_attrib", new String[]{"idx=0", "aidx=1", "bufidx=1", "cnt=4"});
                canvas.sendEvent("r_drawArrays", new String[]{"idx=0", "type=5", "cnt=4"});
            }
        };
        Canvas canvas = new Canvas();
        canvas.setSize(640, 480);
        panel.add(canvas);
        panel.setProperty("canvas", canvas);
        return panel;
    }
}

