/*
 * Decompiled with CFR 0.152.
 */
package javaforce.awt;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javaforce.JFTask;
import javaforce.JFTaskListener;
import javaforce.awt.JFAWT;
import javaforce.awt.ViewLog;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;

public class ProgressDialog
extends JDialog
implements JFTaskListener {
    private JButton cancel;
    private JButton close;
    private JLabel msg;
    private JProgressBar progress;
    private JFTask task;
    private boolean indeterminate = true;
    private boolean taskStarted = false;
    private boolean autoClose = false;

    public ProgressDialog(Frame parent, boolean modal, JFTask task) {
        super(parent, modal);
        this.initComponents();
        this.setPosition();
        this.task = task;
    }

    private void initComponents() {
        this.progress = new JProgressBar();
        this.close = new JButton();
        this.cancel = new JButton();
        this.msg = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ProgressDialog.this.formWindowClosing(evt);
            }
        });
        this.close.setText("Close");
        this.close.setEnabled(false);
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgressDialog.this.closeActionPerformed(evt);
            }
        });
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgressDialog.this.cancelActionPerformed(evt);
            }
        });
        this.msg.setText("...");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.progress, -1, 382, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.cancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.close)).addComponent(this.msg, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.msg).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progress, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.close).addComponent(this.cancel)).addContainerGap()));
        this.pack();
    }

    private void cancelActionPerformed(ActionEvent evt) {
        String results = (String)this.task.getProperty("results");
        if (results == null) {
            this.task.abort();
        } else {
            ViewLog log = new ViewLog(results.getBytes());
            log.setVisible(true);
        }
    }

    private void closeActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.task.abort();
    }

    @Override
    public void done() {
        if (this.autoClose) {
            this.dispose();
            return;
        }
        if (this.task.getProperty("results") == null) {
            this.cancel.setEnabled(false);
        } else {
            this.cancel.setText("Details");
        }
        this.close.setEnabled(true);
        JFAWT.assignHotKey(this, this.close, 10);
    }

    @Override
    public void setProgress(int value) {
        if (value == -1) {
            this.progress.setIndeterminate(true);
            this.indeterminate = true;
        } else {
            if (this.indeterminate) {
                this.progress.setIndeterminate(false);
                this.indeterminate = false;
            }
            this.progress.setValue(value);
        }
    }

    @Override
    public void setLabel(String txt) {
        this.msg.setText(txt);
    }

    public boolean getStatus() {
        return this.task.getStatus();
    }

    private void setPosition() {
        Rectangle s = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        Dimension d = this.getSize();
        this.setLocation(s.width / 2 - d.width / 2, s.height / 2 - d.height / 2);
    }

    @Override
    public void setVisible(boolean state) {
        if (state && !this.taskStarted) {
            this.task.start(this);
            this.taskStarted = true;
        }
        super.setVisible(state);
    }

    public void setAutoClose(boolean state) {
        this.autoClose = state;
    }
}

