/*
 * Decompiled with CFR 0.152.
 */
package javaforce.linux;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Properties;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.JFTask;
import javaforce.ShellProcess;
import javaforce.XML;
import javaforce.awt.ProgressDialog;
import javaforce.jni.LnxNative;
import javaforce.linux.X11Listener;

public class Linux {
    public static DistroTypes distro = DistroTypes.Unknown;
    private static String[][] pkgList;
    private static final int None = 0;
    private static final int CurrentTime = 0;
    private static final int ShiftMask = 1;
    private static final int True = 1;
    private static final int False = 0;
    private static final int KeyPress = 2;
    private static final int KeyRelease = 3;
    private static final int CreateNotify = 16;
    private static final int DestroyNotify = 17;
    private static final int UnmapNotify = 18;
    private static final int MapNotify = 19;
    private static final int ReparentNotify = 21;
    private static final int ConfigureNotify = 22;
    private static final int PropertyNotify = 28;
    private static final int ClientMessage = 33;
    private static final int KeyPressMask = 1;
    private static final int KeyReleaseMask = 2;
    private static final int StructureNotifyMask = 131072;
    private static final int SubstructureNotifyMask = 524288;
    private static final int PropertyChangeMask = 0x400000;
    private static ArrayList<Window> currentList;
    private static Object currentListLock;
    public static final int P_NONE = 0;
    public static final int P_LEFT = 1;
    public static final int P_ABOVE = 2;
    public static final int P_RIGHT = 3;
    public static final int P_BELOW = 4;
    public static final int P_SAME = 5;
    public static final int R_NORMAL = 0;
    public static final int R_RIGHT = 1;
    public static final int R_LEFT = 2;
    public static final int R_INVERTED = 3;
    public static ArrayList<Screen> screens;
    private static final int PAM_SILENT = 32768;
    private static final int PAM_PROMPT_ECHO_ON = 2;
    private static final int PAM_PROMPT_ECHO_OFF = 1;
    private static String pam_user;
    private static String pam_pass;
    private static long pam_responses;
    public static final int SIGKILL = 9;
    public static final int SIGTERM = 15;

    public static String getVersion() {
        return JF.getVersion();
    }

    public static boolean detectDistro() {
        if (distro != DistroTypes.Unknown) {
            return true;
        }
        try {
            File lsb = new File("/etc/os-release");
            if (lsb.exists()) {
                FileInputStream fis = new FileInputStream(lsb);
                Properties props = new Properties();
                props.load(fis);
                fis.close();
                String id = props.getProperty("ID");
                if (id.equals("debian") || id.equals("ubuntu")) {
                    distro = DistroTypes.Ubuntu;
                    JFLog.log("Detected Linux:debian");
                    return true;
                }
                if (id.equals("fedora")) {
                    distro = DistroTypes.Fedora;
                    JFLog.log("Detected Linux:fedora");
                    return true;
                }
                if (id.equals("arch")) {
                    distro = DistroTypes.Arch;
                    JFLog.log("Detected Linux:arch");
                    return true;
                }
            }
            JFLog.log("Error:Unknown distro");
        }
        catch (Exception e) {
            JFLog.log(e);
        }
        return false;
    }

    public static boolean ubuntuAddRepo(String ppa) {
        ShellProcess sp = new ShellProcess();
        sp.removeEnvironmentVariable("TERM");
        sp.addEnvironmentVariable("DEBIAN_FRONTEND", "noninteractive");
        String output = sp.run(new String[]{"sudo", "-E", "add-apt-repository", ppa}, true);
        return output != null;
    }

    public static boolean mkdir(String folder) {
        ShellProcess sp = new ShellProcess();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("sudo");
        cmd.add("mkdir");
        cmd.add("-p");
        cmd.add(folder);
        String output = sp.run(cmd, false);
        if (output == null) {
            JFLog.log("Failed to exec mkdir");
            return false;
        }
        if (output.length() > 0) {
            JFLog.log("Error:" + output);
            return false;
        }
        return true;
    }

    public static boolean copyFile(String src, String dst) {
        ShellProcess sp = new ShellProcess();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("sudo");
        cmd.add("cp");
        cmd.add(src);
        cmd.add(dst);
        String output = sp.run(cmd, false);
        if (output == null) {
            JFLog.log("Failed to exec cp");
            return false;
        }
        if (output.length() > 0) {
            JFLog.log("Error:" + output);
            return false;
        }
        return true;
    }

    public static boolean createLink(String target, String link) {
        ShellProcess sp = new ShellProcess();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("sudo");
        cmd.add("ln");
        cmd.add("-s");
        cmd.add(target);
        cmd.add(link);
        String output = sp.run(cmd, false);
        if (output == null) {
            JFLog.log("Failed to exec ln");
            return false;
        }
        if (output.length() > 0) {
            JFLog.log("Error:" + output);
            return false;
        }
        return true;
    }

    public static boolean deleteFile(String file) {
        ShellProcess sp = new ShellProcess();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("sudo");
        cmd.add("rm");
        cmd.add("-f");
        cmd.add(file);
        String output = sp.run(cmd, false);
        if (output == null) {
            JFLog.log("Failed to exec ln");
            return false;
        }
        if (output.length() > 0) {
            JFLog.log("Error:" + output);
            return false;
        }
        return true;
    }

    public static boolean restartService(String name) {
        ShellProcess sp = new ShellProcess();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("sudo");
        cmd.add("systemctl");
        cmd.add("restart");
        cmd.add(name);
        String output = sp.run(cmd, false);
        if (output == null) {
            JFLog.log("Failed to exec service");
            return false;
        }
        if (sp.getErrorLevel() != 0) {
            JFLog.log("Error:" + output);
            return false;
        }
        return true;
    }

    public static boolean restartJFService(String name) {
        ShellProcess sp = new ShellProcess();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("sudo");
        cmd.add("jfservice");
        cmd.add("restart");
        cmd.add(name);
        String output = sp.run(cmd, false);
        if (output == null) {
            JFLog.log("Failed to exec jfservice");
            return false;
        }
        if (sp.getErrorLevel() != 0) {
            JFLog.log("Error:" + output);
            return false;
        }
        return true;
    }

    public static boolean ubuntuUpdate() {
        ShellProcess sp = new ShellProcess();
        sp.removeEnvironmentVariable("TERM");
        sp.addEnvironmentVariable("DEBIAN_FRONTEND", "noninteractive");
        String output = sp.run(new String[]{"sudo", "-E", "apt", "--yes", "update"}, true);
        return output != null;
    }

    private static boolean apt(String action, String pkg, String desc) {
        JFTask task = new JFTask(){

            @Override
            public boolean work() {
                this.setProgress(-1);
                String action = (String)this.getProperty("action");
                String pkg = (String)this.getProperty("pkg");
                String desc = (String)this.getProperty("desc");
                this.setLabel((action.equals("install") ? "Installing " : "Removing ") + desc);
                ShellProcess sp = new ShellProcess();
                sp.removeEnvironmentVariable("TERM");
                sp.addEnvironmentVariable("DEBIAN_FRONTEND", "noninteractive");
                String output = sp.run(new String[]{"sudo", "-E", "apt", "--yes", action, pkg}, true);
                if (output == null) {
                    this.setLabel("Failed to exec apt");
                    JFLog.log("Failed to exec apt");
                    return false;
                }
                JFLog.log(output);
                this.setProperty("results", output);
                if (output.indexOf("Unable to locate package") != -1) {
                    this.setLabel("Package not found");
                    JFLog.log("Package not found");
                    return false;
                }
                this.setLabel("Complete");
                this.setProgress(100);
                return true;
            }
        };
        task.setProperty("action", action);
        task.setProperty("pkg", pkg);
        task.setProperty("desc", desc);
        new ProgressDialog(null, true, task).setVisible(true);
        return task.getStatus();
    }

    private static boolean yum(String action, String pkg, String desc) {
        JFTask task = new JFTask(){

            @Override
            public boolean work() {
                this.setProgress(-1);
                String action = (String)this.getProperty("action");
                String pkg = (String)this.getProperty("pkg");
                String desc = (String)this.getProperty("desc");
                this.setLabel((action.equals("install") ? "Installing " : "Removing ") + desc);
                ShellProcess sp = new ShellProcess();
                sp.removeEnvironmentVariable("TERM");
                String output = sp.run(new String[]{"sudo", "-E", "yum", "-y", action, pkg}, false);
                if (output == null) {
                    this.setLabel("Failed to exec yum");
                    JFLog.log("Failed to exec yum");
                    return false;
                }
                JFLog.log(output);
                this.setProperty("results", output);
                this.setLabel("Complete");
                this.setProgress(100);
                return true;
            }
        };
        task.setProperty("action", action);
        task.setProperty("pkg", pkg);
        task.setProperty("desc", desc);
        new ProgressDialog(null, true, task).setVisible(true);
        return task.getStatus();
    }

    private static boolean pacman(String action, String pkg, String desc) {
        JFTask task = new JFTask(){

            @Override
            public boolean work() {
                this.setProgress(-1);
                String action = (String)this.getProperty("action");
                String pkg = (String)this.getProperty("pkg");
                String desc = (String)this.getProperty("desc");
                this.setLabel((action.equals("install") ? "Installing " : "Removing ") + desc);
                ShellProcess sp = new ShellProcess();
                sp.removeEnvironmentVariable("TERM");
                String output = sp.run(new String[]{"sudo", "-E", "pacman", action, "--noconfirm", pkg}, false);
                if (output == null) {
                    this.setLabel("Failed to exec pacman");
                    JFLog.log("Failed to exec pacman");
                    return false;
                }
                JFLog.log(output);
                this.setProperty("results", output);
                this.setLabel("Complete");
                this.setProgress(100);
                return true;
            }
        };
        task.setProperty("action", action);
        task.setProperty("pkg", pkg);
        task.setProperty("desc", desc);
        new ProgressDialog(null, true, task).setVisible(true);
        return task.getStatus();
    }

    public static boolean installPackage(String pkg, String desc) {
        Linux.detectDistro();
        switch (distro.ordinal()) {
            case 1: {
                return Linux.apt("install", pkg, desc);
            }
            case 2: {
                return Linux.yum("install", pkg, desc);
            }
            case 3: {
                return Linux.pacman("-S", pkg, desc);
            }
        }
        return false;
    }

    public static boolean removePackage(String pkg, String desc) {
        Linux.detectDistro();
        switch (distro.ordinal()) {
            case 1: {
                return Linux.apt("autoremove", pkg, desc);
            }
            case 2: {
                return Linux.yum("remove", pkg, desc);
            }
            case 3: {
                return Linux.pacman("-R", pkg, desc);
            }
        }
        return false;
    }

    public static boolean setExec(String file) {
        ShellProcess sp = new ShellProcess();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("sudo");
        cmd.add("chmod");
        cmd.add("+x");
        cmd.add(file);
        String output = sp.run(cmd, false);
        if (output == null) {
            JFLog.log("Failed to exec chmod");
            return false;
        }
        if (output.length() > 0) {
            JFLog.log("Error:" + output);
            return false;
        }
        return true;
    }

    private static String[][] ubuntu_searchPackages(String regex) {
        ShellProcess sp = new ShellProcess();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("apt-cache");
        cmd.add("search");
        cmd.add(regex);
        String output = sp.run(cmd, false);
        if (output == null) {
            JFLog.log("Error:unable to execute apt-cache");
            return null;
        }
        String[] lns = output.split("\n");
        String[][] ret = new String[lns.length][2];
        for (int a = 0; a < lns.length; ++a) {
            String[] f = lns[a].split(" - ");
            if (f.length != 2) continue;
            ret[a][0] = f[0];
            ret[a][1] = f[1];
        }
        return ret;
    }

    private static String[][] fedora_searchPackages(String regex) {
        ShellProcess sp = new ShellProcess();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("yum");
        cmd.add("search");
        cmd.add(regex);
        String output = sp.run(cmd, false);
        if (output == null) {
            JFLog.log("Error:unable to execute yum");
            return null;
        }
        String[] lns = output.split("\n");
        String[][] ret = new String[lns.length][2];
        for (int a = 0; a < lns.length; ++a) {
            String[] f = lns[a].split(" : ");
            if (f.length != 2) continue;
            ret[a][0] = f[0];
            ret[a][1] = f[1];
        }
        return ret;
    }

    private static String[][] arch_searchPackages(String regex) {
        ShellProcess sp = new ShellProcess();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("pacman");
        cmd.add("-Ss");
        cmd.add(regex);
        String output = sp.run(cmd, false);
        if (output == null) {
            JFLog.log("Error:unable to execute pacman");
            return null;
        }
        String[] lns = output.split("\n");
        String[][] ret = new String[lns.length / 2][2];
        int idx = 0;
        for (int a = 0; a < lns.length; a += 2) {
            String ln1 = lns[a];
            String ln2 = lns[a + 1];
            int i1 = ln1.indexOf(47);
            int i2 = ln1.indexOf(32);
            String name = ln1.substring(i1, i2);
            String ver = ln1.substring(i2 + 1);
            String desc = ln2.substring(4);
            ret[idx][0] = name;
            ret[idx][1] = desc;
            ++idx;
        }
        return ret;
    }

    public static String[][] searchPackages(String regex) {
        Linux.detectDistro();
        switch (distro.ordinal()) {
            case 1: {
                return Linux.ubuntu_searchPackages(regex);
            }
            case 2: {
                return Linux.fedora_searchPackages(regex);
            }
            case 3: {
                return Linux.arch_searchPackages(regex);
            }
        }
        return null;
    }

    public static void ubuntu_updateInstalled() {
        ShellProcess sp = new ShellProcess();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("dpkg");
        cmd.add("-l");
        String output = sp.run(cmd, false);
        if (output == null) {
            JFLog.log("Error:unable to execute dpkg");
            return;
        }
        String[] lns = output.split("\n");
        pkgList = new String[lns.length - 5][3];
        for (int a = 5; a < lns.length; ++a) {
            String[] f = lns[a].split(" +", 4);
            Linux.pkgList[a - 5][0] = f[1];
            Linux.pkgList[a - 5][1] = f[3];
            Linux.pkgList[a - 5][2] = f[0].charAt(0) == 'i' ? "true" : "false";
        }
    }

    public static void fedora_updateInstalled() {
        ShellProcess sp = new ShellProcess();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("yum");
        cmd.add("list");
        cmd.add("installed");
        String output = sp.run(cmd, false);
        if (output == null) {
            JFLog.log("Error:unable to execute yum");
            return;
        }
        String[] lns = output.split("\n");
        pkgList = new String[lns.length - 2][3];
        for (int a = 2; a < lns.length; ++a) {
            String[] f = lns[a].split(" +");
            if (f.length != 3) {
                Linux.pkgList[a - 2][0] = "";
                Linux.pkgList[a - 2][1] = "";
                Linux.pkgList[a - 2][2] = "";
                continue;
            }
            int idx = f[0].lastIndexOf(".");
            Linux.pkgList[a - 2][0] = idx == -1 ? f[0] : f[0].substring(0, idx);
            Linux.pkgList[a - 2][1] = f[1];
            Linux.pkgList[a - 2][2] = "true";
        }
    }

    public static void arch_updateInstalled() {
        ShellProcess sp = new ShellProcess();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("pacman");
        cmd.add("-Ss");
        String output = sp.run(cmd, false);
        if (output == null) {
            JFLog.log("Error:unable to execute pacman");
        }
        String[] lns = output.split("\n");
        int idx = 0;
        for (int a = 0; a < lns.length; a += 2) {
            String ln1 = lns[a];
            String ln2 = lns[a + 1];
            String[] fs2 = ln2.split(" ");
            int i1 = ln1.indexOf(47);
            int i2 = ln1.indexOf(32);
            String name = ln1.substring(i1, i2);
            String ver = ln1.substring(i2 + 1);
            String desc = ln2.substring(4);
            Linux.pkgList[idx][0] = name;
            Linux.pkgList[idx][1] = desc;
            Linux.pkgList[idx][1] = fs2.length == 3 ? "true" : "false";
            ++idx;
        }
    }

    public static void updateInstalled() {
        Linux.detectDistro();
        switch (distro.ordinal()) {
            case 1: {
                Linux.ubuntu_updateInstalled();
                break;
            }
            case 2: {
                Linux.fedora_updateInstalled();
                break;
            }
            case 3: {
                Linux.arch_updateInstalled();
            }
        }
    }

    public static boolean isInstalled(String pkg) {
        if (pkg == null) {
            return true;
        }
        if (pkgList == null) {
            Linux.updateInstalled();
        }
        for (int a = 0; a < pkgList.length; ++a) {
            if (!pkgList[a][0].equals(pkg)) continue;
            return pkgList[a][2].equals("true");
        }
        return false;
    }

    public static String getPackageDesc(String pkg) {
        if (pkg == null) {
            return "";
        }
        if (pkgList == null) {
            Linux.updateInstalled();
            if (pkgList == null) {
                return "";
            }
        }
        for (int a = 0; a < pkgList.length; ++a) {
            if (!pkgList[a][0].equals(pkg)) continue;
            return pkgList[a][1];
        }
        return "";
    }

    public static boolean isMemberOf(String user, String group) {
        try {
            ShellProcess sp = new ShellProcess();
            String output = sp.run(new String[]{"groups", user}, false).replaceAll("\n", "");
            String[] groups = output.split(" ");
            for (int a = 2; a < groups.length; ++a) {
                if (!groups[a].equals(group)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    private static String expandQuotes(String inString) {
        int i1;
        while ((i1 = ((String)inString).indexOf(34)) != -1) {
            int i2 = ((String)inString).indexOf(34, i1 + 1);
            if (i2 == -1) {
                return inString;
            }
            inString = ((String)inString).substring(0, i1) + ((String)inString).substring(i1 + 1, i2).replace(' ', '\u1234') + ((String)inString).substring(i2 + 1);
        }
        return inString;
    }

    private static String[] expandBackslash(String inString) {
        StringBuilder out = new StringBuilder();
        char[] inCA = inString.toCharArray();
        for (int a = 0; a < inCA.length; ++a) {
            if (inCA[a] == '\\' && inCA[a + 1] == '\\') {
                if (inCA[a + 2] == '\\') {
                    if (inCA[a + 3] == '\\') {
                        out.append('\\');
                        out.append('\\');
                        a += 3;
                        continue;
                    }
                } else {
                    if (inCA[a + 2] == ' ') {
                        out.append('\u1234');
                        a += 2;
                        continue;
                    }
                    out.append('\\');
                    ++a;
                    continue;
                }
            }
            out.append(inCA[a]);
        }
        String[] cmd = out.toString().split(" ");
        for (int a = 0; a < cmd.length; ++a) {
            if (cmd[a].indexOf(4660) == -1) continue;
            cmd[a] = cmd[a].replace('\u1234', ' ');
        }
        return cmd;
    }

    public static String[] expandDesktopExec(String exec, String file) {
        if (file == null) {
            file = "";
        }
        file = "\"" + (String)file + "\"";
        exec = exec.replaceAll("%f", (String)file);
        exec = exec.replaceAll("%F", (String)file);
        exec = exec.replaceAll("%u", (String)file);
        exec = exec.replaceAll("%U", (String)file);
        exec = Linux.expandQuotes(exec);
        return Linux.expandBackslash(exec);
    }

    public static String[] expandDesktopExec(String exec, String[] file) {
        Object files = "";
        if (file != null) {
            for (int a = 0; a < file.length; ++a) {
                if (a > 0) {
                    files = (String)files + " ";
                }
                files = (String)files + "\"" + file[a] + "\"";
            }
        } else {
            file = new String[]{""};
        }
        exec = exec.replaceAll("%f", "\"" + file[0] + "\"");
        exec = exec.replaceAll("%F", (String)files);
        exec = exec.replaceAll("%u", "\"" + file[0] + "\"");
        exec = exec.replaceAll("%U", (String)files);
        exec = Linux.expandQuotes(exec);
        return Linux.expandBackslash(exec);
    }

    public static boolean executeDesktop(String desktop, String[] file) {
        try {
            Properties props = new Properties();
            FileInputStream fis = new FileInputStream(desktop);
            props.load(fis);
            fis.close();
            String exec = props.getProperty("Exec");
            String path = props.getProperty("Path");
            if (!(path != null && path.length() != 0 || (path = System.getenv("HOME")) != null && path.length() != 0)) {
                path = "/";
            }
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.directory(new File(path));
            String[] expand = Linux.expandDesktopExec(exec, file);
            pb.command(expand);
            pb.start();
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public static int detectBits() {
        if (new File("/usr/lib64").exists()) {
            return 64;
        }
        return 32;
    }

    public static boolean runScript(String[] lns) {
        try {
            File tmpFile = File.createTempFile("script", ".sh", new File("/tmp"));
            FileOutputStream fos = new FileOutputStream(tmpFile);
            fos.write("#!/bin/bash\n".getBytes());
            for (int a = 0; a < lns.length; ++a) {
                fos.write((lns[a] + "\n").getBytes());
            }
            fos.close();
            tmpFile.setExecutable(true);
            ShellProcess sp = new ShellProcess();
            String output = sp.run(new String[]{"sudo", tmpFile.getAbsolutePath()}, true);
            tmpFile.delete();
            return sp.getErrorLevel() == 0;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public static boolean init() {
        return true;
    }

    public static long x11_get_id(java.awt.Window w) {
        return LnxNative.x11_get_id(w);
    }

    public static void x11_set_desktop(long xid) {
        LnxNative.x11_set_desktop(xid);
    }

    public static void x11_set_dock(long xid) {
        LnxNative.x11_set_dock(xid);
    }

    public static void x11_set_strut(long xid, int panelHeight, int x, int y, int width, int height) {
        LnxNative.x11_set_strut(xid, panelHeight, x, y, width, height);
    }

    public static void x11_set_listener(X11Listener cb) {
        LnxNative.x11_set_listener(cb);
    }

    public static void x11_tray_main(long pid, int screenWidth, int trayPos, int trayHeight) {
        LnxNative.x11_tray_main(pid, screenWidth, trayPos, trayHeight);
    }

    public static void x11_tray_reposition(int screenWidth, int trayPos, int trayHeight) {
        LnxNative.x11_tray_reposition(screenWidth, trayPos, trayHeight);
    }

    public static void x11_tray_stop() {
        LnxNative.x11_tray_stop();
    }

    public static int x11_tray_width() {
        return LnxNative.x11_tray_width();
    }

    public static void x11_window_list_main() {
        LnxNative.x11_window_list_main();
    }

    public static void x11_window_list_stop() {
        LnxNative.x11_window_list_stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Window[] x11_get_window_list() {
        Object object = currentListLock;
        synchronized (object) {
            return currentList.toArray(new Window[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void x11_window_add(long xid, int pid, String title, String name, String res_name, String res_class) {
        Window window = new Window(xid, pid, title, name, res_name, res_class);
        Object object = currentListLock;
        synchronized (object) {
            int cnt = currentList.size();
            for (int a = 0; a < cnt; ++a) {
                if (Linux.currentList.get((int)a).xid != xid) continue;
                currentList.set(a, window);
                return;
            }
            currentList.add(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void x11_window_del(long xid) {
        Object object = currentListLock;
        synchronized (object) {
            int cnt = currentList.size();
            for (int a = 0; a < cnt; ++a) {
                if (Linux.currentList.get((int)a).xid != xid) continue;
                currentList.remove(a);
                return;
            }
        }
    }

    public static void x11_minimize_all() {
        LnxNative.x11_minimize_all();
    }

    public static void x11_raise_window(long xid) {
        LnxNative.x11_raise_window(xid);
    }

    public static void x11_map_window(long xid) {
        LnxNative.x11_map_window(xid);
    }

    public static void x11_unmap_window(long xid) {
        LnxNative.x11_unmap_window(xid);
    }

    public static int x11_keysym_to_keycode(char keysym) {
        return LnxNative.x11_keysym_to_keycode(keysym);
    }

    public static boolean x11_send_event(int keycode, boolean down) {
        return LnxNative.x11_send_event(keycode, down);
    }

    public static boolean x11_send_event(long id, int keycode, boolean down) {
        return LnxNative.x11_send_event(id, keycode, down);
    }

    public static Monitor[] x11_rr_get_setup(Monitor[] config) {
        screens.clear();
        Screen screen = null;
        Port port = null;
        Size size = null;
        ArrayList<Monitor> newConfig = new ArrayList<Monitor>();
        ShellProcess sp = new ShellProcess();
        String output = sp.run(new String[]{"xrandr"}, false);
        String[] lns = output.split("\n");
        for (int a = 0; a < lns.length; ++a) {
            int i1;
            if (lns[a].length() == 0) continue;
            if (lns[a].startsWith("Screen ")) {
                screen = new Screen();
                i1 = lns[a].indexOf(" ");
                int i2 = lns[a].indexOf(":");
                screen.idx = JF.atoi(lns[a].substring(i1 + 1, i2));
                screens.add(screen);
                continue;
            }
            if (lns[a].startsWith(" ")) {
                if (port == null) {
                    JFLog.log("Error:XRandR size line without monitor");
                    continue;
                }
                if (!port.connected) continue;
                size = new Size();
                String[] f = lns[a].trim().split(" +");
                size.size = f[0];
                boolean bl = size.active = f[1].indexOf("*") != -1;
                if (size.active) {
                    port.hasActiveSize = true;
                }
                size.preferred = f[1].indexOf("+") != -1 || f.length > 2 && f[2].equals("+");
                port.sizes.add(size);
                continue;
            }
            port = new Port();
            i1 = lns[a].indexOf(" ");
            port.name = lns[a].substring(0, i1);
            port.connected = lns[a].substring(i1 + 1).startsWith("connected");
            screen.ports.add(port);
        }
        if (config == null) {
            config = new Monitor[]{};
        }
        for (int b = 0; b < screens.size(); ++b) {
            screen = screens.get(b);
            for (int c = 0; c < screen.ports.size(); ++c) {
                port = screen.ports.get(c);
                if (!port.connected) continue;
                Monitor monitor = new Monitor();
                monitor.name = port.name;
                for (int a = 0; a < config.length; ++a) {
                    Monitor other = config[a];
                    if (!other.name.equals(port.name)) continue;
                    monitor.res = other.res;
                    monitor.mirror = other.mirror;
                    monitor.relpos = other.relpos;
                    monitor.relName = other.relName;
                    monitor.rotate = other.rotate;
                    break;
                }
                if (monitor.res.length() == 0) {
                    int s;
                    if (port.hasActiveSize) {
                        for (s = 0; s < port.sizes.size(); ++s) {
                            size = port.sizes.get(s);
                            if (!size.active) continue;
                            monitor.res = size.size;
                            break;
                        }
                    } else {
                        for (s = 0; s < port.sizes.size(); ++s) {
                            size = port.sizes.get(s);
                            if (!size.preferred) continue;
                            monitor.res = size.size;
                            break;
                        }
                    }
                    if (monitor.res.length() == 0) {
                        if (port.sizes.size() > 0) {
                            monitor.res = port.sizes.get((int)0).size;
                        } else {
                            JFLog.log("Warning:Monitor " + monitor.name + " has no sizes, trying 800x600");
                            monitor.res = "800x600";
                        }
                    }
                }
                newConfig.add(monitor);
            }
        }
        return Linux.x11_rr_arrangeMonitors(newConfig.toArray(new Monitor[0]));
    }

    public static Monitor[] x11_rr_arrangeMonitors(Monitor[] monitors) {
        for (int m = 1; m < monitors.length; ++m) {
            boolean ok;
            Monitor monitor = monitors[m];
            if (monitor.mirror) {
                monitor.relpos = 5;
                String mirrorName = monitor.relName;
                ok = false;
                for (int c = 0; c < monitors.length; ++c) {
                    if (!monitors[c].name.equals(mirrorName) || monitors[c].mirror) continue;
                    ok = true;
                    break;
                }
                if (ok) continue;
                monitor.relpos = 0;
                monitor.relName = "";
            }
            if (monitor.relpos != 0 && monitor.relpos != 5) {
                Monitor path = monitor;
                ok = true;
                while (ok && path != monitors[0]) {
                    String parent = path.relName;
                    Monitor thisMonitor = path;
                    for (int c = 0; c < monitors.length; ++c) {
                        if (!monitors[c].name.equals(parent)) continue;
                        path = monitors[c];
                        break;
                    }
                    if (thisMonitor == path) {
                        ok = false;
                    }
                    if (path != monitor) continue;
                    ok = false;
                }
                if (ok) continue;
            }
            Monitor rightMonitor = null;
            String relName = monitors[0].name;
            boolean left = false;
            boolean right = false;
            boolean above = false;
            boolean below = false;
            for (int c = 1; c < monitors.length; ++c) {
                if (!monitors[c].name.equals(relName)) continue;
                if (monitors[c].relpos == 1) {
                    left = true;
                    continue;
                }
                if (monitors[c].relpos == 3) {
                    right = true;
                    rightMonitor = monitors[c];
                    continue;
                }
                if (monitors[c].relpos == 2) {
                    above = true;
                    continue;
                }
                if (monitors[c].relpos != 4) continue;
                below = true;
            }
            monitor.relName = monitors[0].name;
            if (!right) {
                monitor.relpos = 3;
                continue;
            }
            if (!below) {
                monitor.relpos = 4;
                continue;
            }
            if (!left) {
                monitor.relpos = 1;
                continue;
            }
            if (!above) {
                monitor.relpos = 2;
                continue;
            }
            relName = rightMonitor.name;
            boolean cont = false;
            block5: do {
                cont = false;
                for (int c = 1; c < monitors.length; ++c) {
                    if (!monitors[c].relName.equals(relName) || monitors[c].relpos != 3) continue;
                    cont = true;
                    rightMonitor = monitors[c];
                    relName = rightMonitor.name;
                    continue block5;
                }
            } while (cont);
            monitor.relName = rightMonitor.name;
            monitor.relpos = 3;
        }
        return monitors;
    }

    public static void x11_rr_auto() {
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"xrandr", "--auto"});
            p.waitFor();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public static void x11_rr_set(Monitor[] config) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("xrandr");
        for (int a = 0; a < config.length; ++a) {
            cmd.add("--output");
            cmd.add(config[a].name);
            cmd.add("--mode");
            cmd.add(config[a].res);
            cmd.add("--rotate");
            switch (config[a].rotate) {
                case 0: {
                    cmd.add("normal");
                    break;
                }
                case 2: {
                    cmd.add("left");
                    break;
                }
                case 1: {
                    cmd.add("right");
                    break;
                }
                case 3: {
                    cmd.add("inverted");
                }
            }
            if (config[a].relpos == 0) continue;
            switch (config[a].relpos) {
                case 1: {
                    cmd.add("--left-of");
                    break;
                }
                case 3: {
                    cmd.add("--right-of");
                    break;
                }
                case 2: {
                    cmd.add("--above");
                    break;
                }
                case 4: {
                    cmd.add("--below");
                    break;
                }
                case 5: {
                    cmd.add("--same-as");
                }
            }
            cmd.add(config[a].relName);
        }
        try {
            Process p = Runtime.getRuntime().exec(cmd.toArray(new String[0]));
            p.waitFor();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public static void x11_rr_reset(String res) {
        Monitor[] config = Linux.x11_rr_get_setup(null);
        if (config == null || config.length == 0) {
            return;
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("xrandr");
        cmd.add("--output");
        cmd.add(config[0].name);
        cmd.add("--mode");
        cmd.add(res);
        cmd.add("--rotate");
        cmd.add("normal");
        for (int a = 1; a < config.length; ++a) {
            cmd.add("--output");
            cmd.add(config[a].name);
            cmd.add("--off");
        }
        try {
            Process p = Runtime.getRuntime().exec(cmd.toArray(new String[0]));
            p.waitFor();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public static Monitor[] x11_rr_load_user() {
        Config config = new Config();
        try {
            XML xml = new XML();
            FileInputStream fis = new FileInputStream(JF.getUserPath() + "/.xrandr.xml");
            xml.read(fis);
            xml.writeClass(config);
            fis.close();
            return config.monitor;
        }
        catch (FileNotFoundException e1) {
            return new Monitor[0];
        }
        catch (Exception e2) {
            JFLog.log(e2);
            return new Monitor[0];
        }
    }

    public static void x11_rr_save_user(Monitor[] monitor) {
        Config config = new Config();
        config.monitor = monitor;
        try {
            XML xml = new XML();
            FileOutputStream fos = new FileOutputStream(JF.getUserPath() + "/.xrandr.xml");
            xml.readClass("display", (Object)config);
            xml.write(fos);
            fos.close();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public static synchronized boolean authUser(String user, String pass) {
        String backend;
        Linux.detectDistro();
        switch (distro.ordinal()) {
            case 1: {
                backend = "passwd";
                break;
            }
            case 2: {
                backend = "password-auth";
                break;
            }
            case 3: {
                backend = "system-auth";
                break;
            }
            default: {
                return false;
            }
        }
        return LnxNative.authUser(user, pass, backend);
    }

    public static void kill(int pid, int signal) {
        try {
            Runtime.getRuntime().exec(new String[]{"kill", "-" + signal, "" + pid});
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public static void setenv(String name, String value) {
        LnxNative.setenv(name, value);
    }

    public static void main(String[] args) {
        Linux.x11_set_listener(new X11Listener(){

            @Override
            public void trayIconAdded(int count) {
                System.out.println("tragIconAdded:" + count);
            }

            @Override
            public void trayIconRemoved(int count) {
                System.out.println("tragIconRemoved:" + count);
            }

            @Override
            public void windowsChanged() {
                System.out.println("windowsChanged");
            }
        });
        Linux.x11_window_list_main();
    }

    static {
        currentList = new ArrayList();
        currentListLock = new Object();
        screens = new ArrayList();
    }

    public static enum DistroTypes {
        Unknown,
        Ubuntu,
        Fedora,
        Arch;

    }

    public static class Window {
        public long xid;
        public int pid;
        public String title;
        public String name;
        public String res_name;
        public String res_class;
        public String file;
        public long org_event_mask;

        public Window(long xid, int pid, String title, String name, String res_name, String res_class) {
            this.xid = xid;
            this.pid = pid;
            this.title = title;
            this.name = name;
            this.res_name = res_name;
            this.res_class = res_class;
        }
    }

    public static class Screen {
        public int idx;
        public ArrayList<Port> ports = new ArrayList();
    }

    public static class Port {
        public String name;
        public boolean connected;
        public boolean hasActiveSize;
        public boolean used;
        public ArrayList<Size> sizes = new ArrayList();
    }

    public static class Size {
        public String size;
        public boolean active;
        public boolean preferred;
    }

    public static class Monitor {
        public String name;
        public String res = "";
        public int rotate;
        public boolean mirror;
        public int relpos;
        public String relName = "";
    }

    public static class Config {
        public Monitor[] monitor;
    }
}

