/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import javaforce.BE;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.STUN;
import javaforce.voip.RTP;
import javaforce.voip.RTPChannel;
import javaforce.voip.SDP;
import javaforce.voip.SRTPContext;
import javax.crypto.Mac;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.DTLSClientProtocol;
import org.bouncycastle.tls.DTLSServerProtocol;
import org.bouncycastle.tls.DTLSTransport;
import org.bouncycastle.tls.DatagramTransport;
import org.bouncycastle.tls.DefaultTlsClient;
import org.bouncycastle.tls.DefaultTlsServer;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsClient;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsCredentialedDecryptor;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsSRTPUtils;
import org.bouncycastle.tls.TlsServer;
import org.bouncycastle.tls.TlsServerCertificate;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.UDPTransport;
import org.bouncycastle.tls.UseSRTPData;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.impl.bc.BcDefaultTlsCredentialedDecryptor;
import org.bouncycastle.tls.crypto.impl.bc.BcDefaultTlsCredentialedSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCertificate;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.util.Arrays;

public class SRTPChannel
extends RTPChannel {
    private boolean have_keys = false;
    private boolean dtls = false;
    private boolean dtlsServerMode = false;
    private boolean stunReceived = false;
    private boolean dtlsReady = false;
    private SRTPContext srtp_in;
    private SRTPContext srtp_out;
    private int _tailIn;
    private int _tailOut;
    private long _seqno = 0L;
    private DatagramSocket dtlsSocket;
    private DatagramSocket rawSocket;
    private JFTlsServer tlsServer;
    private JFTlsClient tlsClient;
    private DTLSTransport dtlsTransport;
    private Worker worker;
    private String local_iceufrag;
    private String local_icepwd;
    private static DTLSServerProtocol dtlsServer;
    private static DTLSClientProtocol dtlsClient;
    private static InetAddress localhost;
    private static Certificate dtlsCertChain;
    private static AsymmetricKeyParameter dtlsPrivateKey;
    private static final int KEY_LENGTH = 16;
    private static final int SALT_LENGTH = 14;
    private byte[] sharedSecret;
    private byte[] remoteKey = new byte[16];
    private byte[] remoteSalt = new byte[16];
    private byte[] localKey = new byte[16];
    private byte[] localSalt = new byte[16];
    private static final short BINDING_REQUEST = 1;
    private static final short BINDING_RESPONSE = 257;
    private static final short MAPPED_ADDRESS = 1;
    private static final short USERNAME = 6;
    private static final short XOR_MAPPED_ADDRESS = 32;
    private static final short MESSAGE_INTEGRITY = 8;
    private static final short USE_CANDIDATE = 37;
    private static final short PRIORITY = 36;
    private static final short ICE_CONTROLLING = -32726;
    private static final short ICE_CONTROLLED = -32727;
    private static final short FINGERPRINT = -32728;
    private byte[] stun;
    private static final int SRTPWINDOWSIZE = 64;
    private long[] _replay = new long[64];
    private long _windowLeadingEdge = 0L;
    protected long _roc = 0L;
    protected int _s_l = 0;

    public SRTPChannel(RTP rtp, int ssrc, SDP.Stream stream) {
        super(rtp, ssrc, stream);
    }

    @Override
    public void writeRTP(byte[] data, int off, int len) {
        if (this.rtp.rawMode) {
            super.writeRTP(data, off, len);
            return;
        }
        if (this.srtp_out == null) {
            if (!this.have_keys) {
                return;
            }
            try {
                this.srtp_out = new SRTPContext();
                this.srtp_out.setCrypto("AES_CM_128_HMAC_SHA1_80", this.localKey, this.localSalt);
                this._tailOut = this.srtp_out.getAuthTail();
                this.srtp_out.deriveKeys(0L);
            }
            catch (Exception e) {
                JFLog.log(e);
                return;
            }
        }
        try {
            byte[] payload = java.util.Arrays.copyOfRange(data, off + 12, off + len);
            int ssrc = BE.getuint32(data, off + 8);
            int seqno = BE.getuint16(data, off + 2);
            this._seqno &= 0xFFFFFFFFFFFF0000L;
            this._seqno |= (long)seqno;
            this.encrypt(payload, ssrc, this._seqno++);
            byte[] packet = new byte[len + this._tailOut];
            System.arraycopy(data, off, packet, 0, 12);
            System.arraycopy(payload, 0, packet, 12, payload.length);
            this.appendAuth(packet, this.srtp_out, seqno);
            super.writeRTP(packet, 0, packet.length);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void setLocalKeys(byte[] key, byte[] salt) {
        System.arraycopy(key, 0, this.localKey, 0, 16);
        System.arraycopy(salt, 0, this.localSalt, 0, 14);
        this.have_keys = true;
    }

    public void setRemoteKeys(byte[] key, byte[] salt) {
        System.arraycopy(key, 0, this.remoteKey, 0, 16);
        System.arraycopy(salt, 0, this.remoteSalt, 0, 14);
        this.have_keys = true;
    }

    public void setDTLS(boolean server, String local_iceufrag, String local_icepwd) {
        this.dtls = true;
        this.dtlsServerMode = server;
        this.local_iceufrag = local_iceufrag;
        this.local_icepwd = local_icepwd;
    }

    @Override
    public boolean start() {
        JFLog.log("SRTPChannel.start:dtls=" + this.dtls);
        if (!super.start()) {
            return false;
        }
        if (this.rtp.rawMode) {
            return true;
        }
        if (!this.dtls) {
            return this.have_keys;
        }
        new Thread(){

            @Override
            public void run() {
                while (SRTPChannel.this.rtp.active && !SRTPChannel.this.stunReceived) {
                    JF.sleep(500);
                    Random r = new Random();
                    byte[] request = new byte[1500];
                    ByteBuffer bb = ByteBuffer.wrap(request);
                    bb.order(ByteOrder.BIG_ENDIAN);
                    int offset = 0;
                    bb.putShort(offset, (short)1);
                    int lengthOffset = offset += 2;
                    bb.putShort(offset, (short)0);
                    long id1 = 554869826L;
                    id1 <<= 32;
                    bb.putLong(offset += 2, id1 += (long)Math.abs(r.nextInt()));
                    long id2 = r.nextLong();
                    bb.putLong(offset += 8, id2);
                    String user = SRTPChannel.this.stream.sdp.iceufrag + ":" + SRTPChannel.this.local_iceufrag;
                    int strlen = user.length();
                    bb.putShort(offset += 8, (short)6);
                    bb.putShort(offset += 2, (short)strlen);
                    System.arraycopy(user.getBytes(), 0, request, offset += 2, strlen);
                    if (((offset += strlen) & 3) > 0) {
                        offset += 4 - (offset & 3);
                    }
                    bb.putShort(offset, (short)36);
                    bb.putShort(offset += 2, (short)4);
                    bb.putInt(offset += 2, Math.abs(r.nextInt()));
                    bb.putShort(offset += 4, (short)-32727);
                    bb.putShort(offset += 2, (short)8);
                    bb.putLong(offset += 2, r.nextLong());
                    bb.putShort(lengthOffset, (short)((offset += 8) - 20 + 24));
                    byte[] id = STUN.calcMsgIntegrity(request, offset, STUN.calcKey(SRTPChannel.this.stream.sdp.icepwd));
                    strlen = id.length;
                    bb.putShort(offset, (short)8);
                    bb.putShort(offset += 2, (short)strlen);
                    System.arraycopy(id, 0, request, offset += 2, strlen);
                    if (((offset += strlen) & 3) > 0) {
                        offset += 4 - (offset & 3);
                    }
                    bb.putShort(lengthOffset, (short)(offset - 20 + 8));
                    bb.putShort(offset, (short)-32728);
                    bb.putShort(offset += 2, (short)4);
                    bb.putInt(offset += 2, STUN.calcFingerprint(request, offset - 4));
                    bb.putShort(lengthOffset, (short)((offset += 4) - 20));
                    try {
                        RTP cfr_ignored_0 = SRTPChannel.this.rtp;
                        if (RTP.useTURN) {
                            SRTPChannel.this.rtp.stun1.sendData(SRTPChannel.this.turn1ch, request, 0, offset);
                            continue;
                        }
                        DatagramPacket dp = new DatagramPacket(request, 0, offset, InetAddress.getByName(SRTPChannel.this.stream.getIP()), SRTPChannel.this.stream.getPort());
                        SRTPChannel.this.rtp.sock1.send(dp);
                    }
                    catch (Exception e) {
                        JFLog.log(e);
                    }
                }
                try {
                    localhost = InetAddress.getByName("localhost");
                    SRTPChannel.this.dtlsSocket = new DatagramSocket(RTP.getnextlocalrtpport());
                    JFLog.log("dtlsSocket.port=" + SRTPChannel.this.dtlsSocket.getLocalPort());
                    SRTPChannel.this.rawSocket = new DatagramSocket(RTP.getnextlocalrtpport());
                    JFLog.log(" rawSocket.port=" + SRTPChannel.this.rawSocket.getLocalPort());
                    SRTPChannel.this.dtlsSocket.connect(localhost, SRTPChannel.this.rawSocket.getLocalPort());
                    SRTPChannel.this.rawSocket.connect(localhost, SRTPChannel.this.dtlsSocket.getLocalPort());
                }
                catch (Exception e) {
                    JFLog.log(e);
                    return;
                }
                SRTPChannel.this.worker = new Worker();
                SRTPChannel.this.worker.start();
                if (!SRTPChannel.this.dtlsServerMode) {
                    try {
                        dtlsClient = new DTLSClientProtocol();
                    }
                    catch (Exception e) {
                        JFLog.log(e);
                        dtlsClient = null;
                        return;
                    }
                    SRTPChannel.this.tlsClient = new JFTlsClient(){
                        protected TlsSession session;

                        public TlsSession getSessionToResume() {
                            return this.session;
                        }

                        public ProtocolVersion[] getProtocolVersions() {
                            return new ProtocolVersion[]{ProtocolVersion.DTLSv10, ProtocolVersion.DTLSv12};
                        }

                        public Hashtable getClientExtensions() throws IOException {
                            Hashtable table = super.getClientExtensions();
                            if (table == null) {
                                table = new Hashtable();
                            }
                            int[] protectionProfiles = new int[]{1};
                            byte[] mki = new byte[]{};
                            UseSRTPData srtpData = new UseSRTPData(protectionProfiles, mki);
                            TlsSRTPUtils.addUseSRTPExtension(table, (UseSRTPData)srtpData);
                            return table;
                        }

                        public TlsAuthentication getAuthentication() throws IOException {
                            return new TlsAuthentication(){

                                public void notifyServerCertificate(TlsServerCertificate serverCertificate) throws IOException {
                                }

                                public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) throws IOException {
                                    short[] certificateTypes = certificateRequest.getCertificateTypes();
                                    if (certificateTypes == null || !Arrays.contains((short[])certificateTypes, (short)1)) {
                                        return null;
                                    }
                                    Vector supportedSignatureAlgorithms = certificateRequest.getSupportedSignatureAlgorithms();
                                    SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
                                    for (int i = 0; i < supportedSignatureAlgorithms.size(); ++i) {
                                        SignatureAndHashAlgorithm alg = (SignatureAndHashAlgorithm)supportedSignatureAlgorithms.elementAt(i);
                                        if (alg.getSignature() != 1) continue;
                                        signatureAndHashAlgorithm = alg;
                                        break;
                                    }
                                    return new BcDefaultTlsCredentialedSigner(new TlsCryptoParameters((TlsContext)context), (BcTlsCrypto)context.getCrypto(), dtlsPrivateKey, dtlsCertChain, signatureAndHashAlgorithm);
                                }
                            };
                        }

                        public void notifyHandshakeComplete() throws IOException {
                            JFLog.log("SRTPChannel:DTLS:Client:Handshake complete");
                            super.notifyHandshakeComplete();
                            TlsSession newSession = this.context.getResumableSession();
                            if (newSession != null) {
                                this.session = newSession;
                            }
                            this.getKeys();
                        }
                    };
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                JFLog.log("SRTPChannel:connecting to DTLS server");
                                SRTPChannel.this.dtlsTransport = dtlsClient.connect((TlsClient)SRTPChannel.this.tlsClient, (DatagramTransport)new UDPTransport(SRTPChannel.this.dtlsSocket, 1472));
                            }
                            catch (Exception e) {
                                JFLog.log(e);
                            }
                        }
                    }.start();
                } else {
                    try {
                        dtlsServer = new DTLSServerProtocol();
                    }
                    catch (Exception e) {
                        JFLog.log(e);
                        dtlsServer = null;
                        return;
                    }
                    try {
                        SRTPChannel.this.tlsServer = new JFTlsServer(){

                            public void notifyClientCertificate(Certificate clientCertificate) throws IOException {
                                TlsCertificate[] chain = clientCertificate.getCertificateList();
                                for (int i = 0; i != chain.length; ++i) {
                                    TlsCertificate tlsCertificate = chain[i];
                                }
                            }

                            public ProtocolVersion[] getProtocolVersions() {
                                return new ProtocolVersion[]{ProtocolVersion.DTLSv10, ProtocolVersion.DTLSv12};
                            }

                            protected TlsCredentialedDecryptor getRSAEncryptionCredentials() throws IOException {
                                return new BcDefaultTlsCredentialedDecryptor((BcTlsCrypto)this.context.getCrypto(), dtlsCertChain, dtlsPrivateKey);
                            }

                            protected TlsCredentialedSigner getRSASignerCredentials() throws IOException {
                                Vector supportedSignatureAlgorithms = this.context.getSecurityParametersHandshake().getClientSigAlgs();
                                SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
                                for (int i = 0; i < supportedSignatureAlgorithms.size(); ++i) {
                                    SignatureAndHashAlgorithm alg = (SignatureAndHashAlgorithm)supportedSignatureAlgorithms.elementAt(i);
                                    if (alg.getSignature() != 1) continue;
                                    signatureAndHashAlgorithm = alg;
                                    break;
                                }
                                return new BcDefaultTlsCredentialedSigner(new TlsCryptoParameters((TlsContext)this.context), (BcTlsCrypto)this.context.getCrypto(), dtlsPrivateKey, dtlsCertChain, signatureAndHashAlgorithm);
                            }

                            public Hashtable getServerExtensions() throws IOException {
                                Hashtable table = super.getServerExtensions();
                                if (table == null) {
                                    table = new Hashtable();
                                }
                                int[] protectionProfiles = new int[]{1};
                                byte[] mki = new byte[]{};
                                UseSRTPData srtpData = new UseSRTPData(protectionProfiles, mki);
                                TlsSRTPUtils.addUseSRTPExtension(table, (UseSRTPData)srtpData);
                                return table;
                            }

                            public void notifyHandshakeComplete() throws IOException {
                                JFLog.log("SRTPChannel:DTLS:Server:Handshake complete");
                                super.notifyHandshakeComplete();
                                this.getKeys();
                            }
                        };
                        new Thread(){

                            @Override
                            public void run() {
                                try {
                                    JFLog.log("SRTPChannel:accepting from DTLS client");
                                    SRTPChannel.this.dtlsTransport = dtlsServer.accept((TlsServer)SRTPChannel.this.tlsServer, (DatagramTransport)new UDPTransport(SRTPChannel.this.dtlsSocket, 1472));
                                }
                                catch (Exception e) {
                                    JFLog.log(e);
                                }
                            }
                        }.start();
                    }
                    catch (Exception e) {
                        JFLog.log(e);
                        SRTPChannel.this.dtlsSocket = null;
                        SRTPChannel.this.rawSocket = null;
                        return;
                    }
                }
                SRTPChannel.this.dtlsReady = true;
            }
        }.start();
        return true;
    }

    private boolean isClassicStun(long id1) {
        return id1 >>> 32 != 554869826L;
    }

    private int IP4toInt(String ip) {
        String[] o = ip.split("[.]");
        int ret = 0;
        for (int a = 0; a < 4; ++a) {
            ret <<= 8;
            ret += JF.atoi(o[a]);
        }
        return ret;
    }

    protected void processSTUN(byte[] data, int off, int len) {
        JFLog.log("SRTPChannel:received STUN request");
        String username = null;
        String flipped = null;
        ByteBuffer bb = ByteBuffer.wrap(data, off, len);
        bb.order(ByteOrder.BIG_ENDIAN);
        int offset = off;
        short code = bb.getShort(offset);
        boolean auth = false;
        if (code != 1) {
            JFLog.log("RTPSecureChannel:Error:STUN Request is not Binding request");
            return;
        }
        int lengthOffset = offset += 2;
        short length = bb.getShort(offset);
        long id1 = bb.getLong(offset += 2);
        long id2 = bb.getLong(offset += 8);
        offset += 8;
        while (offset < len) {
            short attr = bb.getShort(offset);
            length = bb.getShort(offset += 2);
            offset += 2;
            switch (attr) {
                case 6: {
                    username = new String(data, offset, (int)length);
                    String[] f = username.split("[:]");
                    flipped = f[1] + ":" + f[0];
                    break;
                }
                case 8: {
                    bb.putShort(lengthOffset, (short)offset);
                    byte[] correct = STUN.calcMsgIntegrity(data, offset - 4, STUN.calcKey(this.local_icepwd));
                    byte[] supplied = java.util.Arrays.copyOfRange(data, offset, offset + 20);
                    auth = java.util.Arrays.equals(correct, supplied);
                }
            }
            offset += length;
            if ((length & 3) <= 0) continue;
            offset += 4 - (length & 3);
        }
        if (!auth) {
            return;
        }
        if (this.stun == null) {
            this.stun = new byte[1500];
        }
        bb = ByteBuffer.wrap(this.stun);
        bb.order(ByteOrder.BIG_ENDIAN);
        offset = 0;
        bb.putShort(offset, (short)257);
        lengthOffset = offset += 2;
        bb.putShort(offset, (short)0);
        bb.putLong(offset += 2, id1);
        bb.putLong(offset += 8, id2);
        offset += 8;
        if (this.isClassicStun(id1)) {
            bb.putShort(offset, (short)1);
            bb.putShort(offset += 2, (short)8);
            bb.put(offset += 2, (byte)0);
            bb.put(++offset, (byte)1);
            bb.putShort(++offset, (short)this.stream.port);
            bb.putInt(offset += 2, this.IP4toInt(this.stream.getIP()));
            offset += 4;
        } else {
            bb.putShort(offset, (short)32);
            bb.putShort(offset += 2, (short)8);
            bb.put(offset += 2, (byte)0);
            bb.put(++offset, (byte)1);
            bb.putShort(++offset, (short)(this.stream.port ^ bb.getShort(4)));
            bb.putInt(offset += 2, this.IP4toInt(this.stream.getIP()) ^ bb.getInt(4));
            offset += 4;
        }
        bb.putShort(lengthOffset, (short)(offset - 20 + 24));
        byte[] id = STUN.calcMsgIntegrity(this.stun, offset, STUN.calcKey(this.local_icepwd));
        int strlen = id.length;
        bb.putShort(offset, (short)8);
        bb.putShort(offset += 2, (short)strlen);
        System.arraycopy(id, 0, this.stun, offset += 2, strlen);
        if (((offset += strlen) & 3) > 0) {
            offset += 4 - (offset & 3);
        }
        bb.putShort(lengthOffset, (short)(offset - 20));
        try {
            if (RTP.useTURN) {
                this.rtp.stun1.sendData(this.turn1ch, this.stun, 0, offset);
            } else {
                this.rtp.sock1.send(new DatagramPacket(this.stun, 0, offset, InetAddress.getByName(this.stream.getIP()), this.stream.getPort()));
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public static boolean initDTLS(List<byte[]> certChain, byte[] privateKey, boolean pkRSA) {
        try {
            BcTlsCrypto crypto = new BcTlsCrypto();
            org.bouncycastle.asn1.x509.Certificate[] x509certs = new org.bouncycastle.asn1.x509.Certificate[certChain.size()];
            TlsCertificate[] tlscerts = new TlsCertificate[certChain.size()];
            for (int i = 0; i < certChain.size(); ++i) {
                x509certs[i] = org.bouncycastle.asn1.x509.Certificate.getInstance((Object)certChain.get(i));
                tlscerts[i] = new BcTlsCertificate(crypto, x509certs[i]);
            }
            dtlsCertChain = new Certificate(tlscerts);
            if (pkRSA) {
                RSAPrivateKey rsa = RSAPrivateKey.getInstance((Object)privateKey);
                dtlsPrivateKey = new RSAPrivateCrtKeyParameters(rsa.getModulus(), rsa.getPublicExponent(), rsa.getPrivateExponent(), rsa.getPrime1(), rsa.getPrime2(), rsa.getExponent1(), rsa.getExponent2(), rsa.getCoefficient());
            } else {
                dtlsPrivateKey = PrivateKeyFactory.createKey((byte[])privateKey);
            }
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    protected void processDTLS(byte[] data, int off, int len) {
        if (!this.dtlsReady) {
            return;
        }
        try {
            this.rawSocket.send(new DatagramPacket(data, off, len, localhost, this.dtlsSocket.getLocalPort()));
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    @Override
    protected void processRTP(byte[] data, int off, int len) {
        if (this.rtp.rawMode) {
            this.rtp.iface.rtpPacket(this, data, off, len);
            return;
        }
        int firstByte = data[off] & 0xFF;
        if (firstByte == 0) {
            this.processSTUN(data, off, len);
            return;
        }
        if (firstByte == 1) {
            this.stunReceived = true;
            return;
        }
        if (firstByte > 127 && firstByte < 192) {
            if (!this.have_keys) {
                JFLog.log("SRTPChannel:warn:received SRTP data but keys undefined");
                return;
            }
            if (this.srtp_in == null) {
                try {
                    this.srtp_in = new SRTPContext();
                    this.srtp_in.setCrypto("AES_CM_128_HMAC_SHA1_80", this.remoteKey, this.remoteSalt);
                    this._tailIn = this.srtp_in.getAuthTail();
                    this.srtp_in.deriveKeys(0L);
                }
                catch (Exception e) {
                    JFLog.log(e);
                }
            }
            int seqno = BE.getuint16(data, off + 2);
            int ssrc = BE.getuint32(data, off + 8);
            long index = this.getIndex(seqno);
            this.updateCounters(seqno, index);
            if (this.checkAuth(data, len)) {
                return;
            }
            if (this.checkForReplay(index)) {
                return;
            }
            byte[] payload = java.util.Arrays.copyOfRange(data, off + 12, off + len);
            try {
                this.decrypt(payload, ssrc, seqno, index);
            }
            catch (Exception e) {
                JFLog.log(e);
            }
            System.arraycopy(payload, 0, data, off + 12, payload.length);
            super.processRTP(data, off, len - this._tailIn);
            return;
        }
        if (this.dtls) {
            this.processDTLS(data, off, len);
        }
    }

    private void printArray(String msg, byte[] data, int off, int len) {
        StringBuilder sb = new StringBuilder();
        int sum = 0;
        for (int a = 0; a < len; ++a) {
            sb.append(",");
            sb.append(Integer.toString(data[off + a] & 0xFF, 16));
            sum += data[off + a];
        }
        JFLog.log(msg + "(" + len + ")=" + sb.toString() + "=" + sum);
    }

    private ByteBuffer getPepper(int ssrc, long idx) {
        ByteBuffer pepper = ByteBuffer.allocate(16);
        pepper.putInt(4, ssrc);
        long sindex = idx << 16;
        pepper.putLong(8, sindex);
        return pepper;
    }

    private void decrypt(byte[] payload, int ssrc, int seqno, long index) throws GeneralSecurityException {
        ByteBuffer in = ByteBuffer.wrap(payload);
        int pl = (payload.length / 32 + 2) * 32;
        ByteBuffer out = ByteBuffer.allocate(pl);
        ByteBuffer pepper = this.getPepper(ssrc, index);
        this.srtp_in.decipher(in, out, pepper);
        System.arraycopy(out.array(), 0, payload, 0, payload.length);
    }

    private void encrypt(byte[] payload, int ssrc, long idx) throws GeneralSecurityException {
        ByteBuffer in = ByteBuffer.wrap(payload);
        int pl = (payload.length / 32 + 2) * 32;
        ByteBuffer out = ByteBuffer.allocate(pl);
        ByteBuffer pepper = this.getPepper(ssrc, idx);
        this.srtp_out.decipher(in, out, pepper);
        System.arraycopy(out.array(), 0, payload, 0, payload.length);
    }

    private void appendAuth(byte[] packet, SRTPContext sc, int seqno) {
        try {
            Mac mac = sc.getAuthMac();
            int offs = packet.length - this._tailOut;
            ByteBuffer m = ByteBuffer.allocate(offs + 4);
            m.put(packet, 0, offs);
            int oroc = seqno >>> 16;
            m.putInt(oroc);
            m.position(0);
            mac.update(m);
            byte[] auth = mac.doFinal();
            for (int i = 0; i < this._tailOut; ++i) {
                packet[offs + i] = auth[i];
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    private boolean checkForReplay(long _index) {
        if (_index < this._windowLeadingEdge) {
            if (this._windowLeadingEdge - _index > 64L) {
                JFLog.log("SRTPChannel:Replay:packet too old");
                return true;
            }
            int tidx = (int)(_index % 64L);
            if (this._replay[tidx] == _index) {
                JFLog.log("SRTPChannel:Replay:seen that packet");
                return true;
            }
        }
        return false;
    }

    private boolean checkAuth(byte[] packet, int plen) {
        try {
            this.srtp_in.deriveKeys(0L);
            Mac hmac = this.srtp_in.getAuthMac();
            int alen = this._tailIn;
            int offs = plen - alen;
            ByteBuffer m = ByteBuffer.allocate(offs + 4);
            m.put(packet, 0, offs);
            m.putInt((int)this._roc);
            byte[] auth = new byte[alen];
            System.arraycopy(packet, offs, auth, 0, alen);
            int mlen = plen - 12 - alen;
            m.position(0);
            hmac.update(m);
            byte[] mac = hmac.doFinal();
            for (int i = 0; i < alen; ++i) {
                if (auth[i] == mac[i]) continue;
                throw new Exception("SRTPChannel:not authorized byte " + i + " does not match");
            }
            return false;
        }
        catch (Exception e) {
            JFLog.log(e);
            return true;
        }
    }

    long getIndex(int seqno) {
        long v = this._roc;
        int diff = seqno - this._s_l;
        if (diff < Short.MIN_VALUE) {
            v = this._roc + 1L;
        }
        if (diff > Short.MAX_VALUE) {
            v = this._roc - 1L;
        }
        if (v < 0L) {
            v = 0L;
        }
        long low = seqno;
        long high = v << 16;
        long ret = low | high;
        return ret;
    }

    void updateCounters(int seqno, long index) {
        int diff;
        int tidx = (int)(index % 64L);
        this._replay[tidx] = index;
        if (index > this._windowLeadingEdge) {
            this._windowLeadingEdge = index;
        }
        if ((diff = seqno - this._s_l) < Short.MIN_VALUE) {
            ++this._roc;
        }
        this._s_l = seqno;
    }

    private class Worker
    extends Thread {
        private Worker() {
        }

        @Override
        public void run() {
            try {
                byte[] data = new byte[1500];
                while (SRTPChannel.this.active) {
                    DatagramPacket pack = new DatagramPacket(data, 1500);
                    SRTPChannel.this.rawSocket.receive(pack);
                    int len = pack.getLength();
                    int off = 0;
                    RTP cfr_ignored_0 = SRTPChannel.this.rtp;
                    if (RTP.useTURN) {
                        SRTPChannel.this.rtp.stun1.sendData(SRTPChannel.this.turn1ch, data, off, len);
                        continue;
                    }
                    SRTPChannel.this.rtp.sock1.send(new DatagramPacket(data, off, len, InetAddress.getByName(SRTPChannel.this.stream.getIP()), SRTPChannel.this.stream.getPort()));
                }
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }

    private abstract class JFTlsClient
    extends DefaultTlsClient {
        public JFTlsClient() {
            super((TlsCrypto)new BcTlsCrypto());
        }

        public void getKeys() {
            try {
                SRTPChannel.this.sharedSecret = this.context.exportKeyingMaterial("EXTRACTOR-dtls_srtp", null, 60);
                if (SRTPChannel.this.sharedSecret == null) {
                    throw new Exception("null keys");
                }
            }
            catch (Exception e) {
                JFLog.log(e);
                return;
            }
            int offset = 0;
            System.arraycopy(SRTPChannel.this.sharedSecret, offset, SRTPChannel.this.localKey, 0, 16);
            System.arraycopy(SRTPChannel.this.sharedSecret, offset += 16, SRTPChannel.this.remoteKey, 0, 16);
            System.arraycopy(SRTPChannel.this.sharedSecret, offset += 16, SRTPChannel.this.localSalt, 0, 14);
            System.arraycopy(SRTPChannel.this.sharedSecret, offset += 14, SRTPChannel.this.remoteSalt, 0, 14);
            offset += 14;
            SRTPChannel.this.have_keys = true;
        }
    }

    private class JFTlsServer
    extends DefaultTlsServer {
        public JFTlsServer() {
            super((TlsCrypto)new BcTlsCrypto());
        }

        public void getKeys() {
            try {
                SRTPChannel.this.sharedSecret = this.context.exportKeyingMaterial("EXTRACTOR-dtls_srtp", null, 60);
                if (SRTPChannel.this.sharedSecret == null) {
                    throw new Exception("null keys");
                }
            }
            catch (Exception e) {
                JFLog.log(e);
                return;
            }
            int offset = 0;
            System.arraycopy(SRTPChannel.this.sharedSecret, offset, SRTPChannel.this.remoteKey, 0, 16);
            System.arraycopy(SRTPChannel.this.sharedSecret, offset += 16, SRTPChannel.this.localKey, 0, 16);
            System.arraycopy(SRTPChannel.this.sharedSecret, offset += 16, SRTPChannel.this.remoteSalt, 0, 14);
            System.arraycopy(SRTPChannel.this.sharedSecret, offset += 14, SRTPChannel.this.localSalt, 0, 14);
            offset += 14;
            SRTPChannel.this.have_keys = true;
        }
    }
}

