/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import javaforce.JFLog;
import javaforce.voip.Packet;
import javaforce.voip.Transport;

public class TransportUDP
implements Transport {
    private DatagramSocket ds;
    private boolean active = false;
    private boolean error = false;

    @Override
    public String getName() {
        return "UDP";
    }

    @Override
    public boolean open(String localhost, int localport) {
        try {
            this.ds = new DatagramSocket(localport);
            this.active = true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
        return true;
    }

    @Override
    public boolean close() {
        this.active = false;
        if (this.ds != null) {
            this.ds.close();
            this.ds = null;
        }
        return true;
    }

    @Override
    public boolean send(byte[] data, int off, int len, InetAddress host, int port) {
        try {
            DatagramPacket dp = new DatagramPacket(data, off, len, host, port);
            this.ds.send(dp);
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
        return true;
    }

    @Override
    public boolean receive(Packet packet) {
        try {
            DatagramPacket dp = new DatagramPacket(packet.data, packet.data.length);
            this.ds.receive(dp);
            packet.length = dp.getLength();
            packet.host = dp.getAddress().getHostAddress();
            packet.port = dp.getPort();
        }
        catch (Exception e) {
            this.error = true;
            if (this.active) {
                JFLog.log(e);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean error() {
        return this.error;
    }
}

