/*
 * Decompiled with CFR 0.152.
 */
package javaforce.db;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Calendar;
import javaforce.JFLog;
import javaforce.db.Row;
import javaforce.io.ObjectReader;
import javaforce.io.ObjectWriter;
import javaforce.io.SerialObject;

public class TableLog<ROW extends Row> {
    private String folder;
    private RandomAccessFile raf;
    private String filename;
    private Object lock = new Object();
    private Row.Creator ctr;
    private final long ms_per_day = 86400000L;

    public TableLog(String folder, Row.Creator rowCreator) {
        this.folder = folder;
        this.ctr = rowCreator;
    }

    private ROW create() {
        return (ROW)this.ctr.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ROW[] get(long start, long end) {
        ArrayList<Row> rows = new ArrayList<Row>();
        try {
            Object object = this.lock;
            synchronized (object) {
                long endp1 = end + 86400000L;
                for (long current = start; current < endp1; current += 86400000L) {
                    if (!this.open(current, false)) continue;
                    this.raf.seek(0L);
                    while (this.raf.getFilePointer() < this.raf.length()) {
                        ObjectReader ois = new ObjectReader(Channels.newInputStream(this.raf.getChannel()));
                        Row row = (Row)ois.readObject((SerialObject)this.create());
                        if (row.timestamp < start || row.timestamp > end) continue;
                        rows.add(row);
                    }
                }
            }
            return (Row[])rows.toArray();
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    private boolean open(long timestamp, boolean create) {
        Calendar now = Calendar.getInstance();
        now.setTimeInMillis(timestamp);
        int year = now.get(1);
        int month = now.get(2) + 1;
        int day = now.get(5);
        String path = String.format("%04d/%02d", year, month);
        String filename = String.format("%s/%02d.dat", path, day);
        if (!create && !new File(filename).exists()) {
            return false;
        }
        if (this.filename != null && filename.equals(this.filename)) {
            return true;
        }
        try {
            if (this.raf != null) {
                this.raf.close();
            }
            new File(path).mkdirs();
            this.raf = new RandomAccessFile(filename, "rw");
            this.filename = filename;
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.raf != null) {
                try {
                    this.raf.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.raf = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ROW row) {
        ((Row)row).id = -1;
        ((Row)row).timestamp = System.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            this.open(((Row)row).timestamp, true);
            try {
                ObjectWriter oos = new ObjectWriter(Channels.newOutputStream(this.raf.getChannel()));
                oos.writeObject((SerialObject)row);
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }
}

