/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.MD5;
import javaforce.jbus.JBusClient;
import javaforce.jbus.JBusServer;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class STUNServer
extends Thread {
    private static int defaultLifeTime = 600;
    public static final String busPack = "net.sf.jfstun";
    private static final short BINDING_REQUEST = 1;
    private static final short ALLOCATE_REQUEST = 3;
    private static final short REFRESH_REQUEST = 4;
    private static final short BIND_REQUEST = 9;
    private static final short BINDING_RESPONSE = 257;
    private static final short ALLOCATE_RESPONSE = 259;
    private static final short REFRESH_RESPONSE = 260;
    private static final short BIND_RESPONSE = 265;
    private static final short BINDING_FAILED = 273;
    private static final short ALLOCATE_FAILED = 275;
    private static final short REFRESH_FAILED = 276;
    private static final short BIND_FAILED = 281;
    private static final short MAPPED_ADDRESS = 1;
    private static final short CHANGE_REQUEST = 3;
    private static final short USERNAME = 6;
    private static final short MESSAGE_INTEGRITY = 8;
    private static final short ERROR_CODE = 9;
    private static final short CHANNEL_NUMBER = 12;
    private static final short LIFETIME = 13;
    private static final short XOR_PEER_ADDRESS = 18;
    private static final short REALM = 20;
    private static final short NONCE = 21;
    private static final short XOR_RELAY_ADDRESS = 22;
    private static final short DATA_INDICATION = 23;
    private static final short EVEN_PORT = 24;
    private static final short TRANSPORT_TYPE = 25;
    private static final short XOR_MAPPED_ADDRESS = 32;
    private static final short RESERVATION_TOKEN = 34;
    private volatile boolean active = true;
    private volatile boolean done = false;
    private String user;
    private String pass;
    private DatagramSocket ds;
    private DatagramSocket ds2;
    private final String realm = "javaforce.service.STUN";
    private String publicip;
    private static final String defaultConfig = "[global]\n## remove comments below and change as desired.\n#user=\n#pass=\n#publicip=1.2.3.4\n## min/max are the UDP port ranges to use\n#min=10000\n#max=20000\n";
    private HashMap<String, Alloc> allocs = new HashMap();
    private Object allocsLock = new Object();
    private char[] chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private int min = 10000;
    private int max = 20000;
    private int next = 10000;
    private HashMap<String, String> tokens = new HashMap();
    private int nextToken = 0;
    private static JBusServer busServer;
    private JBusClient busClient;
    private String config;
    private static STUNServer stun;

    public static String getConfigFile() {
        return JF.getConfigPath() + "/jfstun.cfg";
    }

    public static String getLogFile() {
        return JF.getLogPath() + "/jfstun.log";
    }

    private boolean doStart() {
        try {
            JFLog.log("Starting STUN/TURN Service on ports 3478 and 3479");
            this.ds = new DatagramSocket(3478);
            this.ds2 = new DatagramSocket(3479);
            new Worker().start();
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public STUNServer() {
        JFLog.append(STUNServer.getLogFile(), true);
        JFLog.setRetention(30);
        this.loadConfig();
    }

    public STUNServer(String user, String pass, int min, int max) {
        this.user = user;
        this.pass = pass;
        this.min = min;
        this.max = max;
        this.next = min;
    }

    private void loadConfig() {
        Section section = Section.None;
        try {
            String ln;
            BufferedReader br = new BufferedReader(new FileReader(STUNServer.getConfigFile()));
            StringBuilder cfg = new StringBuilder();
            while ((ln = br.readLine()) != null) {
                cfg.append(ln);
                cfg.append("\n");
                ln = ln.trim().toLowerCase();
                int cmt = ln.indexOf(35);
                if (cmt != -1) {
                    ln = ln.substring(0, cmt).trim();
                }
                if (ln.length() == 0) continue;
                if (ln.equals("[global]")) {
                    section = Section.Global;
                    continue;
                }
                int idx = ln.indexOf("=");
                if (idx == -1) continue;
                String key = ln.substring(0, idx);
                String value = ln.substring(idx + 1);
                block2 : switch (section.ordinal()) {
                    case 1: {
                        switch (key) {
                            case "user": {
                                this.user = value;
                                break block2;
                            }
                            case "pass": {
                                this.pass = value;
                                break block2;
                            }
                            case "publicip": {
                                this.publicip = value;
                                break block2;
                            }
                            case "min": {
                                this.min = JF.atoi(value);
                                break block2;
                            }
                            case "max": {
                                this.max = JF.atoi(value);
                            }
                        }
                    }
                }
            }
            this.config = cfg.toString();
        }
        catch (FileNotFoundException e) {
            try {
                FileOutputStream fos = new FileOutputStream(STUNServer.getConfigFile());
                fos.write(defaultConfig.getBytes());
                fos.close();
                this.config = defaultConfig;
            }
            catch (Exception e2) {
                JFLog.log(e2);
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public int getLocalPort() {
        return this.ds.getLocalPort();
    }

    public String getLocalAddr() {
        return this.ds.getLocalAddress().getHostAddress();
    }

    public void close() {
        this.active = false;
        if (this.ds != null) {
            try {
                this.ds.close();
                this.ds = null;
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
        if (this.ds2 != null) {
            try {
                this.ds2.close();
                this.ds2 = null;
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
        while (!this.done) {
            JF.sleep(10);
        }
    }

    private byte[] calcKey() {
        String msg = this.user + ":javaforce.service.STUN:" + this.pass;
        MD5 md5 = new MD5();
        md5.init();
        md5.add(msg.getBytes(), 0, msg.length());
        return md5.done();
    }

    private byte[] calcMsgIntegrity(byte[] data, int length) {
        byte[] key = this.calcKey();
        try {
            SecretKeySpec ks = new SecretKeySpec(key, "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(ks);
            return mac.doFinal(Arrays.copyOfRange(data, 0, length));
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    private void relayTurn(String ip, int port, byte[] data, ByteBuffer bb) throws Exception {
        String id = ip + ":" + port;
        Alloc alloc = this.getAlloc(id);
        if (alloc == null) {
            JFLog.log("Unknown client:" + id);
            return;
        }
        short channel = bb.getShort(0);
        short length = bb.getShort(2);
        if (channel != alloc.channel) {
            alloc.log("relayTurn:channel mismatch");
            return;
        }
        DatagramPacket dp = new DatagramPacket(data, 4, length);
        dp.setAddress(alloc.relayaddr);
        dp.setPort(alloc.relayport);
        alloc.ds.send(dp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Alloc getAlloc(String ip, int port, InetAddress addr) {
        Alloc alloc;
        String id = ip + ":" + port;
        Object object = this.allocsLock;
        synchronized (object) {
            alloc = this.allocs.get(id);
            if (alloc != null) {
                return alloc;
            }
            alloc = new Alloc();
            alloc.ip = ip;
            alloc.port = port;
            alloc.id = id;
            alloc.addr = addr;
            this.allocs.put(id, alloc);
        }
        return alloc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Alloc getAlloc(String id) {
        Alloc alloc;
        Object object = this.allocsLock;
        synchronized (object) {
            alloc = this.allocs.get(id);
        }
        return alloc;
    }

    private String nonceRandom() {
        Random r = new Random();
        StringBuilder sb = new StringBuilder();
        for (int a = 0; a < 20; ++a) {
            sb.append(this.chars[r.nextInt(16)]);
        }
        return sb.toString();
    }

    public void setPortRange(int min, int max) {
        this.min = min;
        this.max = max;
        this.next = min;
    }

    private synchronized int getNextPort() {
        int port = this.next++;
        ++this.next;
        if (this.next >= this.max) {
            this.next = this.min;
        }
        return port;
    }

    private boolean isClassicStun(long id1) {
        return id1 >>> 32 != 554869826L;
    }

    private synchronized String allocToken(String id) {
        String token = String.format("%08x", this.nextToken++);
        if (this.nextToken < 0) {
            this.nextToken = 0;
        }
        this.tokens.put(token, id);
        return token;
    }

    private String getTokenID(String token) {
        String id = this.tokens.get(token);
        this.tokens.remove(token);
        return id;
    }

    private void logKey(byte[] key) {
        StringBuilder log = new StringBuilder();
        for (int a = 0; a < key.length; ++a) {
            int b = key[a] & 0xFF;
            if (b < 16) {
                log.append("0");
            }
            log.append(Integer.toString(b, 16));
        }
        JFLog.log("key=" + String.valueOf(log));
    }

    private void sendError(Alloc alloc, short code, long id1, long id2, InetAddress remoteAddr, int remotePort, byte[] data, ByteBuffer bb) throws Exception {
        alloc.nonce = this.nonceRandom();
        int offset = 0;
        bb.putShort(offset, code);
        int lengthOffset = offset += 2;
        bb.putShort(offset, (short)0);
        bb.putLong(offset += 2, id1);
        bb.putLong(offset += 8, id2);
        bb.putShort(offset += 8, (short)9);
        bb.putShort(offset += 2, (short)4);
        bb.putInt(offset += 2, 1025);
        bb.putShort(offset += 4, (short)20);
        bb.putShort(offset += 2, (short)"javaforce.service.STUN".length());
        System.arraycopy("javaforce.service.STUN".getBytes(), 0, data, offset += 2, "javaforce.service.STUN".length());
        if (((offset += "javaforce.service.STUN".length()) & 3) > 0) {
            offset += 4 - (offset & 3);
        }
        bb.putShort(offset, (short)21);
        bb.putShort(offset += 2, (short)alloc.nonce.length());
        System.arraycopy(alloc.nonce.getBytes(), 0, data, offset += 2, alloc.nonce.length());
        bb.putShort(lengthOffset, (short)((offset += alloc.nonce.length()) - 20));
        DatagramPacket dp = new DatagramPacket(data, offset);
        dp.setAddress(remoteAddr);
        dp.setPort(remotePort);
        this.ds.send(dp);
    }

    public static int getBusPort() {
        if (JF.isWindows()) {
            return 33006;
        }
        return 777;
    }

    public static void main(String[] args) {
    }

    @Override
    public void run() {
        JFLog.append(JF.getLogPath() + "/jfssh.log", true);
        JFLog.setRetention(30);
        JFLog.log("STUN : Starting service");
        this.busClient = new JBusClient(busPack, new JBusMethods());
        this.busClient.setPort(STUNServer.getBusPort());
        this.busClient.start();
        this.doStart();
    }

    public static void serviceStart(String[] args) {
        if (JF.isWindows()) {
            busServer = new JBusServer(STUNServer.getBusPort());
            busServer.start();
            while (true) {
                if (JBusServer.ready) break;
                JF.sleep(10);
            }
        }
        stun = new STUNServer();
        stun.start();
    }

    public static void serviceStop() {
        JFLog.log("STUN : Stopping service");
        if (busServer != null) {
            busServer.close();
            busServer = null;
        }
        stun.close();
    }

    private class Worker
    extends Thread {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int a;
            String localip;
            byte[] data = new byte[1500];
            ByteBuffer bb = ByteBuffer.wrap(data);
            bb.order(ByteOrder.BIG_ENDIAN);
            byte[] ip4 = new byte[4];
            if (STUNServer.this.publicip != null) {
                localip = STUNServer.this.publicip;
            } else {
                InetAddress localAddr = STUNServer.this.ds.getInetAddress();
                if (localAddr != null) {
                    localip = localAddr.getHostAddress();
                    if (localip.indexOf(":") != -1) {
                        localip = "127.0.0.1";
                    }
                } else {
                    localip = "127.0.0.1";
                }
            }
            String[] f = localip.split("[.]");
            int localip_int = 0;
            for (a = 0; a < 4; ++a) {
                localip_int <<= 8;
                localip_int += JF.atoi(f[a]);
            }
            int localPort = STUNServer.this.ds.getPort();
            block24: while (STUNServer.this.active) {
                try {
                    DatagramPacket dp = new DatagramPacket(data, 1500);
                    STUNServer.this.ds.receive(dp);
                    InetAddress remoteAddr = dp.getAddress();
                    String remoteip = remoteAddr.getHostAddress();
                    if (remoteip.indexOf(":") != -1) continue;
                    f = remoteip.split("[.]");
                    int remoteip_int = 0;
                    for (a = 0; a < 4; ++a) {
                        remoteip_int <<= 8;
                        remoteip_int += JF.atoi(f[a]);
                    }
                    int remotePort = dp.getPort();
                    int packetLength = dp.getLength();
                    int change_request_flgs = 0;
                    String realm = "";
                    String nonce = "";
                    int lifetime = defaultLifeTime;
                    boolean auth = false;
                    Alloc alloc = null;
                    String resToken = null;
                    boolean evenPort = false;
                    int relayip = -1;
                    int relayport = -1;
                    InetAddress relayaddr = null;
                    boolean username = false;
                    int channel = -1;
                    int offset = 0;
                    short code = bb.getShort(0);
                    if (code >= 16384 && code <= Short.MAX_VALUE) {
                        STUNServer.this.relayTurn(remoteip, remotePort, data, bb);
                        continue;
                    }
                    if (code == 23) continue;
                    int lengthOffset = offset += 2;
                    short length = bb.getShort(offset);
                    if (length + 20 != packetLength) {
                        throw new Exception("STUN:bad packet:incorrect length");
                    }
                    long id1 = bb.getLong(offset += 2);
                    long id2 = bb.getLong(offset += 8);
                    offset += 8;
                    while (offset < packetLength) {
                        short attr = bb.getShort(offset);
                        length = bb.getShort(offset += 2);
                        offset += 2;
                        switch (attr) {
                            case 6: {
                                if (STUNServer.this.user == null) break;
                                username = new String(data, offset, (int)length).equals(STUNServer.this.user);
                                break;
                            }
                            case 20: {
                                realm = new String(data, offset, (int)length);
                                break;
                            }
                            case 21: {
                                nonce = new String(data, offset, (int)length);
                                break;
                            }
                            case 13: {
                                lifetime = bb.getInt(offset);
                                break;
                            }
                            case 3: {
                                change_request_flgs = bb.getInt(offset);
                                break;
                            }
                            case 24: {
                                evenPort = true;
                                break;
                            }
                            case 12: {
                                channel = bb.getShort(offset);
                                if (channel >= 16384) break;
                                channel = -1;
                                break;
                            }
                            case 34: {
                                resToken = new String(Arrays.copyOfRange(data, offset, offset + length));
                                break;
                            }
                            case 8: {
                                alloc = STUNServer.this.getAlloc(remoteip, remotePort, remoteAddr);
                                if (nonce == null) {
                                    alloc.log("!nonce");
                                    break;
                                }
                                if (realm == null) {
                                    alloc.log("!realm");
                                    break;
                                }
                                if (alloc.nonce == null) {
                                    alloc.log("!alloc.nonce");
                                    break;
                                }
                                if (!nonce.equals(alloc.nonce)) {
                                    alloc.log("nonce mismatch");
                                    break;
                                }
                                if (!username) {
                                    alloc.log("!username");
                                    break;
                                }
                                bb.putShort(lengthOffset, (short)offset);
                                byte[] correct = STUNServer.this.calcMsgIntegrity(data, offset - 4);
                                byte[] supplied = Arrays.copyOfRange(data, offset, offset + 20);
                                auth = Arrays.equals(correct, supplied);
                                break;
                            }
                            case 18: {
                                relayport = (bb.getShort(offset + 2) ^ bb.getShort(4)) & 0xFFFF;
                                relayip = bb.getInt(offset + 4) ^ bb.getInt(4);
                                ip4[0] = (byte)((relayip & 0xFF000000) >>> 24);
                                ip4[1] = (byte)((relayip & 0xFF0000) >> 16);
                                ip4[2] = (byte)((relayip & 0xFF00) >> 8);
                                ip4[3] = (byte)(relayip & 0xFF);
                                relayaddr = InetAddress.getByAddress(ip4);
                            }
                        }
                        offset += length;
                        if ((length & 3) <= 0) continue;
                        offset += 4 - (length & 3);
                    }
                    switch (code) {
                        case 1: {
                            JFLog.log(remoteip + ":" + remotePort + ":BINDING_REQUEST");
                            offset = 0;
                            bb.putShort(offset, (short)257);
                            bb.putShort(offset += 2, (short)12);
                            bb.putLong(offset += 2, id1);
                            bb.putLong(offset += 8, id2);
                            offset += 8;
                            if (STUNServer.this.isClassicStun(id1)) {
                                bb.putShort(offset, (short)1);
                                bb.putShort(offset += 2, (short)8);
                                bb.put(offset += 2, (byte)0);
                                bb.put(++offset, (byte)1);
                                bb.putShort(++offset, (short)remotePort);
                                bb.putInt(offset += 2, remoteip_int);
                                offset += 4;
                            } else {
                                bb.putShort(offset, (short)32);
                                bb.putShort(offset += 2, (short)8);
                                bb.put(offset += 2, (byte)0);
                                bb.put(++offset, (byte)1);
                                bb.putShort(++offset, (short)(remotePort ^ bb.getShort(4)));
                                bb.putInt(offset += 2, remoteip_int ^ bb.getInt(4));
                                offset += 4;
                            }
                            dp = new DatagramPacket(data, offset);
                            dp.setAddress(remoteAddr);
                            dp.setPort(remotePort);
                            if ((change_request_flgs & 2) == 2) {
                                STUNServer.this.ds2.send(dp);
                                continue block24;
                            }
                            STUNServer.this.ds.send(dp);
                            continue block24;
                        }
                        case 3: {
                            alloc = STUNServer.this.getAlloc(remoteip, remotePort, remoteAddr);
                            alloc.log("ALLOCATE_REQUEST");
                            if (!auth) {
                                STUNServer.this.sendError(alloc, (short)275, id1, id2, remoteAddr, remotePort, data, bb);
                                continue block24;
                            }
                            if (resToken != null) {
                                if (evenPort) {
                                    throw new Exception("EVEN_PORT with RESERVATION_TOKEN");
                                }
                                Alloc evenAlloc = STUNServer.this.getAlloc(STUNServer.this.getTokenID(resToken));
                                if (evenAlloc == null) {
                                    throw new Exception("Reservation not found");
                                }
                                if (!evenAlloc.evenPort) {
                                    throw new Exception("Odd Port was not reserved");
                                }
                                alloc.ds = new DatagramSocket(evenAlloc.ds.getLocalPort() + 1);
                            } else {
                                alloc.ds = new DatagramSocket(STUNServer.this.getNextPort());
                            }
                            alloc.evenPort = evenPort;
                            offset = 0;
                            bb.putShort(offset, (short)259);
                            lengthOffset = offset += 2;
                            bb.putShort(offset, (short)0);
                            bb.putLong(offset += 2, id1);
                            bb.putLong(offset += 8, id2);
                            offset += 8;
                            if (evenPort) {
                                String token = STUNServer.this.allocToken(remoteip + ":" + remotePort);
                                bb.putShort(offset, (short)34);
                                bb.putShort(offset += 2, (short)token.length());
                                System.arraycopy(token.getBytes(), 0, data, offset += 2, token.length());
                                offset += token.length();
                            }
                            bb.putShort(offset, (short)22);
                            bb.putShort(offset += 2, (short)8);
                            bb.put(offset += 2, (byte)0);
                            bb.put(++offset, (byte)1);
                            bb.putShort(++offset, (short)(alloc.ds.getLocalPort() ^ bb.getShort(4)));
                            bb.putInt(offset += 2, localip_int ^ bb.getInt(4));
                            bb.putShort(lengthOffset, (short)((offset += 4) - 20));
                            dp = new DatagramPacket(data, offset);
                            dp.setAddress(remoteAddr);
                            dp.setPort(remotePort);
                            STUNServer.this.ds.send(dp);
                            alloc.setTimeout(defaultLifeTime);
                            continue block24;
                        }
                        case 4: {
                            alloc = STUNServer.this.getAlloc(remoteip, remotePort, remoteAddr);
                            alloc.log("REFRESH_REQUEST");
                            if (!auth) {
                                STUNServer.this.sendError(alloc, (short)276, id1, id2, remoteAddr, remotePort, data, bb);
                            } else if (lifetime != 0) {
                                alloc.setTimeout(defaultLifeTime);
                            }
                            offset = 0;
                            bb.putShort(offset, (short)260);
                            bb.putShort(offset += 2, (short)8);
                            bb.putLong(offset += 2, id1);
                            bb.putLong(offset += 8, id2);
                            bb.putShort(offset += 8, (short)13);
                            bb.putShort(offset += 2, (short)4);
                            bb.putInt(offset += 2, lifetime);
                            dp = new DatagramPacket(data, offset += 4);
                            dp.setAddress(remoteAddr);
                            dp.setPort(remotePort);
                            STUNServer.this.ds.send(dp);
                            if (lifetime != 0) continue block24;
                            alloc.free();
                            continue block24;
                        }
                        case 9: {
                            alloc = STUNServer.this.getAlloc(remoteip, remotePort, remoteAddr);
                            alloc.log("BIND_REQUEST");
                            if (!auth || channel == -1) {
                                STUNServer.this.sendError(alloc, (short)281, id1, id2, remoteAddr, remotePort, data, bb);
                            } else {
                                Object object = alloc.lock;
                                synchronized (object) {
                                    alloc.setTimeout(defaultLifeTime);
                                    alloc.relayip = relayip;
                                    alloc.relayaddr = relayaddr;
                                    alloc.relayport = relayport;
                                    alloc.channel = (short)channel;
                                    if (alloc.worker == null) {
                                        alloc.worker = new RelayWorker(alloc);
                                        alloc.worker.start();
                                    }
                                }
                            }
                            offset = 0;
                            bb.putShort(offset, (short)265);
                            bb.putShort(offset += 2, (short)8);
                            bb.putLong(offset += 2, id1);
                            bb.putLong(offset += 8, id2);
                            bb.putShort(offset += 8, (short)13);
                            bb.putShort(offset += 2, (short)4);
                            bb.putInt(offset += 2, defaultLifeTime);
                            dp = new DatagramPacket(data, offset += 4);
                            dp.setAddress(remoteAddr);
                            dp.setPort(remotePort);
                            STUNServer.this.ds.send(dp);
                            continue block24;
                        }
                    }
                    JFLog.log(remoteip + ":" + remotePort + ":Unknown request:" + code);
                }
                catch (Exception e) {
                    if (!STUNServer.this.active) continue;
                    JFLog.log(e);
                }
            }
            STUNServer.this.done = true;
        }
    }

    static enum Section {
        None,
        Global;

    }

    private class Alloc {
        String nonce;
        String ip;
        InetAddress addr;
        int port;
        Timer timer;
        DatagramSocket ds;
        Object lock = new Object();
        long timeout;
        String id;
        int relayip;
        int relayport;
        InetAddress relayaddr;
        RelayWorker worker;
        short channel;
        boolean evenPort;

        private Alloc() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setTimeout(int secs) {
            Object object = this.lock;
            synchronized (object) {
                if (this.timer != null) {
                    this.timer.cancel();
                }
                if (this.ds == null) {
                    return;
                }
                this.timer = new Timer();
                this.timeout = System.currentTimeMillis() + (long)((secs - 1) * 1000);
                this.timer.schedule((TimerTask)new AllocTask(this), secs * 1000);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void free() {
            this.log("object released");
            Object object = this.lock;
            synchronized (object) {
                if (this.timer != null) {
                    this.timer.cancel();
                    this.timer = null;
                }
                STUNServer.this.allocs.remove(this.id);
                if (this.worker != null) {
                    this.worker.active = false;
                    this.worker = null;
                }
                if (this.ds != null) {
                    this.ds.close();
                    this.ds = null;
                }
            }
        }

        void log(String msg) {
            JFLog.log(this.id + ":" + msg);
        }
    }

    public static class JBusMethods {
        public void getConfig(String pack) {
            JBusClient cfr_ignored_0 = STUNServer.stun.busClient;
            JBusClient cfr_ignored_1 = STUNServer.stun.busClient;
            STUNServer.stun.busClient.call(pack, "getConfig", JBusClient.quote(JBusClient.encodeString(STUNServer.stun.config)));
        }

        public void setConfig(String cfg) {
            try {
                FileOutputStream fos = new FileOutputStream(STUNServer.getConfigFile());
                fos.write(JBusClient.decodeString(cfg).getBytes());
                fos.close();
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        public void restart() {
            stun.close();
            stun = new STUNServer();
            stun.start();
        }
    }

    private class RelayWorker
    extends Thread {
        Alloc alloc;
        public volatile boolean active = true;
        private static final int mtu = 1472;

        public RelayWorker(Alloc alloc) {
            this.alloc = alloc;
        }

        @Override
        public void run() {
            byte[] data = new byte[1476];
            ByteBuffer bb = ByteBuffer.wrap(data);
            bb.order(ByteOrder.BIG_ENDIAN);
            bb.putShort(0, this.alloc.channel);
            while (this.active) {
                try {
                    DatagramPacket indp = new DatagramPacket(data, 4, 1472);
                    this.alloc.ds.receive(indp);
                    int len = indp.getLength();
                    bb.putShort(2, (short)len);
                    DatagramPacket outdp = new DatagramPacket(data, 0, len + 4);
                    outdp.setAddress(this.alloc.addr);
                    outdp.setPort(this.alloc.port);
                    STUNServer.this.ds.send(outdp);
                }
                catch (Exception e) {
                    if (!this.active) continue;
                    JFLog.log(e);
                }
            }
        }
    }

    private class AllocTask
    extends TimerTask {
        Alloc alloc;

        public AllocTask(Alloc alloc) {
            this.alloc = alloc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long now = System.currentTimeMillis();
            Object object = this.alloc.lock;
            synchronized (object) {
                if (this.alloc.timeout < now) {
                    this.alloc.log("object expired");
                    this.alloc.free();
                }
            }
        }
    }
}

