/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.GZIPOutputStream;
import javaforce.service.WebRequest;
import javaforce.service.WebServer;

public class WebResponse
extends OutputStream {
    OutputStream os;
    boolean liveStream;
    private ByteArrayOutputStream buf = new ByteArrayOutputStream();
    private int statusCode = 200;
    private String statusString = "OK";
    private String contentType = "text/html; charset=UTF-8";
    private ArrayList<String> cookies = new ArrayList();
    private ArrayList<String> headers = new ArrayList();

    @Override
    public void write(int b) throws IOException {
        if (this.liveStream) {
            throw new IOException("");
        }
        this.buf.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.liveStream) {
            throw new IOException("");
        }
        this.buf.write(b, off, len);
    }

    void writeAll(WebRequest req) throws Exception {
        if (this.liveStream) {
            throw new IOException("");
        }
        byte[] data = this.buf.toByteArray();
        boolean gzip = false;
        if (data.length > 0) {
            String accept;
            if (WebServer.config_enable_gzip && (accept = req.getHeader("Accept-Encoding")) != null) {
                String[] encodings = accept.split(",");
                for (int a = 0; a < encodings.length; ++a) {
                    if (!encodings[a].trim().equals("gzip")) continue;
                    gzip = true;
                    break;
                }
            }
            if (gzip) {
                this.addHeader("Content-Encoding: gzip");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                GZIPOutputStream gos = new GZIPOutputStream(baos);
                gos.write(data);
                gos.finish();
                data = baos.toByteArray();
            }
        }
        int size = data.length;
        this.writeHeaders(size, gzip);
        if (data.length > 0) {
            this.os.write(WebServer.chunkHeader(data));
            this.os.write(data);
            this.os.write("\r\n0\r\n\r\n".getBytes());
        }
    }

    void writeHeaders(int contentLength, boolean gzip) throws Exception {
        int a;
        StringBuilder res = new StringBuilder();
        res.append("HTTP/1.1 " + this.statusCode + " " + this.statusString + "\r\n");
        if (contentLength != -1) {
            res.append("Content-Length: " + contentLength + "\r\n");
        }
        res.append("Content-Type: " + this.contentType + "\r\n");
        if (contentLength != 0) {
            res.append("Transfer-Encoding: chunked\r\n");
        }
        for (a = 0; a < this.cookies.size(); ++a) {
            res.append("Set-Cookie: ");
            res.append(this.cookies.get(a));
            res.append("\r\n");
        }
        for (a = 0; a < this.headers.size(); ++a) {
            res.append(this.headers.get(a));
            res.append("\r\n");
        }
        res.append("\r\n");
        this.os.write(res.toString().getBytes());
    }

    public OutputStream getOutputStream() {
        if (this.liveStream) {
            return null;
        }
        return this;
    }

    public OutputStream getLiveOutputStream() {
        if (this.liveStream) {
            return null;
        }
        if (this.buf.size() > 0) {
            return null;
        }
        try {
            this.writeHeaders(-1, false);
        }
        catch (Exception e) {
            return null;
        }
        this.liveStream = true;
        return this.os;
    }

    public void setStatus(int sc, String msg) {
        this.statusCode = sc;
        this.statusString = msg;
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public void addCookie(String name, String value) {
        this.cookies.add(name + "=" + value);
    }

    public void addHeader(String header) {
        this.headers.add(header);
    }

    public void sendRedirect(String url) {
        this.setStatus(301, "Moved");
        this.addHeader("Location: " + url);
    }
}

