/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import javaforce.voip.Packet;
import javaforce.voip.PacketReceiver;
import javaforce.voip.RTPChannel;
import javaforce.voip.RTPCodec;

public class RTPH263_1998
extends RTPCodec {
    private Packet packet;
    private int lastseqnum = -1;
    private static int maxSize = 0x400000;
    private static final int mtu = 1444;
    private int seqnum;
    private int timestamp;
    private final int ssrc = this.random.nextInt();

    public RTPH263_1998() {
        this.packet = new Packet();
        this.packet.data = new byte[maxSize];
    }

    private int find_best_length(byte[] data, int offset, int length) {
        for (int a = 1; a < length - 3; ++a) {
            if (data[offset + a] != 0 || data[offset + a + 1] != 0 || data[offset + a + 2] == 0) continue;
            return a;
        }
        return length;
    }

    @Override
    public void encode(byte[] data, int x, int y, int id, PacketReceiver pr) {
        int packetLength;
        int offset = 0;
        for (int len = data.length; len > 0; len -= packetLength) {
            boolean P = false;
            if (len > 2 && data[offset] == 0 && data[offset + 1] == 0) {
                P = true;
                offset += 2;
                len -= 2;
            }
            packetLength = len > 1444 ? this.find_best_length(data, offset, len) : len;
            this.packet.length = packetLength + 12 + 2;
            RTPChannel.buildHeader(this.packet.data, id, this.seqnum++, this.timestamp, this.ssrc, len == packetLength);
            this.packet.data[12] = (byte)(P ? 4 : 0);
            System.arraycopy(data, offset, this.packet.data, 14, packetLength);
            offset += packetLength;
            pr.onPacket(this.packet);
        }
        this.packet.length = 0;
        this.timestamp += 100;
    }

    @Override
    public void decode(byte[] rtp, int offset, int length, PacketReceiver pr) {
        if (rtp.length < 14) {
            return;
        }
        int h263Length = rtp.length - 12 - 2;
        boolean P = (rtp[12] & 4) == 4;
        int partialLength = this.packet.length;
        System.arraycopy(rtp, 14, this.packet.data, partialLength + (P ? 2 : 0), h263Length);
        if ((rtp[1] & 0x80) == 128) {
            pr.onPacket(this.packet);
            this.packet.length = 0;
        }
    }
}

