/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import javaforce.JFLog;
import javaforce.voip.Packet;
import javaforce.voip.PacketReceiver;
import javaforce.voip.RTPChannel;
import javaforce.voip.RTPCodec;

public class RTPVP9
extends RTPCodec {
    private static final int mtu = 1445;
    private int seqnum;
    private int timestamp;
    private final int ssrc = this.random.nextInt();
    private int lastseqnum = -1;
    private Packet packet = new Packet();
    private static int maxSize = 0x400000;
    private static final int M = 128;
    private static final int I = 128;
    private static final int P = 64;
    private static final int L = 32;
    private static final int F = 16;
    private static final int B = 8;
    private static final int E = 4;
    private static final int V = 2;

    public RTPVP9() {
        this.packet.data = new byte[maxSize];
    }

    @Override
    public void encode(byte[] data, int x, int y, int id, PacketReceiver pr) {
        int packetLength;
        int offset = 0;
        boolean first = true;
        for (int len = data.length; len > 0; len -= packetLength) {
            packetLength = len > 1445 ? 1445 : len;
            this.packet.length = packetLength + 1 + 12;
            boolean last = len == packetLength;
            RTPChannel.buildHeader(this.packet.data, id, this.seqnum++, this.timestamp, this.ssrc, last);
            if (first) {
                this.packet.data[12] = (byte)(data[0] | 8);
                first = false;
            } else {
                this.packet.data[12] = 0;
            }
            if (last) {
                this.packet.data[12] = 4;
            }
            System.arraycopy(data, offset, this.packet, 13, packetLength);
            pr.onPacket(this.packet);
            offset += packetLength;
        }
        this.packet.length = 0;
        this.timestamp += 100;
    }

    @Override
    public void decode(byte[] rtp, int offset, int length, PacketReceiver pr) {
        boolean v;
        if (rtp.length < 14) {
            return;
        }
        int vp9Length = rtp.length - 12;
        int payloadOffset = 12;
        byte bits = rtp[12];
        boolean f = (bits & 0x10) != 0;
        boolean i = (bits & 0x80) != 0;
        boolean p = (bits & 0x40) != 0;
        boolean l = (bits & 0x20) != 0;
        boolean b = (bits & 8) != 0;
        boolean e = (bits & 4) != 0;
        boolean bl = v = (bits & 2) != 0;
        if (b) {
            this.packet.length = 0;
        } else {
            ++payloadOffset;
            --vp9Length;
            if (i) {
                boolean m = (rtp[payloadOffset] & 0x80) != 0;
                ++payloadOffset;
                --vp9Length;
                if (m) {
                    ++payloadOffset;
                    --vp9Length;
                }
            }
            if (l) {
                ++payloadOffset;
                --vp9Length;
            }
            if (p || f) {
                boolean x = (rtp[payloadOffset] & 2) != 0;
                ++payloadOffset;
                --vp9Length;
                if (x) {
                    ++payloadOffset;
                    --vp9Length;
                }
            }
            if (!f) {
                ++payloadOffset;
                --vp9Length;
            }
            if (v) {
                byte ss = rtp[payloadOffset];
                ++payloadOffset;
                --vp9Length;
                int n_s = (ss & 0xE0) + 1;
                boolean y = (ss & 0x10) != 0;
                int n_g = (ss & 0xF) + 1;
                if (y) {
                    int dims = n_s * 4;
                    payloadOffset += dims;
                    vp9Length -= dims;
                }
                for (int i1 = 0; i1 < n_g; ++i1) {
                    byte tur = rtp[payloadOffset];
                    ++payloadOffset;
                    --vp9Length;
                    int r = (tur & 0xC) >> 2;
                    payloadOffset += r;
                    vp9Length -= r;
                }
            }
        }
        System.arraycopy(rtp, payloadOffset, this.packet.data, this.packet.length, vp9Length);
        int thisseqnum = RTPChannel.getseqnum(rtp, 0);
        if (this.lastseqnum != -1 && thisseqnum != this.lastseqnum + 1) {
            JFLog.log("VP9:Received packet out of order, discarding frame.");
            this.lastseqnum = -1;
            this.packet.length = 0;
            return;
        }
        this.lastseqnum = thisseqnum;
        if ((rtp[1] & 0x80) == 128) {
            if (!e) {
                JFLog.log("Error : VP9 : E bit not set with M bit");
            }
            pr.onPacket(this.packet);
            this.lastseqnum = -1;
            this.packet.length = 0;
        }
    }
}

