/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import javaforce.DNS;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.MD5;
import javaforce.net.IP4;
import javaforce.net.IP6;
import javaforce.voip.CallDetails;
import javaforce.voip.Codec;
import javaforce.voip.Packet;
import javaforce.voip.SDP;
import javaforce.voip.SIPInterface;
import javaforce.voip.Transport;
import javaforce.voip.TransportInterface;
import javaforce.voip.TransportTCPClient;
import javaforce.voip.TransportTCPServer;
import javaforce.voip.TransportTLSClient;
import javaforce.voip.TransportTLSServer;
import javaforce.voip.TransportType;
import javaforce.voip.TransportUDP;

public abstract class SIP
implements TransportInterface {
    private Worker worker;
    private SIPInterface iface;
    private boolean active = true;
    private String rinstance;
    private String tupleid;
    private Random r = new Random();
    private boolean server;
    private static boolean dns_system = true;
    private static int dns_transport = 0;
    private static String dns_server = "8.8.8.8";
    protected Transport transport;
    protected static String useragent = "JavaForce/" + JF.getVersion();
    private static Object dnsCacheLock = new Object();
    private static HashMap<String, String> dnsCache = new HashMap();
    private static final int mtu = 1460;

    protected boolean init(String localhost, int localport, SIPInterface iface, boolean server, TransportType type) throws Exception {
        JFLog.log("SIP:local=" + localhost + ":" + localport);
        this.rinstance = null;
        this.iface = iface;
        this.server = server;
        switch (type) {
            case UDP: {
                this.transport = new TransportUDP();
                break;
            }
            case TCP: {
                if (server) {
                    this.transport = new TransportTCPServer();
                    break;
                }
                this.transport = new TransportTCPClient();
                break;
            }
            case TLS: {
                this.transport = server ? new TransportTLSServer() : new TransportTLSClient();
            }
        }
        if (!this.transport.open(localhost, localport, this)) {
            return false;
        }
        this.worker = new Worker();
        this.worker.start();
        return true;
    }

    protected void uninit() {
        if (this.transport == null) {
            return;
        }
        this.active = false;
        this.transport.close();
        try {
            this.worker.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.transport = null;
        this.worker = null;
    }

    protected boolean send(InetAddress remote, int remoteport, String datastr) {
        byte[] data = datastr.getBytes();
        return this.transport.send(data, 0, data.length, remote, remoteport);
    }

    public static String[] split(String x) {
        String x2;
        String x1;
        if (x == null) {
            return new String[]{"null", "null", "null"};
        }
        ArrayList<String> parts = new ArrayList<String>();
        int i1 = x.indexOf(60);
        if (i1 == -1) {
            parts.add("");
            x1 = x;
            x2 = "";
        } else {
            if (i1 == 0) {
                parts.add("Unknown Name");
            } else {
                parts.add(x.substring(0, i1).trim().replaceAll("\"", ""));
            }
            int i2 = x.substring(++i1).indexOf(62);
            if (i2 == -1) {
                return null;
            }
            x1 = x.substring(i1, i1 + i2);
            x2 = x.substring(i1 + i2 + 1).trim();
        }
        i1 = x1.indexOf(58);
        if (i1 == -1) {
            return null;
        }
        if ((i1 = (x1 = x1.substring(i1 + 1)).indexOf(64)) == -1) {
            parts.add("");
        } else {
            parts.add(x1.substring(0, i1).trim());
            x1 = x1.substring(i1 + 1).trim();
        }
        if (x1.length() > 0 && x1.charAt(0) == ';') {
            x1 = x1.substring(1);
        }
        while (true) {
            if ((i1 = x1.indexOf(59)) == -1) {
                if ((x1 = x1.trim()).length() <= 0) break;
                parts.add(x1);
                break;
            }
            parts.add(x1.substring(0, i1).trim());
            x1 = x1.substring(i1 + 1).trim();
        }
        if (parts.size() == 2) {
            parts.add("");
        }
        parts.add(":");
        if (x2.length() > 0 && x2.charAt(0) == ';') {
            x2 = x2.substring(1);
        }
        while (true) {
            if ((i1 = x2.indexOf(59)) == -1) {
                if ((x2 = x2.trim()).length() <= 0) break;
                parts.add(x2);
                break;
            }
            parts.add(x2.substring(0, i1).trim());
            x2 = x2.substring(i1 + 1).trim();
        }
        String[] ret = new String[parts.size()];
        for (int a = 0; a < parts.size(); ++a) {
            ret[a] = (String)parts.get(a);
        }
        return ret;
    }

    public static String join(String[] x) {
        int i;
        if (x == null) {
            return "\"null\"<sip:null@null>";
        }
        StringBuilder buf = new StringBuilder();
        if (x[0].length() > 0) {
            buf.append('\"');
            buf.append(x[0]);
            buf.append('\"');
            buf.append('<');
        }
        buf.append("sip:");
        if (x[1].length() > 0) {
            buf.append(x[1]);
            buf.append('@');
        }
        buf.append(x[2]);
        for (i = 3; i < x.length && !x[i].equals(":"); ++i) {
            buf.append(';');
            buf.append(x[i]);
        }
        ++i;
        if (x[0].length() > 0) {
            buf.append('>');
        }
        while (i < x.length) {
            buf.append(';');
            buf.append(x[i]);
            ++i;
        }
        return buf.toString();
    }

    public static String getFlag2(String[] fields, String flg) {
        int i;
        flg = (String)flg + "=";
        for (i = 0; i < fields.length && !fields[i].equals(":"); ++i) {
        }
        if (i == fields.length) {
            return "";
        }
        ++i;
        while (i < fields.length) {
            if (fields[i].startsWith((String)flg)) {
                return fields[i].substring(((String)flg).length());
            }
            ++i;
        }
        return "";
    }

    public static String[] setFlag2(String[] fields, String flg, String value) {
        flg = (String)flg + "=";
        boolean seperator = false;
        for (int i = 3; i < fields.length; ++i) {
            if (!seperator) {
                if (!fields[i].equals(":")) continue;
                seperator = true;
                continue;
            }
            if (!fields[i].startsWith((String)flg)) continue;
            fields[i] = (String)flg + value;
            return fields;
        }
        String[] newfields = new String[fields.length + 1];
        for (int j = 0; j < fields.length; ++j) {
            newfields[j] = fields[j];
        }
        newfields[fields.length] = (String)flg + value;
        return newfields;
    }

    public String getbranch() {
        return String.format("z123456-y12345-%x%x-1--d12345-", this.r.nextInt(), this.r.nextInt());
    }

    protected String getbranch(String[] msg) {
        String[] vias = this.getvialist(msg);
        if (vias == null || vias.length == 0) {
            return null;
        }
        String[] f = vias[0].split(";");
        for (int a = 0; a < f.length; ++a) {
            if (!f[a].startsWith("branch=")) continue;
            return f[a].substring(7);
        }
        return null;
    }

    protected boolean ishold(String[] msg) {
        for (int a = 0; a < msg.length; ++a) {
            if (!msg[a].equalsIgnoreCase("a=sendonly")) continue;
            return true;
        }
        return false;
    }

    protected String[] getvialist(String[] msg) {
        ArrayList<String> vialist = new ArrayList<String>();
        for (int a = 0; a < msg.length; ++a) {
            String ln = msg[a];
            if (ln.regionMatches(true, 0, "Via:", 0, 4)) {
                vialist.add(ln);
                continue;
            }
            if (!ln.regionMatches(true, 0, "v:", 0, 2)) continue;
            vialist.add(ln);
        }
        return vialist.toArray(new String[0]);
    }

    protected String[] getroutelist(String[] msg) {
        ArrayList<CallSite> routelist = new ArrayList<CallSite>();
        for (int a = 0; a < msg.length; ++a) {
            String ln = msg[a];
            if (!ln.regionMatches(true, 0, "Record-Route:", 0, 13)) continue;
            routelist.add((CallSite)((Object)("Route:" + ln.substring(13))));
        }
        return routelist.toArray(new String[0]);
    }

    protected String getrinstance() {
        if (this.rinstance != null) {
            return this.rinstance;
        }
        this.rinstance = String.format("%x%x", this.r.nextInt(), this.r.nextInt());
        return this.rinstance;
    }

    protected String gettupleid() {
        if (this.tupleid != null) {
            return this.tupleid;
        }
        this.tupleid = String.format("%08x", this.r.nextInt());
        return this.tupleid;
    }

    protected String geturi(String[] msg) {
        int idx1 = msg[0].indexOf(32);
        if (idx1 == -1) {
            return null;
        }
        int idx2 = msg[0].substring(idx1 + 1).indexOf(32);
        if (idx2 == -1) {
            return null;
        }
        return msg[0].substring(idx1 + 1).substring(0, idx2);
    }

    public static String generatetag() {
        Random r = new Random();
        return String.format("null<sip:null@null>;tag=%x%x", r.nextInt(), r.nextInt());
    }

    public static String[] replacetag(String[] fields, String newfield) {
        int i;
        if (newfield == null) {
            return fields;
        }
        String[] newfields = SIP.split(newfield);
        int oldtagidx = -1;
        boolean seperator = false;
        for (i = 3; i < fields.length; ++i) {
            if (!seperator) {
                if (!fields[i].equals(":")) continue;
                seperator = true;
                continue;
            }
            if (!fields[i].startsWith("tag=")) continue;
            oldtagidx = i;
            break;
        }
        seperator = false;
        for (i = 3; i < newfields.length; ++i) {
            if (!seperator) {
                if (!newfields[i].equals(":")) continue;
                seperator = true;
                continue;
            }
            if (!newfields[i].startsWith("tag=")) continue;
            if (oldtagidx != -1) {
                fields[oldtagidx] = newfields[i];
                return fields;
            }
            String[] retfields = new String[fields.length + 1];
            for (int j = 0; j < fields.length; ++j) {
                retfields[j] = fields[j];
            }
            retfields[fields.length] = newfields[i];
            return retfields;
        }
        return fields;
    }

    public static String[] removetag(String[] fields) {
        boolean seperator = false;
        for (int i = 3; i < fields.length; ++i) {
            int j;
            if (!seperator) {
                if (!fields[i].equals(":")) continue;
                seperator = true;
                continue;
            }
            if (!fields[i].startsWith("tag=")) continue;
            String[] newfields = new String[fields.length - 1];
            for (j = 0; j < i; ++j) {
                newfields[j] = fields[j];
            }
            for (j = i + 1; j < fields.length; ++j) {
                newfields[j - 1] = fields[j];
            }
            return newfields;
        }
        return fields;
    }

    public static String gettag(String[] fields) {
        boolean seperator = false;
        for (int i = 3; i < fields.length; ++i) {
            if (!seperator) {
                if (!fields[i].equals(":")) continue;
                seperator = true;
                continue;
            }
            if (!fields[i].startsWith("tag=")) continue;
            return fields[i].substring(4);
        }
        return null;
    }

    public String getcallid() {
        return String.format("%x%x", this.r.nextInt(), System.currentTimeMillis());
    }

    protected long getNow() {
        return System.currentTimeMillis() / 1000L;
    }

    protected String getnonce() {
        return String.format("%x%x%x%x", this.r.nextInt(), this.r.nextInt(), System.currentTimeMillis(), this.r.nextInt());
    }

    public static String getCodecName(int id) {
        switch (id) {
            case 0: {
                return "PCMU";
            }
            case 3: {
                return "GSM";
            }
            case 8: {
                return "PCMA";
            }
            case 9: {
                return "G722";
            }
            case 26: {
                return "JPEG";
            }
            case 18: {
                return "G729";
            }
            case 34: {
                return "H263";
            }
        }
        return "?";
    }

    public static SDP getSDP(String[] msg) {
        return SDP.getSDP(msg, 0);
    }

    public static boolean hasCodec(Codec[] codecs, Codec codec) {
        for (int a = 0; a < codecs.length; ++a) {
            if (!codecs[a].name.equals(codec.name)) continue;
            return true;
        }
        return false;
    }

    public static Codec[] addCodec(Codec[] codecs, Codec codec) {
        Codec[] newCodecs = new Codec[codecs.length + 1];
        for (int a = 0; a < codecs.length; ++a) {
            newCodecs[a] = codecs[a];
        }
        newCodecs[codecs.length] = codec;
        return newCodecs;
    }

    public static Codec[] delCodec(Codec[] codecs, Codec codec) {
        if (!SIP.hasCodec(codecs, codec)) {
            return codecs;
        }
        Codec[] newCodecs = new Codec[codecs.length - 1];
        int pos = 0;
        for (int a = 0; a < codecs.length; ++a) {
            if (codecs[a].name.equals(codec.name)) continue;
            newCodecs[pos++] = codecs[a];
        }
        return newCodecs;
    }

    public static Codec getCodec(Codec[] codecs, Codec codec) {
        for (int a = 0; a < codecs.length; ++a) {
            if (!codecs[a].name.equals(codec.name)) continue;
            return codecs[a];
        }
        return null;
    }

    protected String getRequest(String[] msg) {
        int idx = msg[0].indexOf(" ");
        if (idx == -1) {
            return null;
        }
        return msg[0].substring(0, idx);
    }

    protected String getURI(String[] msg) {
        String[] parts = msg[0].split(" ");
        return parts[1];
    }

    protected int getResponseType(String[] msg) {
        if (msg[0].length() < 11) {
            return -1;
        }
        if (!msg[0].regionMatches(true, 0, "SIP/2.0 ", 0, 8)) {
            return -1;
        }
        return Integer.valueOf(msg[0].substring(8, 11));
    }

    public static String getHeader(String header, String[] msg) {
        int sl = header.length();
        for (int a = 0; a < msg.length; ++a) {
            String ln = msg[a];
            if (ln.length() < sl || !ln.substring(0, sl).equalsIgnoreCase(header)) continue;
            return ln.substring(sl).trim().replaceAll("\"", "");
        }
        return null;
    }

    public static String[] getHeaders(String header, String[] msg) {
        ArrayList<String> lst = new ArrayList<String>();
        int sl = header.length();
        for (int a = 0; a < msg.length; ++a) {
            String ln = msg[a];
            if (ln.length() < sl || !ln.substring(0, sl).equalsIgnoreCase(header)) continue;
            lst.add(ln.substring(sl).trim().replaceAll("\"", ""));
        }
        return lst.toArray(new String[0]);
    }

    protected int getcseq(String[] msg) {
        String cseqstr = SIP.getHeader("CSeq:", msg);
        if (cseqstr == null) {
            return -1;
        }
        String[] parts = cseqstr.split(" ");
        return Integer.valueOf(parts[0]);
    }

    protected String getcseqcmd(String[] msg) {
        String cseqstr = SIP.getHeader("CSeq:", msg);
        if (cseqstr == null) {
            return null;
        }
        String[] parts = cseqstr.split(" ");
        if (parts.length < 2) {
            return null;
        }
        return parts[1];
    }

    protected String getResponse(String user, String pass, String realm, String cmd, String uri, String nonce, String qop, String nc, String cnonce) {
        MD5 md5 = new MD5();
        Object H1 = user + ":" + realm + ":" + pass;
        md5.init();
        md5.add(((String)H1).getBytes(), 0, ((String)H1).length());
        H1 = new String(md5.byte2char(md5.done()));
        Object H2 = cmd + ":" + uri;
        md5.init();
        md5.add(((String)H2).getBytes(), 0, ((String)H2).length());
        H2 = new String(md5.byte2char(md5.done()));
        String H3 = (String)H1 + ":" + nonce + ":";
        if (qop != null && qop.length() > 0) {
            H3 = H3 + nc + ":" + cnonce + ":" + qop + ":";
        }
        H3 = H3 + (String)H2;
        md5.init();
        md5.add(H3.getBytes(), 0, H3.length());
        return new String(md5.byte2char(md5.done()));
    }

    private String[] split(String in, char delimit) {
        ArrayList<String> strs = new ArrayList<String>();
        boolean inquote = false;
        char[] ca = in.toCharArray();
        int p1 = 0;
        int p2 = 0;
        for (int a = 0; a < ca.length; ++a) {
            char ch = ca[a];
            if (ch == delimit && !inquote) {
                strs.add(in.substring(p1, p2).trim());
                p1 = ++p2;
                continue;
            }
            if (ch == '\"') {
                inquote = !inquote;
            }
            ++p2;
        }
        if (p2 > p1) {
            strs.add(in.substring(p1, p2).trim());
        }
        return strs.toArray(new String[strs.size()]);
    }

    protected String getAuthResponse(CallDetails cd, String user, String pass, String remote, String cmd, String header) {
        String request = cd.authstr;
        if (!request.regionMatches(true, 0, "Digest ", 0, 7)) {
            JFLog.log("err:no digest");
            return null;
        }
        String[] tags = this.split(request.substring(7), ',');
        String nonce = null;
        String qop = null;
        String cnonce = null;
        String nc = null;
        String stale = null;
        String realm = null;
        String auth = SIP.getHeader("algorithm=", tags);
        if (auth != null && !auth.equalsIgnoreCase("MD5")) {
            JFLog.log("err:only MD5 auth supported");
            return null;
        }
        realm = SIP.getHeader("realm=", tags);
        nonce = SIP.getHeader("nonce=", tags);
        qop = SIP.getHeader("qop=", tags);
        stale = SIP.getHeader("stale=", tags);
        if (nonce == null) {
            JFLog.log("err:no nonce");
            return null;
        }
        if (realm == null) {
            JFLog.log("err:no realm");
            return null;
        }
        if (qop != null) {
            String[] qops = qop.split(",");
            qop = null;
            for (int a = 0; a < qops.length; ++a) {
                if (!qops[a].trim().equals("auth")) continue;
                qop = "auth";
                break;
            }
            if (qop != null) {
                cnonce = this.getnonce();
                cd.nonceCount = cd.nonce != null && cd.nonce.equals(nonce) ? ++cd.nonceCount : 1;
                nc = String.format("%08x", cd.nonceCount);
            }
        }
        cd.nonce = nonce;
        String response = this.getResponse(user, pass, realm, cmd, "sip:" + remote, nonce, qop, nc, cnonce);
        StringBuilder ret = new StringBuilder();
        ret.append(header);
        ret.append(" Digest username=\"" + user + "\", realm=\"" + realm + "\", uri=\"sip:" + remote + "\", nonce=\"" + nonce + "\"");
        if (cnonce != null) {
            ret.append(", cnonce=\"" + cnonce + "\"");
        }
        if (qop != null) {
            ret.append(", nc=" + nc);
            ret.append(", qop=" + qop);
        }
        ret.append(", response=\"" + response + "\"");
        ret.append(", algorithm=MD5\r\n");
        return ret.toString();
    }

    protected String getremotertphost(String[] msg) {
        String c = SIP.getHeader("c=", msg);
        if (c == null) {
            return null;
        }
        int idx = c.indexOf("IP4 ");
        if (idx == -1) {
            return null;
        }
        return c.substring(idx + 4);
    }

    protected int getremotertpport(String[] msg) {
        String m = SIP.getHeader("m=audio ", msg);
        if (m == null) {
            return -1;
        }
        int idx = m.indexOf(32);
        if (idx == -1) {
            return -1;
        }
        return Integer.valueOf(m.substring(0, idx));
    }

    protected int getremoteVrtpport(String[] msg) {
        String m = SIP.getHeader("m=video ", msg);
        if (m == null) {
            return -1;
        }
        int idx = m.indexOf(32);
        if (idx == -1) {
            return -1;
        }
        return Integer.valueOf(m.substring(0, idx));
    }

    public int getexpires(String[] msg) {
        String expires = SIP.getHeader("Expires:", msg);
        if (expires != null) {
            return JF.atoi(expires);
        }
        String contact = SIP.getHeader("Contact:", msg);
        if (contact == null) {
            contact = SIP.getHeader("c:", msg);
        }
        if (contact == null) {
            return -1;
        }
        String[] tags = SIP.split(contact);
        expires = SIP.getHeader("expires=", tags);
        if (expires == null) {
            return -1;
        }
        return JF.atoi(expires);
    }

    public abstract String getlocalRTPhost(CallDetails var1);

    public String[] buildsdp(CallDetails cd, CallDetails.SideDetails cdsd) {
        SDP sdp = cdsd.sdp;
        if (sdp.ip == null) {
            sdp.ip = this.getlocalRTPhost(cd);
        }
        return sdp.build(cd.localhost);
    }

    public static void setResolver() {
        dns_system = true;
        dns_transport = 0;
        dns_server = "8.8.8.8";
    }

    public static void setResolver(int transport, String server) {
        dns_system = false;
        dns_transport = transport;
        dns_server = server;
    }

    public void setremoteport(int port) {
    }

    private static boolean contains(String[] list, String find) {
        for (String item : list) {
            if (!item.equals(find)) continue;
            return true;
        }
        return false;
    }

    private String resolve(DNS dns, String host) throws Exception {
        String port;
        int idx;
        String[] reply = dns.resolve(1, host);
        if (reply == null && (reply = dns.resolve(35, host)) != null) {
            String service2 = null;
            switch (this.transport.getName()) {
                case "UDP": {
                    service2 = "_sip._udp";
                    break;
                }
                case "TCP": {
                    service2 = "_sip._tcp";
                    break;
                }
                case "TLS": {
                    service2 = "_sips._tcp";
                }
            }
            for (String newhost : reply) {
                if (!newhost.startsWith(service2) || newhost.equals(host)) continue;
                JFLog.log("DNS.resolve:using NAPTR:" + newhost);
                return this.resolve(dns, newhost);
            }
            throw new Exception("SIP.resolve:no valid NAPTR record found:" + host);
        }
        if (reply == null && (reply = dns.resolve(33, host)) != null) {
            String newhost = reply[0];
            idx = newhost.indexOf(58);
            if (idx != -1) {
                port = newhost.substring(idx + 1);
                this.setremoteport(JF.atoi(port));
                newhost = newhost.substring(0, idx);
            }
            if (!newhost.equals(host)) {
                JFLog.log("SIP.resolve:using SRV:" + newhost);
                return this.resolve(dns, newhost);
            }
        }
        if (reply == null) {
            reply = dns.resolve(2, host);
            if (reply == null || SIP.contains(reply, host)) {
                throw new Exception("SIP.resolve:host not found:" + host);
            }
            JFLog.log("DNS.resolve:using NS:" + reply[0]);
            dns = new DNS(dns_transport, reply[0]);
            return this.resolve(dns, host);
        }
        if (reply == null) {
            reply = dns.resolve(6, host);
            if (reply == null || SIP.contains(reply, host)) {
                throw new Exception("SIP.resolve:host not found:" + host);
            }
            JFLog.log("DNS.resolve:using SOA:" + reply[0]);
            dns = new DNS(dns_transport, reply[0]);
            return this.resolve(dns, host);
        }
        String ip = reply[0];
        idx = ip.indexOf(58);
        if (idx != -1) {
            port = ip.substring(idx + 1);
            JFLog.log("SIP.resolve:discarding port:" + port);
            ip = ip.substring(0, idx);
        }
        return ip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String resolve(String host) {
        String ip = null;
        Object object = dnsCacheLock;
        synchronized (object) {
            ip = dnsCache.get(host);
        }
        if (ip != null) {
            return ip;
        }
        if (dns_system || IP4.isIP(host) || IP6.isIP(host)) {
            try {
                ip = InetAddress.getByName(host).getHostAddress();
            }
            catch (Exception e) {
                JFLog.log(e);
                return null;
            }
        }
        try {
            DNS dns = new DNS(dns_transport, dns_server);
            ip = this.resolve(dns, host);
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
        JFLog.log("dns:" + host + "=" + ip);
        object = dnsCacheLock;
        synchronized (object) {
            dnsCache.put(host, ip);
        }
        return ip;
    }

    @Override
    public void onConnect(String host, int port) {
    }

    @Override
    public void onDisconnect(String host, int port) {
    }

    private class Worker
    extends Thread {
        private Worker() {
        }

        @Override
        public void run() {
            while (SIP.this.active) {
                try {
                    byte[] data = new byte[1460];
                    Packet pack = new Packet();
                    pack.data = data;
                    if (!SIP.this.transport.receive(pack) || pack.length <= 4) continue;
                    String[] msg = new String(pack.data, 0, pack.length).replaceAll("\r", "").split("\n", -1);
                    if (SIP.this.server) {
                        WorkerPacket wp = new WorkerPacket(msg, pack.host, pack.port);
                        wp.start();
                        continue;
                    }
                    SIP.this.iface.packet(msg, pack.host, pack.port);
                }
                catch (Exception e) {
                    JFLog.log(e);
                }
            }
        }
    }

    private class WorkerPacket
    extends Thread {
        String[] x1;
        String x2;
        int x3;

        public WorkerPacket(String[] x1, String x2, int x3) {
            this.x1 = x1;
            this.x2 = x2;
            this.x3 = x3;
        }

        @Override
        public void run() {
            SIP.this.iface.packet(this.x1, this.x2, this.x3);
        }
    }
}

