/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Random;
import javaforce.HTTP;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.STUN;
import javaforce.voip.CallDetails;
import javaforce.voip.RTP;
import javaforce.voip.SDP;
import javaforce.voip.SIP;
import javaforce.voip.SIPClientInterface;
import javaforce.voip.SIPInterface;
import javaforce.voip.TransportType;

public class SIPClient
extends SIP
implements SIPInterface,
STUN.Listener {
    private String remotehost;
    private String remoteip;
    private InetAddress remoteaddr;
    private int remoteport;
    private String name;
    private String user;
    private String auth;
    private String pass;
    private SIPClientInterface iface;
    private String localhost;
    private int localport;
    private int rport = -1;
    private static boolean use_received = true;
    private static boolean use_rport = true;
    private HashMap<String, CallDetails> cdlist;
    private boolean registered;
    private static NAT nat = NAT.None;
    private static boolean useNATOnPrivateNetwork = false;
    private static String stunHost;
    private static String stunUser;
    private static String stunPass;
    private boolean caller;
    private int log = -1;
    public Object rtmp;
    public Object userobj;
    public int expires;
    private STUN stun;
    private final Object stunLock = new Object();
    private volatile boolean stunWaiting = false;
    private volatile boolean stunResponse = false;

    public String getUser() {
        return this.user;
    }

    public String getRemoteHost() {
        return this.remotehost;
    }

    public boolean isHold(String callid) {
        CallDetails cd = this.getCallDetails(callid);
        if (cd.dst.sdp == null) {
            return false;
        }
        return cd.dst.sdp.getFirstAudioStream().canSend();
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public boolean init(String remotehost, int remoteport, int localport, SIPClientInterface iface, TransportType type) {
        this.iface = iface;
        this.localport = localport;
        this.cdlist = new HashMap();
        try {
            if (!super.init(this.localhost, localport, this, false, type)) {
                return false;
            }
            this.remoteport = remoteport;
            this.remotehost = remotehost;
            this.remoteip = this.resolve(remotehost);
            this.remoteaddr = InetAddress.getByName(this.remoteip);
            if (!(nat != NAT.STUN && nat != NAT.ICE || this.startSTUN())) {
                return false;
            }
            this.findlocalhost();
            JFLog.log("localhost = " + this.localhost + " for remotehost = " + remotehost);
            if (this.remotehost.equals("127.0.0.1")) {
                this.remotehost = this.localhost;
                this.remoteip = this.resolve(this.remotehost);
                JFLog.log("changed 127.0.0.1 to " + this.remotehost + " " + this.remoteip);
            }
            if (nat == NAT.STUN || nat == NAT.ICE) {
                this.stopSTUN();
            }
            return true;
        }
        catch (Exception e) {
            if (this.stun != null) {
                this.stopSTUN();
            }
            JFLog.log(e);
            return false;
        }
    }

    @Override
    public void uninit() {
        if (this.log != -1) {
            JFLog.close(this.log);
        }
        super.uninit();
    }

    public void log(int id, String file) {
        this.log = id;
        JFLog.init(id, file, false);
    }

    public static void setNAT(NAT nat, String host, String user, String pass) {
        SIPClient.nat = nat;
        stunHost = host;
        stunUser = user;
        stunPass = pass;
    }

    public static void useNATOnPrivateNetwork(boolean state) {
        useNATOnPrivateNetwork = state;
    }

    private String cleanString(String in) {
        return in.replaceAll("\"", "");
    }

    public boolean register(String displayName, String userAccount, String authName, String password) {
        return this.register(displayName, userAccount, authName, password, 3600);
    }

    public boolean register(String displayName, String userAccount, String authName, String password, int expires) {
        String regcallid = this.getcallid();
        CallDetails cd = this.getCallDetails(regcallid);
        if (userAccount == null || userAccount.length() == 0) {
            return false;
        }
        userAccount = this.cleanString(userAccount);
        this.auth = authName == null || authName.length() == 0 ? userAccount : this.cleanString(authName);
        this.name = displayName == null || displayName.length() == 0 ? userAccount : this.cleanString(displayName);
        this.user = userAccount;
        this.pass = password;
        this.expires = expires;
        cd.src.expires = expires;
        cd.src.to = new String[]{this.name, this.user, this.remotehost + ":" + this.remoteport, ":"};
        cd.src.from = new String[]{this.name, this.user, this.remotehost + ":" + this.remoteport, ":"};
        cd.src.from = SIPClient.replacetag(cd.src.from, SIPClient.generatetag());
        cd.src.contact = "<sip:" + this.user + "@" + cd.localhost + ":" + this.getlocalport() + ">";
        cd.uri = "sip:" + this.remotehost;
        cd.src.branch = this.getbranch();
        ++cd.src.cseq;
        if (password == null || password.length() == 0) {
            return true;
        }
        cd.authsent = false;
        cd.src.extra = null;
        cd.src.epass = null;
        boolean ret = this.issue(cd, "REGISTER", false, true);
        return ret;
    }

    public boolean reregister() {
        return this.register(this.name, this.user, this.auth, this.pass, this.expires);
    }

    public boolean unregister() {
        return this.register(this.name, this.user, this.auth, this.pass, 0);
    }

    public boolean publish(String state) {
        String pubcallid = this.getcallid();
        CallDetails cd = this.getCallDetails(pubcallid);
        cd.src.to = new String[]{this.name, this.user, this.remotehost + ":" + this.remoteport, ":"};
        cd.src.from = new String[]{this.name, this.user, this.remotehost + ":" + this.remoteport, ":"};
        cd.src.from = SIPClient.replacetag(cd.src.from, SIPClient.generatetag());
        cd.src.contact = "<sip:" + this.user + "@" + cd.localhost + ":" + this.getlocalport() + ">";
        cd.uri = "sip:" + this.user + "@" + this.remotehost;
        cd.src.branch = this.getbranch();
        ++cd.src.cseq;
        cd.sdp = new String[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "<presence xmlns=\"urn:ietf:params:xml:ns:pidf\" entity=\"pres:" + this.user + "@" + this.remotehost + "\">", "<tuple id=\"" + this.gettupleid() + "\">", "<status>", "<basic>" + state + "</basic>", "</status>", "</tuple>", "</presence>"};
        cd.authsent = false;
        cd.src.extra = "Event: presence\r\n";
        cd.src.epass = null;
        return this.issue(cd, "PUBLISH", true, true);
    }

    public boolean subscribe(String subuser, String event, int expires) {
        String subcallid = this.getcallid();
        CallDetails cd = this.getCallDetails(subcallid);
        cd.src.to = new String[]{subuser, subuser, this.remotehost + ":" + this.remoteport, ":"};
        cd.src.from = new String[]{this.name, this.user, this.remotehost + ":" + this.remoteport, ":"};
        cd.src.from = SIPClient.replacetag(cd.src.from, SIPClient.generatetag());
        cd.src.contact = "<sip:" + this.user + "@" + cd.localhost + ":" + this.getlocalport() + ">";
        cd.uri = "sip:" + subuser + "@" + this.remotehost;
        cd.src.branch = this.getbranch();
        ++cd.src.cseq;
        cd.src.expires = expires;
        cd.src.extra = "Accept: multipart/related, application/rlmi+xml, application/pidf+xml\r\nEvent: " + event + "\r\n";
        cd.src.epass = null;
        return this.issue(cd, "SUBSCRIBE", false, true);
    }

    public void keepalive() {
        this.send(this.remoteaddr, this.remoteport, "\r\n\r\n");
    }

    public static boolean isPrivateNetwork(String ip) {
        if (ip.startsWith("192.168.")) {
            return true;
        }
        if (ip.startsWith("10.")) {
            return true;
        }
        if (ip.startsWith("169.254.")) {
            return true;
        }
        for (int a = 16; a <= 31; ++a) {
            if (!ip.startsWith("172." + a + ".")) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getlocalRTPhost(CallDetails cd) {
        if (RTP.useTURN) {
            return RTP.getTurnIP();
        }
        return cd.localhost;
    }

    private boolean findlocalhost_webserver(String host) {
        try {
            Socket s = new Socket();
            s.connect(new InetSocketAddress(host, 80), 1000);
            this.localhost = s.getLocalAddress().getHostAddress();
            try {
                s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            JFLog.log("Detected IP connecting to WebServer at " + host);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean startSTUN() {
        this.stun = new STUN();
        return this.stun.start(this.localport, stunHost, stunUser, stunPass, this);
    }

    private void stopSTUN() {
        if (this.stun == null) {
            return;
        }
        this.stun.close();
        this.stun = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stunPublicIP(STUN stun, String ip, int port) {
        Object object = this.stunLock;
        synchronized (object) {
            if (this.stunWaiting) {
                this.rport = port;
                this.stunResponse = true;
                this.stunLock.notify();
            }
        }
    }

    @Override
    public void turnAlloc(STUN stun, String ip, int port, byte[] token, int lifetime) {
    }

    @Override
    public void turnBind(STUN stun) {
    }

    @Override
    public void turnRefresh(STUN stun, int lifetime) {
    }

    @Override
    public void turnFailed(STUN stun) {
    }

    @Override
    public void turnData(STUN stun, byte[] data, int offset, int length, short channel) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findlocalhost_stun() {
        this.stunResponse = false;
        this.stunWaiting = true;
        Object object = this.stunLock;
        synchronized (object) {
            this.stun.requestPublicIP();
            try {
                this.stunLock.wait(1000L);
            }
            catch (Exception e) {
                JFLog.log(e);
            }
            this.stunWaiting = false;
        }
        if (this.stunResponse) {
            JFLog.log("Detected IP using STUN");
        }
        return this.stunResponse;
    }

    private boolean findlocalhost_java() {
        try {
            InetAddress local = InetAddress.getLocalHost();
            this.localhost = local.getHostAddress();
            JFLog.log("Detected IP using Java:" + this.localhost);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void findlocalhost() {
        JFLog.log("Detecting localhost for remotehost = " + this.remotehost);
        if (!(!useNATOnPrivateNetwork && SIPClient.isPrivateNetwork(this.remoteip) || nat != NAT.STUN && nat != NAT.ICE)) {
            if (this.findlocalhost_stun()) {
                return;
            }
            JFLog.log("SIP:STUN:Failed");
        }
        if (this.findlocalhost_webserver(this.remotehost)) {
            return;
        }
        if (this.findlocalhost_java()) {
            return;
        }
        Random r = new Random();
        this.localhost = "169.254." + r.nextInt(256) + "." + r.nextInt(256);
    }

    private synchronized CallDetails getCallDetails(String callid) {
        CallDetails cd = this.cdlist.get(callid);
        if (cd == null) {
            cd = new CallDetails();
            JFLog.log("Create CallDetails:" + callid);
            cd.callid = callid;
            cd.localhost = this.localhost;
            this.setCallDetails(callid, cd);
        }
        return cd;
    }

    private void setCallDetails(String callid, CallDetails cd) {
        if (cd == null) {
            JFLog.log("Delete CallDetails:" + callid);
            this.cdlist.remove(callid);
        } else {
            this.cdlist.put(callid, cd);
        }
    }

    private boolean issue(CallDetails cd, String cmd, boolean sdp, boolean src) {
        CallDetails.SideDetails cdsd = src ? cd.src : cd.dst;
        JFLog.log("callid:" + cd.callid + "\r\nissue command : " + cmd + " from : " + this.user + " to : " + this.remotehost);
        cd.dst.host = this.remoteip;
        cd.dst.port = this.remoteport;
        StringBuilder req = new StringBuilder();
        if (cd.uri == null) {
            cd.uri = "sip:" + this.user + "@" + this.remotehost;
        }
        req.append(cmd + " " + cd.uri + " SIP/2.0\r\n");
        req.append("Via: SIP/2.0/" + this.transport.getName() + " " + cd.localhost + ":" + this.getlocalport() + ";branch=" + cdsd.branch + (use_rport ? ";rport" : "") + "\r\n");
        req.append("Max-Forwards: 70\r\n");
        if (cdsd.routelist != null) {
            for (int a = cdsd.routelist.length - 1; a >= 0; --a) {
                req.append(cdsd.routelist[a]);
                req.append("\r\n");
            }
        }
        if (cdsd.contact != null) {
            req.append("Contact: " + cdsd.contact + "\r\n");
        }
        req.append("To: " + SIPClient.join(cdsd.to) + "\r\n");
        req.append("From: " + SIPClient.join(cdsd.from) + "\r\n");
        req.append("Call-ID: " + cd.callid + "\r\n");
        req.append("Cseq: " + cdsd.cseq + " " + cmd + "\r\n");
        if (cmd.equals("REGISTER") || cmd.equals("PUBLISH") || cmd.equals("SUBSCRIBE")) {
            req.append("Expires: " + cdsd.expires + "\r\n");
        }
        req.append("Allow: INVITE, ACK, CANCEL, BYE, REFER, NOTIFY, OPTIONS, MESSAGE\r\n");
        req.append("User-Agent: " + useragent + "\r\n");
        if (cdsd.extra != null) {
            req.append(cdsd.extra);
        }
        if (cdsd.epass != null) {
            req.append(cdsd.epass);
        }
        String post = null;
        if (cd.sdp != null && sdp) {
            post = String.join((CharSequence)"\r\n", cd.sdp) + "\r\n";
            if (post.startsWith("<?xml")) {
                req.append("Content-Type: application/pidf+xml\r\n");
            } else if (post.startsWith("SIP/2.0")) {
                req.append("Content-Type: message/sipfrag;version=2.0\r\n");
            } else if (cmd.equals("MESSAGE")) {
                req.append("Content-Type: text/plain\r\n");
            } else {
                req.append("Content-Type: application/sdp\r\n");
            }
            req.append("Content-Length: " + post.length() + "\r\n\r\n");
            req.append(post);
        } else {
            req.append("Content-Length: 0\r\n\r\n");
        }
        String sip = req.toString();
        if (this.log != -1) {
            JFLog.log(this.log, "Client -> Server");
            JFLog.log(this.log, sip);
        }
        return this.send(this.remoteaddr, this.remoteport, sip);
    }

    private boolean reply(CallDetails cd, String cmd, int code, String msg, boolean sdp, boolean src) {
        int a;
        JFLog.log("callid:" + cd.callid + "\r\nissue reply : " + code + " to : " + this.remotehost);
        CallDetails.SideDetails cdsd = src ? cd.src : cd.dst;
        StringBuilder req = new StringBuilder();
        req.append("SIP/2.0 " + code + " " + msg + "\r\n");
        if (cdsd.vialist != null) {
            for (a = 0; a < cdsd.vialist.length; ++a) {
                req.append(cdsd.vialist[a]);
                req.append("\r\n");
            }
        }
        if (cdsd.vialist == null || cdsd.vialist.length == 0) {
            req.append("Via: SIP/2.0/" + this.transport.getName() + " " + cd.localhost + ":" + this.getlocalport() + ";branch=" + cdsd.branch + (use_rport ? ";rport" : "") + "\r\n");
        }
        if (cdsd.routelist != null) {
            for (a = cdsd.routelist.length - 1; a >= 0; --a) {
                req.append(cdsd.routelist[a]);
                req.append("\r\n");
            }
        }
        req.append("Contact: " + cdsd.contact + "\r\n");
        req.append("To: " + SIPClient.join(cdsd.to) + "\r\n");
        req.append("From: " + SIPClient.join(cdsd.from) + "\r\n");
        req.append("Call-ID: " + cd.callid + "\r\n");
        req.append("Cseq: " + cdsd.cseq + " " + cmd + "\r\n");
        req.append("Allow: INVITE, ACK, CANCEL, BYE, REFER, NOTIFY, OPTIONS, MESSAGE\r\n");
        req.append("User-Agent: JavaForce\r\n");
        if (cd.sdp != null && sdp) {
            String post = String.join((CharSequence)"\r\n", cd.sdp) + "\r\n";
            req.append("Content-Type: application/sdp\r\n");
            req.append("Content-Length: " + post.length() + "\r\n\r\n");
            req.append(post);
        } else {
            req.append("Content-Length: 0\r\n\r\n");
        }
        String sip = req.toString();
        if (this.log != -1) {
            JFLog.log(this.log, "Client -> Server");
            JFLog.log(this.log, sip);
        }
        this.send(this.remoteaddr, this.remoteport, sip);
        return true;
    }

    public String invite(String to, SDP sdp) {
        this.caller = true;
        String callid = this.getcallid();
        CallDetails cd = this.getCallDetails(callid);
        cd.src.to = new String[]{to, to, this.remotehost + ":" + this.remoteport, ":"};
        cd.src.from = new String[]{this.name, this.user, this.remotehost + ":" + this.remoteport, ":"};
        cd.src.contact = "<sip:" + this.user + "@" + cd.localhost + ":" + this.getlocalport() + ">";
        cd.uri = "sip:" + to + "@" + this.remotehost + ":" + this.remoteport;
        cd.src.from = SIPClient.replacetag(cd.src.from, SIPClient.generatetag());
        cd.src.branch = this.getbranch();
        cd.src.sdp = sdp;
        cd.sdp = this.buildsdp(cd, cd.src);
        ++cd.src.cseq;
        cd.authsent = false;
        cd.src.extra = null;
        cd.src.epass = null;
        if (!this.issue(cd, "INVITE", true, true)) {
            return null;
        }
        return callid;
    }

    public boolean refer(String callid, String to) {
        String headers = "Refer-To: <sip:" + to + "@" + this.remotehost + ">\r\nReferred-By: <sip:" + this.user + "@" + this.remotehost + ":" + this.getlocalport() + ">\r\n";
        CallDetails cd = this.getCallDetails(callid);
        cd.src.epass = cd.authstr != null ? this.getAuthResponse(cd, this.auth, this.pass, this.remotehost, "REFER", "Proxy-Authorization:") : null;
        cd.uri = "sip:" + cd.src.to[1] + "@" + this.remotehost + ":" + this.remoteport;
        ++cd.src.cseq;
        cd.authsent = false;
        cd.src.extra = headers;
        cd.src.epass = null;
        boolean ret = this.issue(cd, "REFER", false, true);
        return ret;
    }

    public boolean referLive(String callid, String othercallid) {
        CallDetails cd = this.getCallDetails(callid);
        CallDetails othercd = this.getCallDetails(othercallid);
        String headers = "Refer-To: <sip:" + othercd.src.to[1] + "@" + this.remotehost + "?Replaces=" + othercallid + "%3Bto-tag%3D" + SIPClient.gettag(othercd.src.to) + "%3Bfrom-tag%3D" + SIPClient.gettag(othercd.src.from) + ">\r\n";
        headers = headers + "Supported: gruu, replaces, tdialog\r\n";
        headers = headers + "Require: tdialog\r\n";
        headers = headers + "Target-Dialog: " + callid + ";local-tag=" + SIPClient.gettag(cd.src.to) + ";remote-tag=" + SIPClient.gettag(cd.src.from) + "\r\n";
        cd.uri = "sip:" + cd.src.to[1] + "@" + this.remotehost + ":" + this.remoteport;
        ++cd.src.cseq;
        cd.authsent = false;
        cd.src.extra = headers;
        cd.src.epass = null;
        boolean ret = this.issue(cd, "REFER", false, true);
        return ret;
    }

    public boolean setHold(String callid, boolean state) {
        CallDetails cd = this.getCallDetails(callid);
        cd.src.sdp.getFirstAudioStream().mode = state ? SDP.Mode.inactive : SDP.Mode.sendrecv;
        return true;
    }

    public boolean reinvite(String callid, SDP sdp) {
        CallDetails cd = this.getCallDetails(callid);
        cd.src.sdp = sdp;
        ++cd.src.sdp.o2;
        cd.sdp = this.buildsdp(cd, cd.src);
        cd.uri = "sip:" + cd.src.to[1] + "@" + this.remotehost + ":" + this.remoteport;
        ++cd.src.cseq;
        cd.authsent = false;
        cd.src.extra = null;
        cd.src.epass = cd.authstr != null ? this.getAuthResponse(cd, this.auth, this.pass, this.remotehost, "INVITE", "Proxy-Authorization:") : null;
        return this.issue(cd, "INVITE", true, true);
    }

    public boolean reinvite(String callid) {
        CallDetails cd = this.getCallDetails(callid);
        return this.reinvite(callid, cd.src.sdp);
    }

    public boolean cancel(String callid) {
        CallDetails cd = this.getCallDetails(callid);
        cd.src.epass = cd.authstr != null ? this.getAuthResponse(cd, this.auth, this.pass, this.remotehost, "BYE", "Proxy-Authorization:") : null;
        cd.authsent = false;
        if (cd.dst.to != null) {
            cd.src.to = cd.dst.to;
        }
        if (cd.dst.from != null) {
            cd.src.from = cd.dst.from;
        }
        cd.src.extra = null;
        cd.uri = "sip:" + cd.src.to[1] + "@" + this.remotehost + ":" + this.remoteport;
        boolean ret = this.issue(cd, "CANCEL", false, true);
        return ret;
    }

    public boolean bye(String callid) {
        CallDetails cd = this.getCallDetails(callid);
        cd.src.epass = cd.authstr != null ? this.getAuthResponse(cd, this.auth, this.pass, this.remotehost, "BYE", "Proxy-Authorization:") : null;
        cd.uri = "sip:" + cd.src.to[1] + "@" + this.remotehost + ":" + this.remoteport;
        ++cd.src.cseq;
        cd.authsent = false;
        cd.src.extra = null;
        boolean ret = this.issue(cd, "BYE", false, true);
        return ret;
    }

    public String message(String to, String[] msg) {
        String callid = this.getcallid();
        CallDetails cd = this.getCallDetails(callid);
        cd.src.to = new String[]{to, to, this.remotehost + ":" + this.remoteport, ":"};
        cd.src.from = new String[]{this.name, this.user, this.remotehost + ":" + this.remoteport, ":"};
        cd.src.contact = "<sip:" + this.user + "@" + cd.localhost + ":" + this.getlocalport() + ">";
        cd.uri = "im:" + to + "@" + this.remotehost + ":" + this.remoteport;
        cd.src.from = SIPClient.replacetag(cd.src.from, SIPClient.generatetag());
        cd.src.branch = this.getbranch();
        ++cd.src.cseq;
        cd.sdp = msg;
        if (!this.issue(cd, "MESSAGE", true, true)) {
            return null;
        }
        return callid;
    }

    public String message(String callid, String to, String[] msg) {
        CallDetails cd = this.getCallDetails(callid);
        cd.src.epass = cd.authstr != null ? this.getAuthResponse(cd, this.auth, this.pass, this.remotehost, "BYE", "Proxy-Authorization:") : null;
        cd.authsent = false;
        cd.src.extra = null;
        cd.src.to = new String[]{to, to, this.remotehost + ":" + this.remoteport, ":"};
        cd.uri = "im:" + to + "@" + this.remotehost + ":" + this.remoteport;
        ++cd.src.cseq;
        cd.sdp = msg;
        if (!this.issue(cd, "MESSAGE", true, true)) {
            return null;
        }
        return callid;
    }

    public boolean accept(String callid, SDP sdp) {
        this.caller = false;
        CallDetails cd = this.getCallDetails(callid);
        cd.src.sdp = sdp;
        cd.sdp = this.buildsdp(cd, cd.src);
        this.reply(cd, "INVITE", 200, "OK", true, false);
        cd.src.to = (String[])cd.dst.from.clone();
        cd.src.from = (String[])cd.dst.to.clone();
        cd.src.contact = "<sip:" + this.user + "@" + cd.localhost + ":" + this.getlocalport() + ">";
        cd.src.branch = cd.dst.branch;
        return true;
    }

    public boolean reaccept(String callid, SDP sdp) {
        CallDetails cd = this.getCallDetails(callid);
        cd.src.sdp = sdp;
        cd.sdp = this.buildsdp(cd, cd.src);
        this.reply(cd, "INVITE", 200, "OK", true, false);
        cd.src.contact = "<sip:" + this.user + "@" + cd.localhost + ":" + this.getlocalport() + ">";
        cd.src.branch = cd.dst.branch;
        return true;
    }

    public boolean deny(String callid, String msg, int code) {
        CallDetails cd = this.getCallDetails(callid);
        this.reply(cd, "INVITE", code, msg, false, false);
        return true;
    }

    public void setUserPass(String user, String pass) {
        this.user = user;
        this.pass = pass;
    }

    @Override
    public void packet(String[] msg, String remoteip, int remoteport) {
        try {
            if (!remoteip.equals(this.remoteip) || remoteport != this.remoteport) {
                JFLog.log("Ignoring packet from unknown host:" + remoteip + ":" + remoteport);
                return;
            }
            if (this.log != -1) {
                JFLog.log(this.log, "Server -> Client");
                StringBuilder sip = new StringBuilder();
                for (int a = 0; a < msg.length; ++a) {
                    sip.append(msg[a]);
                    sip.append("\r\n");
                }
                JFLog.log(this.log, sip.toString());
            }
            String req = null;
            String callid = SIPClient.getHeader("Call-ID:", msg);
            if (callid == null) {
                callid = SIPClient.getHeader("i:", msg);
            }
            if (callid == null) {
                JFLog.log("Bad packet (no Call-ID) from:" + remoteip + ":" + remoteport);
                return;
            }
            CallDetails cd = this.getCallDetails(callid);
            if (remoteip.equals("127.0.0.1")) {
                remoteip = cd.localhost;
            }
            cd.dst.host = remoteip;
            cd.dst.port = remoteport;
            cd.dst.cseq = this.getcseq(msg);
            cd.dst.branch = this.getbranch(msg);
            cd.headers = msg;
            String tmp = SIPClient.getHeader("To:", msg);
            if (tmp == null) {
                tmp = SIPClient.getHeader("t:", msg);
            }
            cd.dst.to = SIPClient.split(tmp);
            tmp = SIPClient.getHeader("From:", msg);
            if (tmp == null) {
                tmp = SIPClient.getHeader("f:", msg);
            }
            cd.dst.from = SIPClient.split(tmp);
            String via = SIPClient.getHeader("Via:", msg);
            boolean localhost_changed = false;
            if (via == null) {
                via = SIPClient.getHeader("v:", msg);
            }
            if (via != null) {
                int newrport;
                String rportstr;
                String received;
                String[] f = via.split(";");
                if (use_received && (received = SIPClient.getHeader("received=", f)) != null && !cd.localhost.equals(received)) {
                    this.localhost = received;
                    cd.localhost = received;
                    JFLog.log("received ip=" + received + " for remotehost = " + this.remotehost);
                    localhost_changed = true;
                }
                if (use_rport && (rportstr = SIPClient.getHeader("rport=", f)) != null && rportstr.length() > 0 && this.rport != (newrport = JF.atoi(rportstr))) {
                    this.rport = newrport;
                    JFLog.log("received port=" + this.rport + " for remotehost = " + this.remotehost);
                    localhost_changed = true;
                }
            }
            cd.dst.vialist = this.getvialist(msg);
            cd.dst.routelist = this.getroutelist(msg);
            cd.dst.contact = SIPClient.getHeader("Contact:", msg);
            if (cd.dst.contact == null) {
                cd.dst.contact = SIPClient.getHeader("m:", msg);
            }
            String cmd = this.getcseqcmd(msg);
            int type = this.getResponseType(msg);
            if (type != -1) {
                JFLog.log("callid:" + callid + "\r\nreply=" + type);
                if (cd.dst.vialist.length > 1) {
                    JFLog.log("Multiple Via:s detected in reply, discarding reply");
                    return;
                }
            } else {
                req = this.getRequest(msg);
                cd.uri = this.getURI(msg);
                JFLog.log("callid:" + callid + "\r\nrequest=" + req);
            }
            block1 : switch (type) {
                case -1: {
                    if (req.equals("INVITE")) {
                        if (SIPClient.gettag(cd.dst.to) == null) {
                            cd.dst.to = SIPClient.replacetag(cd.dst.to, SIPClient.generatetag());
                        }
                        cd.dst.sdp = SIPClient.getSDP(msg);
                        ++cd.dst.sdp.o1;
                        ++cd.dst.sdp.o2;
                        switch (this.iface.onInvite(this, callid, cd.dst.from[0], cd.dst.from[1], cd.dst.sdp)) {
                            case 180: {
                                this.reply(cd, cmd, 180, "RINGING", false, false);
                                break block1;
                            }
                            case 200: {
                                cd.sdp = this.buildsdp(cd, cd.src);
                                this.reply(cd, cmd, 200, "OK", true, false);
                                break block1;
                            }
                            case 486: {
                                this.reply(cd, cmd, 486, "BUSY HERE", false, false);
                                break block1;
                            }
                        }
                        break;
                    }
                    if (req.equals("CANCEL")) {
                        this.iface.onCancel(this, callid, 0);
                        this.reply(cd, cmd, 200, "OK", false, false);
                        this.reply(cd, "INVITE", 487, "CANCELLED", false, false);
                        break;
                    }
                    if (req.equals("BYE")) {
                        this.reply(cd, cmd, 200, "OK", false, false);
                        this.iface.onBye(this, callid);
                        break;
                    }
                    if (req.equals("NOTIFY")) {
                        this.reply(cd, cmd, 200, "OK", false, false);
                        String event = SIPClient.getHeader("Event:", msg);
                        if (event == null) {
                            event = SIPClient.getHeader("o:", msg);
                        }
                        this.iface.onNotify(this, callid, event, HTTP.getContent(msg));
                        break;
                    }
                    if (req.equals("ACK")) {
                        SDP sdp = SIPClient.getSDP(msg);
                        if (cd.dst.sdp == null) {
                            cd.dst.sdp = sdp;
                        }
                        this.iface.onAck(this, callid, sdp);
                        if (cmd.equals("BYE")) {
                            this.setCallDetails(callid, null);
                        }
                        break;
                    }
                    if (req.equals("MESSAGE")) {
                        this.iface.onMessage(this, callid, cd.dst.from[0], cd.dst.from[1], HTTP.getContent(msg));
                        this.reply(cd, "MESSAGE", 200, "OK", false, false);
                        break;
                    }
                    this.reply(cd, cmd, 405, "Method Not Allowed", false, false);
                    break;
                }
                case 100: {
                    this.iface.onTrying(this, callid);
                    break;
                }
                case 180: {
                    this.iface.onRinging(this, callid);
                    break;
                }
                case 181: {
                    break;
                }
                case 183: 
                case 200: {
                    if (cmd.equals("REGISTER")) {
                        if (type == 183) break;
                        if (cd.src.expires > 0) {
                            if (localhost_changed) {
                                JFLog.log("localhost change detected, reregister()ing");
                                this.reregister();
                                break;
                            }
                            this.registered = true;
                            this.iface.onRegister(this, true);
                            break;
                        }
                        this.registered = false;
                        break;
                    }
                    if (cmd.equals("INVITE")) {
                        cd.dst.sdp = SIPClient.getSDP(msg);
                        cd.src.to = cd.dst.to;
                        cd.src.epass = null;
                        cd.src.routelist = cd.dst.routelist;
                        if (type == 200) {
                            this.issue(cd, "ACK", false, true);
                        }
                        this.iface.onSuccess(this, callid, cd.dst.sdp, type == 200);
                        break;
                    }
                    if (cmd.equals("BYE")) {
                        if (type == 183) break;
                        this.setCallDetails(callid, null);
                    }
                    break;
                }
                case 202: {
                    if (cmd.equals("REFER")) {
                        this.iface.onRefer(this, callid);
                    }
                    break;
                }
                case 401: 
                case 407: {
                    if (cd.authsent) {
                        JFLog.log("Server Error : Double " + type);
                        break;
                    }
                    String[] src_to = cd.src.to;
                    cd.src.to = cd.dst.to;
                    if (this.iface != null && cmd.equals("INVITE")) {
                        this.issue(cd, "ACK", false, true);
                    }
                    cd.src.to = src_to;
                    cd.authstr = SIPClient.getHeader("WWW-Authenticate:", msg);
                    if (cd.authstr == null) {
                        cd.authstr = SIPClient.getHeader("Proxy-Authenticate:", msg);
                    }
                    if (cd.authstr == null) {
                        JFLog.log("err:401/407 without Authenticate tag");
                        break;
                    }
                    cd.src.epass = this.getAuthResponse(cd, this.auth, this.pass, this.remotehost, cmd, type == 401 ? "Authorization:" : "Proxy-Authorization:");
                    if (cd.src.epass == null) {
                        JFLog.log("err:gen auth failed");
                        break;
                    }
                    ++cd.src.cseq;
                    cd.src.contact = "<sip:" + this.user + "@" + cd.localhost + ":" + this.getlocalport() + ">";
                    this.issue(cd, cmd, cmd.equals("INVITE") || cmd.equals("MESSAGE"), true);
                    cd.authsent = true;
                    break;
                }
                case 403: {
                    cd.src.epass = null;
                    cd.src.cseq = cd.dst.cseq;
                    if (cmd.equals("REGISTER")) {
                        this.iface.onRegister(this, false);
                        break;
                    }
                    this.issue(cd, "ACK", false, true);
                    this.iface.onCancel(this, callid, type);
                    break;
                }
                case 404: 
                case 486: {
                    if (cd.dst.to != null) {
                        cd.src.to = cd.dst.to;
                    }
                    cd.src.epass = null;
                    cd.src.cseq = cd.dst.cseq;
                    this.issue(cd, "ACK", false, true);
                    this.iface.onCancel(this, callid, type);
                    this.setCallDetails(callid, null);
                    break;
                }
                case 481: {
                    break;
                }
                default: {
                    if (cd.dst.to != null) {
                        cd.src.to = cd.dst.to;
                    }
                    cd.src.epass = null;
                    cd.src.cseq = cd.dst.cseq;
                    this.issue(cd, "ACK", false, true);
                    this.iface.onCancel(this, callid, type);
                }
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    private int getlocalport() {
        if (this.rport != -1) {
            return this.rport;
        }
        return this.localport;
    }

    @Override
    public void setremoteport(int port) {
        this.remoteport = port;
    }

    public static void setEnableRport(boolean state) {
        use_rport = state;
    }

    public static void setEnableReceived(boolean state) {
        use_received = state;
    }

    public String[] getSDP(String callid) {
        CallDetails cd = this.getCallDetails(callid);
        cd.sdp = this.buildsdp(cd, cd.dst);
        return cd.sdp;
    }

    public String[] getHeaders(String callid) {
        CallDetails cd = this.getCallDetails(callid);
        return cd.headers;
    }

    public boolean isCaller() {
        return this.caller;
    }

    public static enum NAT {
        None,
        STUN,
        TURN,
        ICE;

    }
}

