/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.voip.Packet;
import javaforce.voip.SIP;
import javaforce.voip.Transport;
import javaforce.voip.TransportInterface;

public class TransportTCPServer
implements Transport {
    protected ServerSocket ss;
    private HashMap<String, Socket> clients = new HashMap();
    private Object clientsLock = new Object();
    private boolean ss_active;
    private boolean ss_error;
    private static final int mtu = 1460;
    private TransportInterface iface;
    public static boolean debug = true;
    private ArrayList<Packet> packets = new ArrayList();
    private Object packetsLock = new Object();

    @Override
    public String getName() {
        return "TCP";
    }

    @Override
    public boolean open(String localhost, int localport, TransportInterface iface) {
        this.iface = iface;
        try {
            this.ss = new ServerSocket(localport);
            this.ss_active = true;
            new WorkerAccepter().start();
        }
        catch (Exception e) {
            if (debug) {
                JFLog.log(e);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean close() {
        block3: {
            this.ss_active = false;
            try {
                if (this.ss != null) {
                    this.ss.close();
                    this.ss = null;
                }
            }
            catch (Exception e) {
                if (!debug) break block3;
                JFLog.log(e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(String host, int port, String id) {
        if (debug) {
            JFLog.log("Transport:remove:" + id);
        }
        this.iface.onDisconnect(host, port);
        Object object = this.clientsLock;
        synchronized (object) {
            this.clients.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean send(byte[] data, int off, int len, InetAddress hostaddr, int port) {
        Socket socket;
        String host = hostaddr.getHostAddress();
        String id = host + ":" + port;
        if (debug) {
            JFLog.log("Transport:get:" + id);
        }
        Object object = this.clientsLock;
        synchronized (object) {
            socket = this.clients.get(id);
        }
        try {
            if (socket == null) {
                socket = this.connect(hostaddr, port, id);
            }
            OutputStream os = socket.getOutputStream();
            os.write(data, off, len);
        }
        catch (SocketException se) {
            if (debug) {
                JFLog.log("TransportTCPServer:Connection lost");
            }
            this.remove(host, port, id);
            return false;
        }
        catch (Exception e) {
            if (debug) {
                JFLog.log(e);
            }
            this.remove(host, port, id);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean receive(Packet packet) {
        while (true) {
            Object object = this.packetsLock;
            synchronized (object) {
                if (this.packets.size() == 0) {
                    try {
                        this.packetsLock.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.packets.size() != 0) {
                    Packet tmp = this.packets.remove(0);
                    System.arraycopy(tmp.data, 0, packet.data, 0, 1460);
                    packet.host = tmp.host;
                    packet.length = tmp.length;
                    packet.port = tmp.port;
                    return true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket connect(InetAddress hostaddr, int port, String id) throws Exception {
        Socket socket = new Socket(hostaddr, port);
        if (debug) {
            JFLog.log("Transport:put:" + id);
        }
        Object object = this.clientsLock;
        synchronized (object) {
            this.clients.put(id, socket);
        }
        this.iface.onConnect(hostaddr.getHostAddress(), port);
        return socket;
    }

    @Override
    public boolean error() {
        return this.ss_error;
    }

    protected class WorkerAccepter
    extends Thread {
        protected WorkerAccepter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (TransportTCPServer.this.ss_active) {
                try {
                    Socket socket = TransportTCPServer.this.ss.accept();
                    InetAddress hostaddr = socket.getInetAddress();
                    String host = hostaddr.getHostAddress();
                    int port = socket.getPort();
                    String id = host + ":" + port;
                    if (debug) {
                        JFLog.log("Transport:put:" + id);
                    }
                    Object object = TransportTCPServer.this.clientsLock;
                    synchronized (object) {
                        TransportTCPServer.this.clients.put(id, socket);
                    }
                    TransportTCPServer.this.iface.onConnect(host, port);
                    new WorkerReader(socket, id, hostaddr, port).start();
                }
                catch (Exception e) {
                    if (!debug) continue;
                    JFLog.log(e);
                }
            }
        }
    }

    private class WorkerReader
    extends Thread {
        private Socket socket;
        private String id;
        private InputStream is;
        private InetAddress hostaddr;
        private String host;
        private int port;
        private boolean worker_active;
        private boolean worker_error;
        private byte[] extra = null;

        public WorkerReader(Socket socket, String id, InetAddress hostaddr, int port) {
            if (debug) {
                JFLog.log("WorkerReader:" + hostaddr.getHostAddress() + ":" + port);
            }
            this.socket = socket;
            this.id = id;
            this.hostaddr = hostaddr;
            this.port = port;
            this.host = hostaddr.getHostAddress();
        }

        @Override
        public void run() {
            this.worker_active = true;
            this.process();
            TransportTCPServer.this.remove(this.host, this.port, this.id);
        }

        private int detectLength(byte[] data, int off, int len) {
            for (int a = 0; a < len - 3; ++a) {
                if (data[off + a + 0] != 13 || data[off + a + 1] != 10 || data[off + a + 2] != 13 || data[off + a + 3] != 10) continue;
                return a + 4;
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process() {
            try {
                this.is = this.socket.getInputStream();
            }
            catch (Exception e) {
                if (debug) {
                    JFLog.log(e);
                }
                return;
            }
            if (debug) {
                JFLog.log("TransportTCPServer:Worker:active");
            }
            while (this.worker_active) {
                try {
                    int plen;
                    byte[] data = new byte[1460];
                    Packet packet = new Packet();
                    packet.data = data;
                    if (this.extra != null) {
                        System.arraycopy(this.extra, 0, packet.data, 0, this.extra.length);
                        packet.length = this.extra.length;
                        this.extra = null;
                    } else {
                        int read = this.is.read(packet.data);
                        if (read == -1) {
                            throw new Exception();
                        }
                        packet.length = read;
                    }
                    do {
                        if ((plen = this.detectLength(packet.data, 0, packet.length)) != -1) continue;
                        int read = this.is.read(packet.data, packet.length, packet.data.length - packet.length);
                        if (read == -1) {
                            throw new Exception();
                        }
                        packet.length += read;
                    } while (plen == -1);
                    int tlen = plen;
                    String[] msg = new String(packet.data, 0, plen).split("\r\n");
                    String clenstr = SIP.getHeader("Content-Length:", msg);
                    if (clenstr == null) {
                        SIP.getHeader("l:", msg);
                    }
                    if (clenstr != null) {
                        int clen = JF.atoi(clenstr);
                        tlen += clen;
                    }
                    while (packet.length < tlen) {
                        int read = this.is.read(packet.data, packet.length, packet.data.length - packet.length);
                        if (read == -1) {
                            throw new Exception();
                        }
                        packet.length += read;
                    }
                    if (packet.length > tlen) {
                        this.extra = new byte[packet.length - tlen];
                        System.arraycopy(packet.data, tlen, this.extra, 0, packet.length - tlen);
                        packet.length = tlen;
                    }
                    packet.host = this.hostaddr.getHostAddress();
                    packet.port = this.port;
                    Object object = TransportTCPServer.this.packetsLock;
                    synchronized (object) {
                        TransportTCPServer.this.packets.add(packet);
                        TransportTCPServer.this.packetsLock.notify();
                    }
                }
                catch (SocketException se) {
                    this.worker_error = true;
                    this.worker_active = false;
                    TransportTCPServer.this.remove(this.host, this.port, this.id);
                    if (!debug) continue;
                    JFLog.log("TransportTCPServer:Connection lost");
                }
                catch (Exception e) {
                    this.worker_error = true;
                    this.worker_active = false;
                    TransportTCPServer.this.remove(this.host, this.port, this.id);
                    if (!debug) continue;
                    JFLog.log(e);
                }
            }
        }
    }
}

