/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.LE;

public class Wav {
    public short[] samples;
    public String errmsg;
    private int pos;
    private int len;

    public boolean load(String fn) {
        this.errmsg = "";
        FileInputStream wav = null;
        try {
            wav = new FileInputStream(fn);
            return this.load(wav);
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public boolean load(InputStream wav) {
        this.errmsg = "";
        try {
            byte[] data = new byte[30];
            wav.read(data, 0, 20);
            if (!LE.getString(data, 0, 4).equals("RIFF")) {
                throw new Exception("Not a valid WAV file (RIFF)");
            }
            if (!LE.getString(data, 8, 4).equals("WAVE")) {
                throw new Exception("Not a valid WAV file (WAVE)");
            }
            if (!LE.getString(data, 12, 4).equals("fmt ")) {
                throw new Exception("Not a valid WAV file (fmt )");
            }
            int fmtsiz = LE.getuint32(data, 16);
            if (fmtsiz < 16 || fmtsiz > 30) {
                throw new Exception("Not a valid WAV file (fmtsiz)");
            }
            wav.read(data, 0, fmtsiz);
            if (LE.getuint16(data, 0) != 1) {
                throw new Exception("Not PCM");
            }
            if (LE.getuint16(data, 2) != 1) {
                throw new Exception("Not mono");
            }
            if (LE.getuint32(data, 4) != 8000) {
                throw new Exception("Not 8000Hz");
            }
            if (LE.getuint16(data, 12) != 2) {
                throw new Exception("Not 16bits");
            }
            wav.read(data, 0, 8);
            while (!LE.getString(data, 0, 4).equals("data")) {
                this.len = LE.getuint32(data, 4);
                byte[] junk = new byte[this.len];
                wav.read(junk);
                wav.read(data, 0, 8);
            }
            if (!LE.getString(data, 0, 4).equals("data")) {
                throw new Exception("Not a valid WAV file (data)");
            }
            this.len = LE.getuint32(data, 4);
            if (this.len < 320) {
                throw new Exception("Not a valid WAV file (len<320)");
            }
            this.len = this.len / 320 * 320;
            byte[] samples8 = JF.readAll(wav, this.len);
            this.samples = new short[this.len / 2];
            this.len >>= 1;
            for (int a = 0; a < this.len; ++a) {
                this.samples[a] = samples8[a * 2 + 1];
                int n = a;
                this.samples[n] = (short)(this.samples[n] << 8);
                int n2 = a;
                this.samples[n2] = (short)(this.samples[n2] + samples8[a * 2 + 0]);
            }
            try {
                if (wav != null) {
                    wav.close();
                }
            }
            catch (Exception exception) {}
        }
        catch (FileNotFoundException e2) {
            this.errmsg = "WAV file not found";
            try {
                if (wav != null) {
                    wav.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.samples = null;
            return false;
        }
        catch (Exception e1) {
            this.errmsg = e1.toString();
            try {
                if (wav != null) {
                    wav.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.samples = null;
            return false;
        }
        this.pos = 0;
        return true;
    }

    public boolean isLoaded() {
        return this.samples != null;
    }

    public short[] getSamples() {
        short[] buf = new short[160];
        System.arraycopy(this.samples, this.pos, buf, 0, 160);
        this.pos += 160;
        if (this.pos == this.len) {
            this.pos = 0;
        }
        return buf;
    }

    public void reset() {
        this.pos = 0;
    }
}

