/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui;

import javaforce.webui.Block;
import javaforce.webui.Component;
import javaforce.webui.Label;
import javaforce.webui.ScrollPanel;
import javaforce.webui.event.Click;
import javaforce.webui.event.MouseEvent;

public class ListBox
extends ScrollPanel
implements Click {
    public ListBox() {
        this.addClass("listbox");
        this.addClass("height100");
    }

    public void update(int idx, String text) {
        Component c = this.getCell(idx).getComponent();
        if (!(c instanceof Label)) {
            return;
        }
        Label lbl = (Label)c;
        lbl.setText(text);
    }

    public void add(String item) {
        this.add(new Label(item));
    }

    @Override
    public void add(Component item) {
        this.init(item);
        super.add(new Cell(item));
    }

    @Override
    public void add(int idx, Component item) {
        this.init(item);
        super.add(idx, new Cell(item));
    }

    private Cell getCell(int idx) {
        return (Cell)this.get(idx);
    }

    private Component getComponent(int idx) {
        return this.getCell(idx).getComponent();
    }

    private void init(Component cmp) {
        cmp.addClickListener(this);
    }

    @Override
    public void init() {
        super.init();
        int cnt = this.count();
        for (int idx = 0; idx < cnt; ++idx) {
            Component cmp = this.getComponent(idx);
            this.init(cmp);
        }
    }

    public int getSelectedIndex() {
        int cnt = this.count();
        for (int idx = 0; idx < cnt; ++idx) {
            Cell cell = this.getCell(idx);
            if (!cell.isSelected()) continue;
            return idx;
        }
        return -1;
    }

    public int getSelectedCount() {
        int selCount = 0;
        int cnt = this.count();
        for (int idx = 0; idx < cnt; ++idx) {
            Cell cell = this.getCell(idx);
            if (!cell.isSelected()) continue;
            ++selCount;
        }
        return selCount;
    }

    public int[] getSelectedIndices() {
        int selCount = this.getSelectedCount();
        int[] selIdx = new int[selCount];
        int selPos = 0;
        int cnt = this.count();
        for (int idx = 0; idx < cnt; ++idx) {
            Cell cell = this.getCell(idx);
            if (!cell.isSelected()) continue;
            selIdx[selPos++] = idx;
        }
        return selIdx;
    }

    public String getSelectedItem() {
        int idx = this.getSelectedIndex();
        if (idx == -1) {
            return null;
        }
        Component cmp = this.getComponent(idx);
        if (cmp instanceof Label) {
            Label l = (Label)cmp;
            return l.text;
        }
        return cmp.toString();
    }

    public Component getSelectedComponent() {
        int idx = this.getSelectedIndex();
        if (idx == -1) {
            return null;
        }
        return this.getComponent(idx);
    }

    public void setSelectedIndex(int selidx) {
        int cnt = this.count();
        for (int idx = 0; idx < cnt; ++idx) {
            Cell cell = this.getCell(idx);
            cell.setSelected(idx == selidx);
        }
    }

    @Override
    public void onClick(MouseEvent me, Component cmp) {
        Cell cell = (Cell)cmp.getParent();
        if (me.ctrlKey) {
            cell.setSelected(!cell.isSelected());
        } else {
            int cnt = this.count();
            for (int idx = 0; idx < cnt; ++idx) {
                Cell o;
                o.setSelected((o = this.getCell(idx)) == cell);
            }
        }
        this.onChanged(null);
    }

    private static class Cell
    extends Block {
        private boolean selected;

        public Cell(Component cmp) {
            this.add(cmp);
        }

        public Component getComponent() {
            return this.get(0);
        }

        public void setSelected(boolean state) {
            this.selected = state;
            if (state) {
                this.getComponent().sendEvent("addclass", new String[]{"cls=selected"});
            } else {
                this.getComponent().sendEvent("delclass", new String[]{"cls=selected"});
            }
        }

        public boolean isSelected() {
            return this.selected;
        }
    }
}

