/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui;

import javaforce.webui.Component;
import javaforce.webui.Container;

public class Table
extends Container {
    private int cellWidth;
    private int cellHeight;
    private int cols;
    private int rows;
    private boolean border;

    public Table(int cellWidth, int cellHeight, int cols, int rows) {
        this.cellWidth = cellWidth;
        this.cellHeight = cellHeight;
        this.cols = cols;
        this.rows = rows;
        this.setClass("table");
        this.setSize();
    }

    private void setSize() {
        this.setSize(this.cellWidth * this.cols, this.cellHeight * this.rows);
        this.sendEvent("setsize", new String[]{"w=" + this.cellWidth * this.cols, "h=" + this.cellHeight * this.rows});
    }

    @Override
    public void setBorder(boolean state) {
        this.border = state;
        if (this.border) {
            this.addClass("border");
        } else {
            this.removeClass("border");
        }
    }

    @Override
    public String html() {
        StringBuilder sb = new StringBuilder();
        sb.append("<div" + this.getAttrs() + ">");
        Component[] cells = this.getAll();
        for (int a = 0; a < cells.length; ++a) {
            Cell cell = (Cell)cells[a];
            sb.append(cell.html());
        }
        sb.append("</div>");
        return sb.toString();
    }

    public void add(Component comp, int x, int y) {
        this.add(comp, x, y, 1, 1);
    }

    public void add(Component comp, int x, int y, int spanx, int spany) {
        Cell cell = new Cell(this, comp);
        cell.x = x;
        cell.y = y;
        cell.spanx = spanx;
        cell.spany = spany;
        this.add(cell);
    }

    public void addRow() {
        ++this.rows;
        this.setSize();
    }

    public void addColumn() {
        ++this.cols;
        this.setSize();
    }

    public void setTableSize(int cols, int rows) {
        this.cols = cols;
        this.rows = rows;
        this.setSize();
    }

    @Override
    public void remove(Component c) {
        int cnt = this.count();
        for (int a = 0; a < cnt; ++a) {
            Cell cell = (Cell)this.get(a);
            if (cell.get(0) != c) continue;
            super.remove(cell);
            cell.sendEvent("remove", new String[]{"child=" + cell.id});
            return;
        }
    }

    public Component remove(int x, int y) {
        Cell cell = this.getCell(x, y, false);
        if (cell != null) {
            super.remove(cell);
            cell.sendEvent("remove", new String[]{"child=" + cell.id});
            return cell.get(0);
        }
        return null;
    }

    public void setSpans(int x, int y, int spanx, int spany) {
        Cell cell = this.getCell(x, y, false);
        if (cell == null) {
            return;
        }
        cell.spanx = spanx;
        cell.spany = spany;
        cell.sendEvent("setsize", new String[]{"w=" + spanx * this.cellWidth, "h=" + spany * this.cellHeight});
    }

    private Cell getCell(int x, int y, boolean checkSpans) {
        int cnt = this.count();
        for (int a = 0; a < cnt; ++a) {
            Cell cell = (Cell)this.get(a);
            int x1 = cell.x;
            int y1 = cell.y;
            int x2 = x1;
            int y2 = y1;
            if (checkSpans) {
                x2 += cell.spanx - 1;
                y2 += cell.spany - 1;
            }
            if (x < x1 || x > x2 || y < y1 || y > y2) continue;
            return cell;
        }
        return null;
    }

    public Component get(int x, int y, boolean checkSpans) {
        Cell cell = this.getCell(x, y, checkSpans);
        if (cell == null) {
            return null;
        }
        return cell.get(0);
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.cols;
    }

    private static class Cell
    extends Container {
        private Table table;
        public int x;
        public int y;
        public int spanx;
        public int spany;

        public Cell(Table table, Component comp) {
            this.table = table;
            this.setClass("cell");
            this.add(comp);
        }

        @Override
        public String html() {
            this.setSize(this.spanx * this.table.cellWidth, this.spany * this.table.cellHeight);
            this.setStyle("left", Integer.toString(this.x * this.table.cellWidth));
            this.setStyle("top", Integer.toString(this.y * this.table.cellHeight));
            StringBuilder sb = new StringBuilder();
            sb.append("<div" + this.getAttrs() + ">");
            sb.append(this.get(0).html());
            sb.append("</div>");
            return sb.toString();
        }
    }
}

