/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javaforce.HTTP;
import javaforce.HTTPS;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.XML;

public class JNLP {
    private static boolean debug = false;
    private static String version = "0.6";
    private static final int BUFFER_SIZE = 4096;

    public static void main(String[] args) {
        if (args == null || args.length < 1) {
            System.out.println("Desc: JavaForce JNLP Launcher/" + version);
            System.out.println("Usage: JNLP file.jnlp [--nowait]");
            System.out.println("Where: --nowait = Do not wait for JNLP app to exit");
            System.out.println("Author: Peter Quiring");
            System.out.println("WebSite: http://github.com/pquiring/javaforce");
            return;
        }
        boolean wait = true;
        block33: for (int idx = 0; idx < args.length; ++idx) {
            String arg;
            switch (arg = args[idx]) {
                case "--nowait": {
                    wait = false;
                    continue block33;
                }
                case "--debug": {
                    debug = true;
                }
            }
        }
        if (debug) {
            System.out.println("JavaForce JNLP Launcher/" + version);
        }
        try {
            int i1;
            XML xml = new XML();
            xml.read(args[0]);
            XML.XMLTag jnlp = xml.getTag(new String[]{"jnlp"});
            if (jnlp == null) {
                throw new Exception("no jnlp tag");
            }
            XML.XMLTag res = xml.getTag(new String[]{"jnlp", "resources"});
            if (res == null) {
                throw new Exception("no resources tag");
            }
            XML.XMLTag app = xml.getTag(new String[]{"jnlp", "application-desc"});
            if (app == null) {
                throw new Exception("no application-desc tag");
            }
            String codebase = jnlp.getArg("codebase");
            if (codebase == null) {
                throw new Exception("no codebase attr");
            }
            int port = -1;
            String proto = "";
            if (codebase.startsWith("http://")) {
                proto = "http";
                codebase = codebase.substring(7);
                port = 80;
            } else if (codebase.startsWith("https://")) {
                proto = "https";
                codebase = codebase.substring(8);
                port = 443;
            } else {
                throw new Exception("Unknown protocol");
            }
            String host = "";
            Object uri = "";
            int i0 = codebase.indexOf(47);
            if (i0 == -1) {
                host = codebase;
                uri = "/";
            } else {
                host = codebase.substring(0, i0);
                uri = codebase.substring(i0);
                if (!((String)uri).endsWith("/")) {
                    uri = (String)uri + "/";
                }
            }
            if (debug) {
                JFLog.log("host=" + host);
            }
            if ((i1 = host.indexOf(58)) != -1) {
                if (debug) {
                    JFLog.log("port=" + host.substring(i1 + 1));
                }
                port = Integer.valueOf(host.substring(i1 + 1));
                host = host.substring(0, i1);
            }
            ArrayList<String> res_jars = new ArrayList<String>();
            ArrayList<String> classpath_jars = new ArrayList<String>();
            ArrayList<String> nativelibs_jars = new ArrayList<String>();
            ArrayList<Object> cmd = new ArrayList<Object>();
            cmd.add(System.getProperty("java.home") + "/bin/java");
            int rescnt = res.getChildCount();
            block34: for (int i2 = 0; i2 < rescnt; ++i2) {
                XML.XMLTag child = res.getChildAt(i2);
                switch (child.name) {
                    case "nativelib": 
                    case "jar": {
                        String jar = child.getArg("href");
                        if (debug) {
                            JFLog.log("jar=" + jar);
                        }
                        res_jars.add(jar);
                        int n = jar.lastIndexOf(47);
                        if (n != -1) {
                            jar = jar.substring(n + 1);
                        }
                        if (child.name.equals("jar")) {
                            classpath_jars.add(jar);
                            continue block34;
                        }
                        nativelibs_jars.add(jar);
                        continue block34;
                    }
                    case "property": {
                        String name = child.getArg("name");
                        String value = child.getArg("value");
                        if (debug) {
                            JFLog.log("property:" + name + "=" + value);
                        }
                        cmd.add("-D" + name + "=" + value);
                        continue block34;
                    }
                    default: {
                        JFLog.log("Unknown resource:" + child.name);
                    }
                }
            }
            String main = app.getArg("main-class");
            String classpath = String.join((CharSequence)File.pathSeparator, classpath_jars);
            cmd.add("-cp");
            cmd.add(classpath);
            cmd.add(main);
            for (String jar : res_jars) {
                HTTP http = null;
                switch (proto) {
                    case "http": {
                        http = new HTTP();
                        break;
                    }
                    case "https": {
                        http = new HTTPS();
                    }
                }
                if (debug) {
                    JFLog.log("Downloading:" + host + ":" + port + (String)uri + jar);
                    HTTP.debug = true;
                    JFLog.log("http=" + http);
                }
                http.open(host, port);
                byte[] byArray = http.get((String)uri + jar);
                if (byArray == null || byArray.length == 0) {
                    JFLog.log("Download Error:" + (String)uri + jar);
                }
                http.close();
                int i4 = jar.lastIndexOf(47);
                if (i4 != -1) {
                    jar = jar.substring(i4 + 1);
                }
                FileOutputStream fos = new FileOutputStream(jar);
                fos.write(byArray);
                fos.close();
            }
            for (String jar : nativelibs_jars) {
                JNLP.unzip(jar, ".");
            }
            int argcnt = app.getChildCount();
            for (int i2 = 0; i2 < argcnt; ++i2) {
                XML.XMLTag child = app.getChildAt(i2);
                switch (child.name) {
                    case "argument": {
                        String arg = child.content;
                        cmd.add(arg);
                    }
                }
            }
            if (debug) {
                JFLog.log("executing jnlp:");
                FileOutputStream fos = new FileOutputStream("execute" + JF.getScriptExt());
                for (String string : cmd) {
                    fos.write(string.getBytes());
                    fos.write(" ".getBytes());
                    JFLog.log(string);
                }
                fos.close();
            }
            Process p = Runtime.getRuntime().exec(cmd.toArray(new String[cmd.size()]));
            if (wait) {
                p.waitFor();
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public static void unzip(String zipFilePath, String destDirectory) throws IOException {
        File destDir = new File(destDirectory);
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));
        ZipEntry entry = zipIn.getNextEntry();
        while (entry != null) {
            if (debug) {
                JFLog.log("entry=" + entry.getName());
            }
            String filePath = destDirectory + "/" + entry.getName().replaceAll("\\\\", "/");
            if (!entry.isDirectory()) {
                JNLP.extractFile(zipIn, filePath);
            } else {
                if (debug) {
                    JFLog.log("mkdir:" + filePath);
                }
                File dir = new File(filePath);
                dir.mkdirs();
            }
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
        }
        zipIn.close();
    }

    private static void extractFile(ZipInputStream zipIn, String path_file) throws IOException {
        if (debug) {
            JFLog.log("extractFile:" + path_file);
        }
        int idx = path_file.lastIndexOf(47);
        String path = path_file.substring(0, idx);
        if (debug) {
            JFLog.log("mkdirs:" + path);
        }
        File dir = new File(path);
        dir.mkdirs();
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(path_file));
        byte[] bytesIn = new byte[4096];
        int read = 0;
        while ((read = zipIn.read(bytesIn)) != -1) {
            bos.write(bytesIn, 0, read);
        }
        bos.close();
    }
}

