/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import javaforce.JFLog;
import javaforce.voip.Packet;
import javaforce.voip.PacketReceiver;
import javaforce.voip.RTPChannel;
import javaforce.voip.RTPCodec;

public class RTPVP8
extends RTPCodec {
    private static final int mtu = 1445;
    private int seqnum;
    private int timestamp;
    private final int ssrc = this.random.nextInt();
    private int lastseqnum = -1;
    private Packet packet = new Packet();
    private static int maxSize = 0x400000;
    private static final int M = 128;

    public RTPVP8() {
        this.packet.data = new byte[maxSize];
    }

    @Override
    public void encode(byte[] data, int x, int y, int id, PacketReceiver pr) {
        int packetLength;
        int offset = 0;
        boolean first = true;
        for (int len = data.length; len > 0; len -= packetLength) {
            packetLength = len > 1445 ? 1445 : len;
            this.packet.length = packetLength + 1 + 12;
            RTPChannel.buildHeader(this.packet.data, id, this.seqnum++, this.timestamp, this.ssrc, len == packetLength);
            if (first) {
                this.packet.data[12] = 16;
                first = false;
            }
            System.arraycopy(data, offset, this.packet, 13, packetLength);
            pr.onPacket(this.packet);
            offset += packetLength;
        }
        this.packet.length = 0;
        this.timestamp += 100;
    }

    @Override
    public void decode(byte[] rtp, int offset, int length, PacketReceiver pr) {
        boolean s;
        if (rtp.length < 14) {
            return;
        }
        int vp8Length = rtp.length - 12;
        int payloadOffset = 12;
        byte bits = rtp[12];
        boolean x = (bits & 0x80) == 128;
        boolean n = (bits & 0x20) == 32;
        boolean bl = s = (bits & 0x10) == 16;
        if (s) {
            this.packet.length = 0;
        } else {
            ++payloadOffset;
            --vp8Length;
            if (x) {
                byte iltk = rtp[13];
                ++payloadOffset;
                --vp8Length;
                if ((iltk & 0x80) == 128) {
                    byte pid = rtp[14];
                    if ((pid & 0x80) == 128) {
                        ++payloadOffset;
                        --vp8Length;
                    }
                    ++payloadOffset;
                    --vp8Length;
                }
                if ((iltk & 0x40) == 64) {
                    ++payloadOffset;
                    --vp8Length;
                }
                if ((iltk & 0x30) != 0) {
                    ++payloadOffset;
                    --vp8Length;
                }
            }
        }
        if (n) {
            return;
        }
        System.arraycopy(rtp, payloadOffset, this.packet.data, this.packet.length, vp8Length);
        int thisseqnum = RTPChannel.getseqnum(rtp, 0);
        if (this.lastseqnum != -1 && thisseqnum != this.lastseqnum + 1) {
            JFLog.log("VP8:Received packet out of order, discarding frame.");
            this.lastseqnum = -1;
            this.packet.length = 0;
            return;
        }
        this.lastseqnum = thisseqnum;
        if ((rtp[1] & 0x80) == 128) {
            pr.onPacket(this.packet);
            this.lastseqnum = -1;
            this.packet.length = 0;
        }
    }
}

