/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import java.util.ArrayList;
import java.util.Arrays;
import javaforce.Base64;
import javaforce.HTTP;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.voip.Codec;
import javaforce.voip.RTP;
import javaforce.voip.SIP;

public class SDP
implements Cloneable {
    public int log;
    public String ip;
    public String iceufrag;
    public String icepwd;
    public String fingerprint;
    public Stream[] streams = new Stream[0];
    public String owner;
    public String session;
    public long o1 = 256L;
    public long o2 = 256L;
    public long time_start;
    public long time_stop;
    public float framerate;
    public ArrayList<String> otherAttributes = new ArrayList();
    public ArrayList<String> otherParameters = new ArrayList();

    public void setLog(int id) {
        this.log = id;
    }

    public Stream addStream(Type type) {
        JFLog.log(this.log, "SDP.addStream:" + type);
        Stream stream = new Stream();
        stream.sdp = this;
        stream.type = type;
        this.streams = Arrays.copyOf(this.streams, this.streams.length + 1);
        this.streams[this.streams.length - 1] = stream;
        return stream;
    }

    public void delStream(Stream stream) {
        for (int a = 0; a < this.streams.length; ++a) {
            if (this.streams[a] != stream) continue;
            this.streams = JF.copyOfExcluding(this.streams, a);
            return;
        }
    }

    public void delAudio() {
        int a = 0;
        while (a < this.streams.length) {
            if (this.streams[a].type == Type.audio) {
                this.streams = JF.copyOfExcluding(this.streams, a);
                continue;
            }
            ++a;
        }
    }

    public void delVideo() {
        int a = 0;
        while (a < this.streams.length) {
            if (this.streams[a].type == Type.video) {
                this.streams = JF.copyOfExcluding(this.streams, a);
                continue;
            }
            ++a;
        }
    }

    public Stream getFirstAudioStream() {
        for (int a = 0; a < this.streams.length; ++a) {
            if (this.streams[a].type != Type.audio) continue;
            return this.streams[a];
        }
        return null;
    }

    public Stream getFirstVideoStream() {
        for (int a = 0; a < this.streams.length; ++a) {
            if (this.streams[a].type != Type.video) continue;
            return this.streams[a];
        }
        return null;
    }

    public boolean hasAudio() {
        return this.getFirstAudioStream() != null;
    }

    public boolean hasVideo() {
        return this.getFirstVideoStream() != null;
    }

    public float getFrameRate() {
        return this.framerate;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SDP:" + this.streams.length + "[");
        for (int a = 0; a < this.streams.length; ++a) {
            if (a > 0) {
                sb.append(",");
            }
            sb.append("Stream=" + this.streams[a]);
        }
        sb.append("]");
        sb.append("FPS=" + this.framerate);
        return sb.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String[] build(String localhost) {
        ArrayList<Object> content = new ArrayList<Object>();
        content.add("v=0");
        content.add("o=- " + this.o1 + " " + this.o2 + " IN IP4 " + localhost);
        content.add("s=" + SIP.useragent);
        content.add("c=IN IP4 " + this.ip);
        content.add("t=" + this.time_start + " " + this.time_stop);
        if (this.iceufrag != null) {
            content.add("a=ice-ufrag:" + this.iceufrag);
        }
        if (this.icepwd != null) {
            content.add("a=ice-pwd:" + this.icepwd);
        }
        if (this.fingerprint != null) {
            content.add("a=fingerprint:sha-256 " + this.fingerprint);
        }
        for (int a = 0; a < this.streams.length; ++a) {
            Stream stream = this.streams[a];
            if (stream.codecs.length == 0) continue;
            Codec rfc2833 = stream.getCodec(RTP.CODEC_RFC2833);
            StringBuilder m = new StringBuilder();
            m.append("m=" + stream.getType() + " " + stream.port + " ");
            if (stream.keyExchange == KeyExchange.DTLS) {
                m.append("UDP/TLS/");
            }
            m.append("RTP/" + stream.profile);
            for (int b = 0; b < stream.codecs.length; ++b) {
                m.append(" " + stream.codecs[b].id);
            }
            if (stream.type == Type.audio && rfc2833 == null) {
                rfc2833 = RTP.CODEC_RFC2833;
                m.append(" " + rfc2833.id);
            }
            content.add(m.toString());
            if (stream.keyExchange == KeyExchange.SDP && stream.keys != null) {
                for (int c = 0; c < stream.keys.length; ++c) {
                    Key keys = stream.keys[c];
                    byte[] key_salt = new byte[30];
                    System.arraycopy(keys.key, 0, key_salt, 0, 16);
                    System.arraycopy(keys.salt, 0, key_salt, 16, 14);
                    String keystr = new String(Base64.encode(key_salt));
                    String ln = keys.crypto + " inline:" + keystr + "|2^48|1:32";
                    content.add("a=crypto:" + (c + 1) + " " + ln);
                }
            }
            if (stream.content != null) {
                content.add("a=content:" + stream.content);
            }
            content.add("a=" + stream.getMode());
            if (stream.ip != null) {
                content.add("c=IN IP4 " + stream.ip);
            }
            content.add("a=ptime:20");
            if (stream.hasCodec(RTP.CODEC_G711u)) {
                content.add("a=rtpmap:0 PCMU/8000");
            }
            if (stream.hasCodec(RTP.CODEC_G711a)) {
                content.add("a=rtpmap:8 PCMA/8000");
            }
            if (stream.hasCodec(RTP.CODEC_GSM)) {
                content.add("a=rtpmap:3 GSM/8000");
            }
            if (stream.hasCodec(RTP.CODEC_G722)) {
                content.add("a=rtpmap:9 G722/8000");
            }
            if (stream.hasCodec(RTP.CODEC_G729a)) {
                content.add("a=rtpmap:18 G729/8000");
                content.add("a=fmtp:18 annexb=no");
                content.add("a=silenceSupp:off - - - -");
            }
            if (stream.type == Type.audio) {
                content.add("a=rtpmap:" + rfc2833.id + " telephone-event/8000");
                content.add("a=fmtp:" + rfc2833.id + " 0-15");
            }
            if (stream.hasCodec(RTP.CODEC_JPEG)) {
                content.add("a=rtpmap:26 JPEG/90000");
            }
            if (stream.hasCodec(RTP.CODEC_H263)) {
                content.add("a=rtpmap:34 H263/90000");
            }
            if (stream.hasCodec(RTP.CODEC_H263_1998)) {
                content.add("a=rtpmap:" + stream.getCodec((Codec)RTP.CODEC_H263_1998).id + " H263-1998/90000");
            }
            if (stream.hasCodec(RTP.CODEC_H263_2000)) {
                content.add("a=rtpmap:" + stream.getCodec((Codec)RTP.CODEC_H263_2000).id + " H263-2000/90000");
            }
            if (stream.hasCodec(RTP.CODEC_H264)) {
                content.add("a=rtpmap:" + stream.getCodec((Codec)RTP.CODEC_H264).id + " H264/90000");
            }
            if (stream.hasCodec(RTP.CODEC_H265)) {
                content.add("a=rtpmap:" + stream.getCodec((Codec)RTP.CODEC_H265).id + " H265/90000");
            }
            if (stream.hasCodec(RTP.CODEC_VP8)) {
                content.add("a=rtpmap:" + stream.getCodec((Codec)RTP.CODEC_VP8).id + " VP8/90000");
            }
            if (stream.hasCodec(RTP.CODEC_VP9)) {
                content.add("a=rtpmap:" + stream.getCodec((Codec)RTP.CODEC_VP9).id + " VP9/90000");
            }
            JFLog.log("keyexchange=" + stream.keyExchange);
            if (stream.keyExchange != KeyExchange.DTLS) continue;
            content.add("a=rtcp-mux");
        }
        if (this.framerate != 0.0f) {
            content.add("a=framerate:" + this.framerate);
        }
        return content.toArray(JF.StringArrayType);
    }

    public static SDP getSDP(String[] msg) {
        return SDP.getSDP(msg, 0);
    }

    public static SDP getSDP(String[] msg, int log) {
        String type = HTTP.getParameter(msg, "Content-Type");
        if (type == null) {
            type = HTTP.getParameter(msg, "c");
        }
        if (type == null || type.indexOf("application/sdp") == -1) {
            return null;
        }
        SDP sdp = new SDP();
        sdp.setLog(log);
        Stream stream = null;
        int start = -1;
        for (int a = 0; a < msg.length; ++a) {
            if (msg[a].length() != 0) continue;
            start = a + 1;
            break;
        }
        if (start == -1) {
            JFLog.log(log, "SIP.getSDP() : No SDP found");
            return null;
        }
        int acnt = 1;
        int vcnt = 1;
        for (int a = start; a < msg.length; ++a) {
            String[] f;
            String ln = msg[a];
            if (ln.startsWith("c=")) {
                int idx = ln.indexOf("IP4 ");
                if (idx == -1) {
                    JFLog.log(log, "SIP.getSDP() : Unsupported c field:" + ln);
                    continue;
                }
                String ip = ln.substring(idx + 4);
                if (stream == null) {
                    sdp.ip = ip;
                    continue;
                }
                stream.ip = ip;
                continue;
            }
            if (ln.startsWith("m=")) {
                if (stream != null && stream.content == null) {
                    switch (stream.type) {
                        case audio: {
                            stream.content = "audio" + acnt++;
                            break;
                        }
                        case video: {
                            stream.content = "video" + vcnt++;
                        }
                    }
                }
                if (ln.startsWith("m=audio")) {
                    stream = sdp.addStream(Type.audio);
                } else if (ln.startsWith("m=video")) {
                    stream = sdp.addStream(Type.video);
                } else {
                    JFLog.log("SIP.getSDP() : Unsupported m field:" + ln);
                    stream = sdp.addStream(Type.other);
                    continue;
                }
                f = ln.split(" ");
                String[] p = f[2].split("/");
                int i = 1;
                if (p[i].equals("TLS")) {
                    stream.keyExchange = KeyExchange.DTLS;
                    i = 3;
                }
                if (p[i].equals("AVP")) {
                    stream.profile = Profile.AVP;
                } else if (p[i].equals("AVPF")) {
                    stream.profile = Profile.AVPF;
                } else if (p[i].equals("SAVP")) {
                    stream.profile = Profile.SAVP;
                } else if (p[i].equals("SAVPF")) {
                    stream.profile = Profile.SAVPF;
                } else {
                    stream.profile = Profile.UNKNOWN;
                    JFLog.log(log, "SIP.getSDP() : Unsupported profile:" + p[i]);
                }
                stream.port = JF.atoi(f[1]);
                for (int b = 3; b < f.length; ++b) {
                    int id = JF.atoi(f[b]);
                    if (id >= 96) continue;
                    stream.addCodec(new Codec(SIP.getCodecName(id), id));
                }
                continue;
            }
            if (ln.startsWith("a=")) {
                if (ln.startsWith("a=rtpmap:")) {
                    f = ln.substring(9).split(" ");
                    int id = JF.atoi(f[0]);
                    String[] n = f[1].split("/");
                    if (id < 96) continue;
                    stream.addCodec(new Codec(n[0], id));
                    continue;
                }
                if (ln.startsWith("a=sendrecv")) {
                    if (stream == null) continue;
                    stream.mode = Mode.sendrecv;
                    continue;
                }
                if (ln.startsWith("a=sendonly")) {
                    if (stream == null) continue;
                    stream.mode = Mode.sendonly;
                    continue;
                }
                if (ln.startsWith("a=recvonly")) {
                    if (stream == null) continue;
                    stream.mode = Mode.sendonly;
                    continue;
                }
                if (ln.startsWith("a=inactive")) {
                    if (stream == null) continue;
                    stream.mode = Mode.inactive;
                    continue;
                }
                if (ln.startsWith("a=content:")) {
                    stream.content = ln.substring(10);
                    continue;
                }
                if (ln.startsWith("a=candidate:")) {
                    f = ln.substring(12).split(" ");
                    if (stream == null || f.length < 8 || !f[0].equals("0") || !f[1].equals("1")) continue;
                    stream.ip = f[4];
                    continue;
                }
                if (ln.startsWith("a=ice-ufrag:")) {
                    sdp.iceufrag = ln.substring(12);
                    continue;
                }
                if (ln.startsWith("a=ice-pwd:")) {
                    sdp.icepwd = ln.substring(10);
                    continue;
                }
                if (ln.startsWith("a=fingerprint:sha-256 ")) {
                    sdp.fingerprint = ln.substring(22);
                    continue;
                }
                if (ln.startsWith("a=crypto:")) {
                    byte[] keys;
                    stream.keyExchange = KeyExchange.SDP;
                    f = ln.split(" ");
                    if (!f[2].startsWith("inline:")) {
                        JFLog.log("a=crypto:bad keys(1)");
                        continue;
                    }
                    String base64 = f[2].substring(7);
                    int pipe = base64.indexOf("|");
                    if (pipe != -1) {
                        base64 = base64.substring(0, pipe);
                    }
                    if ((keys = Base64.decode(base64.getBytes())) == null || keys.length != 30) {
                        JFLog.log("a=crypto:bad keys(2)");
                        continue;
                    }
                    byte[] key = Arrays.copyOfRange(keys, 0, 16);
                    byte[] salt = Arrays.copyOfRange(keys, 16, 30);
                    stream.addKey(f[1], key, salt);
                    continue;
                }
                if (ln.startsWith("a=framerate:")) {
                    sdp.framerate = JF.atof(ln.substring(12));
                    continue;
                }
                sdp.otherAttributes.add(ln.substring(2));
                continue;
            }
            if (ln.startsWith("o=")) {
                int spc = ln.indexOf(32);
                String[] os = ln.substring(spc + 1).split(" ");
                try {
                    sdp.o1 = Long.valueOf(os[0]);
                }
                catch (Exception e) {
                    sdp.o1 = 256L;
                }
                try {
                    sdp.o2 = Long.valueOf(os[1]);
                }
                catch (Exception e) {
                    sdp.o2 = 256L;
                }
                sdp.owner = ln.substring(2);
                continue;
            }
            if (ln.startsWith("s=")) {
                sdp.session = ln.substring(2);
                continue;
            }
            if (ln.startsWith("t=")) {
                f = ln.substring(2).split("[ ]");
                if (f.length < 2) continue;
                sdp.time_start = Long.valueOf(f[0]);
                sdp.time_stop = Long.valueOf(f[1]);
                continue;
            }
            sdp.otherParameters.add(ln);
        }
        if (stream != null && stream.content == null) {
            switch (stream.type) {
                case audio: {
                    stream.content = "audio" + acnt++;
                    break;
                }
                case video: {
                    stream.content = "video" + vcnt++;
                }
            }
        }
        return sdp;
    }

    public class Stream {
        public Type type;
        public Mode mode = Mode.sendrecv;
        public String ip;
        public Codec[] codecs = new Codec[0];
        public int port = -1;
        public String content;
        public SDP sdp;
        public Profile profile = Profile.AVP;
        public KeyExchange keyExchange = KeyExchange.NONE;
        public Key[] keys;

        public String getType() {
            switch (this.type) {
                case audio: {
                    return "audio";
                }
                case video: {
                    return "video";
                }
            }
            return "?";
        }

        public String getMode() {
            switch (this.mode) {
                case sendonly: {
                    return "sendonly";
                }
                case recvonly: {
                    return "recvonly";
                }
                case sendrecv: {
                    return "sendrecv";
                }
                case inactive: {
                    return "inactive";
                }
            }
            return "?";
        }

        public boolean hasCodec(Codec codec) {
            return SIP.hasCodec(this.codecs, codec);
        }

        public Codec addCodec(Codec codec) {
            this.codecs = SIP.addCodec(this.codecs, codec);
            return codec;
        }

        public void delCodec(Codec codec) {
            this.codecs = SIP.delCodec(this.codecs, codec);
        }

        public void setCodec(Codec codec) {
            this.codecs = new Codec[1];
            this.codecs[0] = codec;
        }

        public Codec getCodec(Codec codec) {
            return SIP.getCodec(this.codecs, codec);
        }

        public String getIP() {
            if (this.ip != null) {
                return this.ip;
            }
            return SDP.this.ip;
        }

        public void setIP(String ip) {
            this.ip = ip;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public boolean canSend() {
            return this.mode == Mode.sendrecv || this.mode == Mode.sendonly;
        }

        public boolean canRecv() {
            return this.mode == Mode.sendrecv || this.mode == Mode.recvonly;
        }

        public boolean isSecure() {
            return this.profile == Profile.SAVP || this.profile == Profile.SAVPF;
        }

        public void addKey(String crypto, byte[] key, byte[] salt) {
            Key newkey = new Key();
            newkey.crypto = crypto;
            newkey.key = key;
            newkey.salt = salt;
            if (this.keys == null) {
                this.keys = new Key[0];
            }
            Key[] newKeys = new Key[this.keys.length + 1];
            newKeys[this.keys.length] = newkey;
            this.keys = newKeys;
        }

        public Key getKey(String crypto) {
            if (this.keys == null) {
                return null;
            }
            for (int a = 0; a < this.keys.length; ++a) {
                if (!this.keys[a].crypto.equals(crypto)) continue;
                return this.keys[a];
            }
            return null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Stream:{");
            sb.append("ip=" + this.getIP());
            sb.append(",port=" + this.getPort());
            sb.append(",type=" + this.type);
            sb.append(",mode=" + this.mode);
            sb.append(",codecs={");
            for (Codec codec : this.codecs) {
                sb.append(codec);
            }
            sb.append("}");
            sb.append("}");
            return sb.toString();
        }
    }

    public static enum Type {
        audio,
        video,
        other;

    }

    public static enum KeyExchange {
        NONE,
        SDP,
        DTLS;

    }

    public static enum Profile {
        AVP,
        SAVP,
        AVPF,
        SAVPF,
        UNKNOWN;

    }

    public class Key {
        public String crypto;
        public byte[] key;
        public byte[] salt;
    }

    public static enum Mode {
        sendonly,
        recvonly,
        sendrecv,
        inactive;

    }
}

