/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import javaforce.JF;
import javaforce.JFLog;

public class KeyMgmt {
    private KeyStore keyStore = null;
    private char[] password = null;

    public static boolean keytool(String[] args) {
        ArrayList<Object> cmd = new ArrayList<Object>();
        try {
            if (JF.isWindows()) {
                cmd.add(System.getProperty("java.home") + "\\bin\\keytool.exe");
            } else {
                cmd.add(System.getProperty("java.home") + "/bin/keytool");
            }
            for (int a = 0; a < args.length; ++a) {
                cmd.add(args[a]);
            }
            String[] sa = cmd.toArray(new String[cmd.size()]);
            Process p = Runtime.getRuntime().exec(sa);
            InputStream is = p.getInputStream();
            p.waitFor();
            String output = new String(is.readAllBytes());
            JFLog.log("KeyMgmt.keyTool()=" + output);
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public boolean open(InputStream is, char[] pwd) {
        this.password = pwd;
        try {
            this.keyStore = KeyStore.getInstance("JKS", "SUN");
            this.keyStore.load(is, pwd);
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public boolean save(OutputStream os, char[] pwd) {
        this.password = pwd;
        try {
            this.keyStore.store(os, pwd);
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public boolean loadKEYandCRT(String alias, InputStream keyStream, InputStream certStream, char[] pwd) {
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            byte[] key = JF.readAll(keyStream);
            PKCS8EncodedKeySpec keysp = new PKCS8EncodedKeySpec(key);
            PrivateKey ff = kf.generatePrivate(keysp);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> c = cf.generateCertificates(certStream);
            Certificate[] certs = (Certificate[])c.toArray();
            this.keyStore.setKeyEntry(alias, ff, pwd, certs);
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public boolean loadCRT(String alias, InputStream certStream) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate crt = cf.generateCertificate(certStream);
            this.keyStore.setCertificateEntry(alias, crt);
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public boolean hasCRT(InputStream certStream) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate crt = cf.generateCertificate(certStream);
            return this.keyStore.getCertificateAlias(crt) != null;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public Certificate getCRT(String alias) {
        try {
            return this.keyStore.getCertificate(alias);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Key getKEY(String alias, char[] password) {
        try {
            return this.keyStore.getKey(alias, password);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String fingerprintSHA256(byte[] key) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] res = md.digest(key);
            StringBuilder sb = new StringBuilder();
            for (int a = 0; a < res.length; ++a) {
                int b = res[a] & 0xFF;
                if (a > 0) {
                    sb.append(":");
                }
                if (b < 16) {
                    sb.append("0");
                }
                sb.append(Integer.toString(b, 16).toUpperCase());
            }
            return sb.toString();
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public char[] getPassword() {
        return this.password;
    }
}

