/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.util.Hashtable;
import javaforce.JFLog;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class LDAP {
    private DirContext ctx;
    public Exception lastException;

    public boolean login(String server, String domain, String username, String password) {
        try {
            if (username.length() == 0) {
                throw new Exception("invalid username");
            }
            if (password.length() == 0) {
                throw new Exception("invalid password");
            }
            Hashtable<String, Object> env = new Hashtable<String, Object>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", "ldap://" + server + ":389");
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", domain + "\\" + username);
            env.put("java.naming.security.credentials", password);
            this.ctx = new InitialDirContext(env);
            return true;
        }
        catch (Exception e) {
            this.lastException = e;
            JFLog.log(e);
            return false;
        }
    }

    public void close() {
        if (this.ctx != null) {
            try {
                this.ctx.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ctx = null;
        }
    }

    public String[] getAttributes(String domain, String key, String[] attrs) {
        if (this.ctx == null) {
            return null;
        }
        String[] values = new String[attrs.length];
        try {
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(2);
            constraints.setReturningAttributes(attrs);
            NamingEnumeration<SearchResult> answer = this.ctx.search(domain, key, constraints);
            if (!answer.hasMore()) {
                throw new Exception("no results");
            }
            Attributes results = answer.next().getAttributes();
            for (int a = 0; a < attrs.length; ++a) {
                Object value = results.get(attrs[a]);
                if (value == null) {
                    value = "null";
                }
                values[a] = value.toString();
            }
            return values;
        }
        catch (Exception e) {
            this.lastException = e;
            JFLog.log(e);
            return null;
        }
    }

    public static String build_dn(String domain) {
        StringBuilder dn = new StringBuilder();
        String[] p = domain.split("[.]");
        for (int a = 0; a < p.length; ++a) {
            if (a > 0) {
                dn.append(",");
            }
            dn.append("dc=");
            dn.append(p[a]);
        }
        return dn.toString();
    }

    public Exception getLastException() {
        return this.lastException;
    }
}

