/*
 * Decompiled with CFR 0.152.
 */
package javaforce.controls.s7;

public class COTP {
    public byte length;
    public byte PDU_type;
    public byte[] pdata;
    private short src_ref;
    private static short next_id = (short)3840;
    public static final byte type_data = -16;
    public static final byte type_connect = -32;
    public static final byte type_connect_ack = -48;

    public COTP() {
        this.src_ref = this.get_next_id();
    }

    public COTP(byte type) {
        this.PDU_type = type;
        this.src_ref = this.get_next_id();
        switch (type) {
            case -16: {
                this.length = (byte)2;
                break;
            }
            case -32: {
                this.length = (byte)17;
                break;
            }
            default: {
                System.out.println("Error:Unknown COTP type!!!");
            }
        }
    }

    private synchronized short get_next_id() {
        short s = next_id;
        next_id = (short)(s + 1);
        return s;
    }

    public int size() {
        return this.length + 1;
    }

    public void write(byte[] data, int offset) {
        data[offset++] = this.length;
        data[offset++] = this.PDU_type;
        switch (this.PDU_type) {
            case -16: {
                data[offset++] = -128;
                break;
            }
            case -32: {
                data[offset++] = 0;
                data[offset++] = 0;
                data[offset++] = (byte)(this.src_ref >>> 8);
                data[offset++] = (byte)(this.src_ref & 0xFF);
                data[offset++] = 0;
                data[offset++] = -64;
                data[offset++] = 1;
                data[offset++] = 10;
                data[offset++] = -63;
                data[offset++] = 2;
                data[offset++] = 1;
                data[offset++] = 0;
                data[offset++] = -62;
                data[offset++] = 2;
                data[offset++] = 1;
                data[offset++] = 2;
            }
        }
    }

    public void read(byte[] data, int offset) throws Exception {
        this.length = data[offset++];
        this.PDU_type = data[offset++];
        this.pdata = new byte[this.length - 1];
        for (int a = 0; a < this.length - 1; ++a) {
            this.pdata[a] = data[offset++];
        }
    }
}

