/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.utils.BuildTools;

public class GenPkgInfo {
    private BuildTools tools;
    private String app;
    private String desc;
    private String arch;
    private String ver;
    private long size;

    private void error(String msg) {
        System.out.print(msg);
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args == null || args.length < 3) {
            System.out.println("GenPkgInfo : build linux package info files");
            System.out.println("  Usage : GenPkgInfo distro archtype files.list");
            System.out.println("    distro = debian fedora arch");
            System.exit(1);
        }
        try {
            new GenPkgInfo().run(args);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void run(String[] args) throws Exception {
        this.tools = new BuildTools();
        if (!this.tools.loadXML("build.xml")) {
            throw new Exception("error loading build.xml");
        }
        String distro = args[0];
        this.arch = GenPkgInfo.getArch();
        this.size = this.calcSize(args[2]);
        this.app = this.tools.getProperty("app");
        this.desc = this.tools.getTag("description");
        this.ver = this.tools.getProperty("version");
        switch (distro) {
            case "debian": {
                this.debian();
                break;
            }
            case "fedora": {
                this.fedora();
                break;
            }
            case "arch": {
                this.arch();
                break;
            }
            default: {
                this.error("Unknown distro:" + distro);
            }
        }
    }

    public static String convertArch(String arch) {
        switch (arch) {
            case "x86_64": {
                return "amd64";
            }
            case "aarch64": {
                return "arm64";
            }
        }
        return arch;
    }

    public static String getArch() {
        String arch = System.getenv("HOSTTYPE");
        if (arch == null && (arch = System.getProperty("os.arch")) == null) {
            JFLog.log("Error:Unable to detect CPU from env:HOSTTYPE or property:os.arch");
        }
        switch (arch) {
            case "amd64": {
                return "x86_64";
            }
            case "arm64": {
                return "aarch64";
            }
        }
        return arch;
    }

    private long calcSize(String files_list) {
        try {
            String[] files = new String(JF.readAll(new FileInputStream(files_list))).replaceAll("\r", "").split("\n");
            long size = 0L;
            for (int a = 0; a < files.length; ++a) {
                size += new File(files[a]).length();
            }
            return size;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
            return -1L;
        }
    }

    private String[] getDepends(String tagName) {
        ArrayList<String> depends = new ArrayList<String>();
        String[] list = this.tools.getProperty(tagName).split(",");
        if (!this.app.equals("javaforce")) {
            depends.add("javaforce");
        }
        for (int a = 0; a < list.length; ++a) {
            String depend = list[a].trim();
            if (depend.length() == 0 || depend.equals("null")) continue;
            depends.add(depend);
        }
        return depends.toArray(JF.StringArrayType);
    }

    private void debian() {
        this.arch = GenPkgInfo.convertArch(this.arch);
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("Package: " + this.app + "\n");
            sb.append("Version: " + this.ver + "\n");
            sb.append("Architecture: ");
            sb.append(this.arch);
            sb.append("\n");
            sb.append("Description: " + this.desc + "\n");
            sb.append("Maintainer: Peter Quiring <pquiring@gmail.com>\n");
            sb.append("Installed-Size: " + Long.toString(this.size / 1024L) + "\n");
            sb.append("Depends: ");
            String[] depends = this.getDepends("debian.depends");
            for (int a = 0; a < depends.length; ++a) {
                if (a > 0) {
                    sb.append(",");
                }
                sb.append(depends[a]);
            }
            sb.append("\n");
            new File("deb").mkdir();
            FileOutputStream fos = new FileOutputStream("deb/control");
            fos.write(sb.toString().getBytes());
            fos.close();
            if (!new File("deb/preinst").exists()) {
                fos = new FileOutputStream("deb/preinst");
                fos.write("#!/bin/sh\n".getBytes());
                if (new File("folders.lst").exists()) {
                    FileInputStream fis = new FileInputStream("folders.lst");
                    String[] lns = new String(fis.readAllBytes()).replaceAll("\\r", "").split("\n");
                    fis.close();
                    for (String ln : lns) {
                        if ((ln = ln.trim()).length() == 0) continue;
                        fos.write(("mkdir -p " + ln + "\n").getBytes());
                    }
                }
                fos.close();
            }
            if (!new File("deb/postinst").exists()) {
                fos = new FileOutputStream("deb/postinst");
                fos.write("#!/bin/sh\n".getBytes());
                fos.close();
            }
            if (!new File("deb/prerm").exists()) {
                fos = new FileOutputStream("deb/postinst");
                fos.write("#!/bin/sh\n".getBytes());
                fos.close();
            }
            if (!new File("deb/postrm").exists()) {
                fos = new FileOutputStream("deb/postrm");
                fos.write("#!/bin/sh\n".getBytes());
                fos.close();
            }
            System.out.println("Debian package info created");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void fedora() {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("Buildroot: /.\n");
            sb.append("Name: " + this.app + "\n");
            sb.append("Version: " + this.ver + "\n");
            sb.append("Release: 1\n");
            sb.append("License: LGPL\n");
            sb.append("Summary: " + this.desc + "\n");
            sb.append("Requires: ");
            String[] depends = this.getDepends("fedora.depends");
            for (int a = 0; a < depends.length; ++a) {
                if (a > 0) {
                    sb.append(",");
                }
                sb.append(depends[a]);
            }
            sb.append("\n");
            sb.append("%description\n " + this.desc + "\n");
            sb.append("%post\n");
            sb.append("#!/bin/sh\n");
            sb.append("set -e\n");
            sb.append("%pre\n");
            sb.append("#!/bin/sh\n");
            sb.append("set -e\n");
            sb.append("%files\n");
            FileOutputStream fos = new FileOutputStream("rpm.spec");
            fos.write(sb.toString().getBytes());
            fos.close();
            System.out.println("Fedora package info created");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void arch() {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("pkgname = " + this.app + "\n");
            sb.append("pkgver = " + this.ver + "-1\n");
            sb.append("pkgdesc = " + this.desc + "\n");
            sb.append("builddate = " + Long.toString(Calendar.getInstance().getTimeInMillis() / 1000L) + "\n");
            sb.append("packager = Peter Quiring <pquiring@gmail.com>\n");
            sb.append("size = " + this.size + "\n");
            sb.append("license = LGPL\n");
            sb.append("arch = ");
            sb.append(this.arch);
            sb.append("\n");
            String[] depends = this.getDepends("arch.depends");
            for (int a = 0; a < depends.length; ++a) {
                sb.append("depend = ");
                sb.append(depends[a]);
                sb.append("\n");
            }
            FileOutputStream fos = new FileOutputStream(".PKGINFO");
            fos.write(sb.toString().getBytes());
            fos.close();
            System.out.println("Arch package info created");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

