/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import javaforce.JFLog;
import javaforce.voip.Packet;
import javaforce.voip.RTPH264;
import javaforce.voip.RTPH265;

public class PacketBuffer {
    private static final int maxPacketsSize = 0x1000000;
    private static final int maxPackets = 256;
    public byte[] data;
    private Packet nextFrame = new Packet();
    private int codecType;
    public int[] offset = new int[256];
    public int[] length = new int[256];
    public byte[] type = new byte[256];
    public int nextOffset;
    public int head;
    public int tail;
    public int log;
    public int next_frame_packets;

    public PacketBuffer(int codecType) {
        this.codecType = codecType;
        this.data = new byte[0x1000000];
        this.nextFrame.data = new byte[0x1000000];
    }

    public void setLog(int id) {
        this.log = id;
    }

    public void reset() {
        this.head = 0;
        this.tail = 0;
        this.nextOffset = 0;
    }

    private boolean calcOffset(int nextLength) {
        int next_head;
        if (this.nextOffset + nextLength >= 0x1000000) {
            this.nextOffset = 0;
        }
        if ((next_head = this.head + 1) == 256) {
            next_head = 0;
        }
        if (next_head == this.tail) {
            JFLog.log(this.log, "Error : Buffer Overflow (# of packets exceeded)");
            this.reset();
            return false;
        }
        int _tail = this.tail;
        if (this.head == _tail) {
            return true;
        }
        int total_length = 0;
        while (_tail != this.head) {
            total_length += this.length[_tail];
            if (++_tail != 256) continue;
            _tail = 0;
        }
        if (total_length + nextLength > 0x1000000) {
            JFLog.log(this.log, "Error : Buffer Overflow (# of bytes exceeded)");
            this.reset();
            return false;
        }
        return true;
    }

    public void add(Packet packet) {
        if (!this.calcOffset(packet.length)) {
            return;
        }
        try {
            System.arraycopy(packet.data, packet.offset, this.data, this.nextOffset, packet.length);
        }
        catch (Exception e) {
            JFLog.log(this.log, "Error:arraycopy(src," + packet.offset + ",dst," + this.nextOffset + "," + packet.length + ")");
            JFLog.log(this.log, (Throwable)e);
            return;
        }
        this.offset[this.head] = this.nextOffset;
        this.length[this.head] = packet.length;
        switch (this.codecType) {
            case 50: {
                this.type[this.head] = RTPH264.get_nal_type(packet.data, packet.offset + 4);
                break;
            }
            case 60: {
                this.type[this.head] = RTPH265.get_nal_type(packet.data, packet.offset + 4);
            }
        }
        this.nextOffset += packet.length;
        int new_head = this.head + 1;
        if (new_head == 256) {
            new_head = 0;
        }
        this.head = new_head;
    }

    public void removePacket() {
        if (this.tail == this.head) {
            JFLog.log(this.log, "Error:Packets Buffer underflow");
            return;
        }
        int new_tail = this.tail + 1;
        if (new_tail == 256) {
            new_tail = 0;
        }
        this.tail = new_tail;
    }

    public void cleanPackets(boolean mark) {
        int key_frames = 0;
        int pos = this.tail;
        while (pos != this.head) {
            switch (this.codecType) {
                case 50: {
                    if (!RTPH264.isKeyFrame(this.type[pos])) break;
                    ++key_frames;
                    break;
                }
                case 60: {
                    if (!RTPH265.isKeyFrame(this.type[pos])) break;
                    ++key_frames;
                }
            }
            if (++pos != 256) continue;
            pos = 0;
        }
        if (key_frames <= 1) {
            return;
        }
        if (mark) {
            boolean i_frame = false;
            while (this.tail != this.head) {
                switch (this.codecType) {
                    case 50: {
                        if (RTPH264.isIFrame(this.type[this.head])) {
                            i_frame = true;
                            break;
                        }
                        if (!i_frame) break;
                        return;
                    }
                    case 60: {
                        if (RTPH265.isIFrame(this.type[this.head])) {
                            i_frame = true;
                            break;
                        }
                        if (!i_frame) break;
                        return;
                    }
                }
                int new_tail = this.tail + 1;
                if (new_tail == 256) {
                    new_tail = 0;
                }
                this.tail = new_tail;
            }
        }
    }

    public boolean haveCompleteFrame() {
        int pos = this.tail;
        while (pos != this.head) {
            switch (this.codecType) {
                case 50: {
                    if (!RTPH264.isFrame(this.type[pos])) break;
                    return true;
                }
                case 60: {
                    if (!RTPH265.isFrame(this.type[pos])) break;
                    return true;
                }
            }
            if (++pos != 256) continue;
            pos = 0;
        }
        return false;
    }

    public boolean isNextFrame_KeyFrame() {
        int pos = this.tail;
        while (pos != this.head) {
            switch (this.codecType) {
                case 50: {
                    if (!RTPH264.isKeyFrame(this.type[pos])) break;
                    return true;
                }
                case 60: {
                    if (!RTPH265.isKeyFrame(this.type[pos])) break;
                    return true;
                }
            }
            switch (this.codecType) {
                case 50: {
                    if (!RTPH264.isIFrame(this.type[pos])) break;
                    return false;
                }
                case 60: {
                    if (!RTPH265.isIFrame(this.type[pos])) break;
                    return false;
                }
            }
            if (++pos != 256) continue;
            pos = 0;
        }
        return false;
    }

    public Packet getNextFrame() {
        this.next_frame_packets = 0;
        if (!this.haveCompleteFrame()) {
            JFLog.log(this.log, "Error : getNextFrame() called but don't have one ???");
            return null;
        }
        this.nextFrame.length = 0;
        int pos = this.tail;
        while (pos != this.head) {
            System.arraycopy(this.data, this.offset[pos], this.nextFrame.data, this.nextFrame.length, this.length[pos]);
            this.nextFrame.length += this.length[pos];
            ++this.next_frame_packets;
            boolean br = false;
            switch (this.codecType) {
                case 50: {
                    if (!RTPH264.isFrame(this.type[pos])) break;
                    br = true;
                    break;
                }
                case 60: {
                    if (!RTPH265.isFrame(this.type[pos])) break;
                    br = true;
                }
            }
            if (br) break;
            if (++pos != 256) continue;
            pos = 0;
        }
        return this.nextFrame;
    }

    public void removeNextFrame() {
        while (this.next_frame_packets > 0) {
            int new_tail = this.tail + 1;
            if (new_tail == 256) {
                new_tail = 0;
            }
            this.tail = new_tail;
            --this.next_frame_packets;
        }
    }

    public String toString() {
        return "Packets:tail=" + this.tail + ":head=" + this.head;
    }
}

