/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import javaforce.BE;
import javaforce.JFLog;
import javaforce.media.MediaVideoDecoder;
import javaforce.voip.CodecInfo;
import javaforce.voip.Packet;
import javaforce.voip.PacketReceiver;
import javaforce.voip.RTPChannel;
import javaforce.voip.RTPCodec;

public class RTPH265
extends RTPCodec {
    private static final int mtu = 1446;
    private int seqnum;
    private int timestamp;
    private final int ssrc = this.random.nextInt();
    private Packet packet = new Packet();
    private int lastseqnum = -1;
    private static int maxSize = 0x400000;
    private int log;
    private static final int AP = 48;
    private static final int FU = 49;
    private static final int PACI = 50;
    private static final int S = 128;
    private static final int E = 64;
    private static final int M = 128;
    private static final int LAYER_TID = 1;

    public RTPH265() {
        this.packet.data = new byte[maxSize];
    }

    public void setLog(int id) {
        this.log = id;
    }

    private int find_best_length(byte[] data, int offset, int length) {
        for (int a = 1; a < length - 3; ++a) {
            if (data[offset + a] != 0 || data[offset + a + 1] != 0 || data[offset + a + 2] != 1) continue;
            return a;
        }
        return length;
    }

    @Override
    public void encode(byte[] data, int x, int y, int id, PacketReceiver pr) {
        int len = data.length;
        int offset = 0;
        while (len > 0) {
            int packetLength;
            while (data[offset] == 0) {
                ++offset;
                --len;
            }
            if ((packetLength = --len > 1446 ? this.find_best_length(data, ++offset, len) : len) > 1446) {
                int nalLength = 1444;
                byte nal_type = RTPH265.get_nal_type(data, offset);
                byte layer_tid = data[offset + 1];
                ++offset;
                --len;
                --packetLength;
                boolean first = true;
                while (packetLength > nalLength) {
                    this.packet.length = 15 + nalLength;
                    RTPChannel.buildHeader(this.packet.data, id, this.seqnum++, this.timestamp, this.ssrc, false);
                    this.packet.data[12] = 98;
                    this.packet.data[13] = 1;
                    this.packet.data[14] = nal_type;
                    if (first) {
                        this.packet.data[14] = (byte)(this.packet.data[14] | 0x80);
                        first = false;
                    }
                    System.arraycopy(data, offset, this.packet.data, 15, nalLength);
                    offset += nalLength;
                    len -= nalLength;
                    packetLength -= nalLength;
                    pr.onPacket(this.packet);
                }
                nalLength = packetLength;
                this.packet.length = 15 + nalLength;
                RTPChannel.buildHeader(this.packet.data, id, this.seqnum++, this.timestamp, this.ssrc, len == nalLength);
                this.packet.data[12] = 98;
                this.packet.data[13] = 1;
                this.packet.data[14] = nal_type;
                this.packet.data[14] = (byte)(this.packet.data[14] | 0x40);
                System.arraycopy(data, offset, this.packet.data, 15, nalLength);
                offset += nalLength;
                len -= nalLength;
                packetLength -= nalLength;
                pr.onPacket(this.packet);
                continue;
            }
            this.packet.length = packetLength + 12;
            RTPChannel.buildHeader(this.packet.data, id, this.seqnum++, this.timestamp, this.ssrc, len == packetLength);
            System.arraycopy(data, offset, this.packet.data, 12, packetLength);
            pr.onPacket(this.packet);
            offset += packetLength;
            len -= packetLength;
        }
        this.timestamp += 100;
    }

    @Override
    public void decode(byte[] rtp, int offset, int length, PacketReceiver pr) {
        int h265Length;
        if (length < 15) {
            return;
        }
        byte nal_type = RTPH265.get_nal_type(rtp, 12);
        int thisseqnum = RTPChannel.getseqnum(rtp, 0);
        if (nal_type > 0 && nal_type < 49) {
            System.arraycopy(rtp, 12, this.packet.data, 4, h265Length);
            this.packet.data[3] = 1;
            this.packet.length = 4 + h265Length;
            pr.onPacket(this.packet);
            this.lastseqnum = thisseqnum;
            this.packet.length = 0;
            return;
        }
        if (nal_type == 49) {
            boolean m;
            boolean first = (rtp[14] & 0x80) == 128;
            boolean last = (rtp[14] & 0x40) == 64;
            byte fu_type = (byte)(rtp[14] & 0x3F);
            nal_type = (byte)(fu_type << 1);
            boolean bl = m = (rtp[1] & 0x80) == 128;
            if (m && !last) {
                JFLog.log(this.log, "Error : H265 : FU : M bit set but not last packet : seq=" + thisseqnum);
                this.lastseqnum = -1;
                this.packet.length = 0;
                return;
            }
            if (first) {
                if (this.packet.length != 0) {
                    JFLog.log(this.log, "Warning : H265 : FU : first packet again, last frame lost?");
                }
                System.arraycopy(rtp, 15, this.packet.data, 6, h265Length -= 3);
                this.packet.length = 6 + h265Length;
                this.packet.data[3] = 1;
                this.packet.data[4] = nal_type;
                this.packet.data[5] = rtp[13];
                this.lastseqnum = thisseqnum;
            } else {
                if (this.packet.length == 0) {
                    JFLog.log(this.log, "Error : H265 : partial packet received before first packet : seq=" + thisseqnum);
                    this.lastseqnum = -1;
                    this.packet.length = 0;
                    return;
                }
                if (thisseqnum != this.nextseqnum()) {
                    JFLog.log(this.log, "Error : H265 : Received FU packet out of order, discarding frame : seq=" + thisseqnum);
                    this.lastseqnum = -1;
                    this.packet.length = 0;
                    return;
                }
                this.lastseqnum = thisseqnum;
                System.arraycopy(rtp, 15, this.packet.data, this.packet.length, h265Length -= 3);
                this.packet.length += h265Length;
                if (last) {
                    pr.onPacket(this.packet);
                    this.packet.length = 0;
                }
            }
        } else if (nal_type == 48) {
            int len;
            offset += 14;
            for (h265Length = length - 12; h265Length > 2 && (len = BE.getuint16(rtp, offset)) != 0; h265Length -= len) {
                h265Length -= 2;
                this.packet.length = len;
                System.arraycopy(rtp, offset += 2, this.packet.data, 0, len);
                pr.onPacket(this.packet);
                offset += len;
            }
            this.lastseqnum = thisseqnum;
            this.packet.length = 0;
        } else if (nal_type == 50) {
            this.lastseqnum = thisseqnum;
            this.packet.length = 0;
        } else {
            JFLog.log(this.log, "H265:Unsupported packet type:" + nal_type);
            this.lastseqnum = -1;
            this.packet.length = 0;
        }
    }

    private int nextseqnum() {
        if (this.lastseqnum == 65535) {
            return 0;
        }
        return this.lastseqnum + 1;
    }

    private static byte get_fu_type(byte[] rtp, int offset) {
        return (byte)(rtp[offset] & 0x2F);
    }

    public static byte get_nal_type(byte[] packet, int offset) {
        return (byte)((packet[offset] & 0x7E) >> 1);
    }

    public static boolean isKeyFrame(byte type) {
        return type == 19 || type == 20;
    }

    public static boolean isIFrame(byte type) {
        return type == 1;
    }

    public static boolean isFrame(byte type) {
        return type == 19 || type == 20 || type == 1;
    }

    public static boolean isSPS(byte type) {
        return type == 33;
    }

    public static boolean canDecodePacket(byte type) {
        switch (type) {
            case 1: 
            case 19: 
            case 20: 
            case 32: 
            case 33: 
            case 34: {
                return true;
            }
        }
        return false;
    }

    public static CodecInfo getCodecInfo(Packet sps) {
        MediaVideoDecoder decoder = new MediaVideoDecoder();
        decoder.start(173, 320, 200);
        decoder.decode(sps.data, sps.offset, sps.length);
        CodecInfo info = new CodecInfo();
        info.width = decoder.getWidth();
        info.height = decoder.getHeight();
        info.fps = decoder.getFrameRate();
        decoder.stop();
        return info;
    }
}

