/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.util.Hashtable;
import javaforce.JFLog;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class LDAP {
    private static boolean debug = false;
    private DirContext ctx;
    public Exception lastException;

    public boolean login(String server, String domain, String username, String password) {
        try {
            if (username.length() == 0) {
                throw new Exception("invalid username");
            }
            if (password.length() == 0) {
                throw new Exception("invalid password");
            }
            Hashtable<String, Object> env = new Hashtable<String, Object>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", "ldap://" + server + ":389");
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", domain + "\\" + username);
            env.put("java.naming.security.credentials", password);
            this.ctx = new InitialDirContext(env);
            return true;
        }
        catch (Exception e) {
            this.lastException = e;
            System.out.println(e);
            return false;
        }
    }

    public void close() {
        if (this.ctx != null) {
            try {
                this.ctx.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ctx = null;
        }
    }

    public String[] getAttributes(String domain_dn, String key, String[] attrs) {
        if (this.ctx == null) {
            JFLog.log("Please login first!");
            return null;
        }
        String[] values = new String[attrs.length];
        try {
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(2);
            constraints.setReturningAttributes(attrs);
            NamingEnumeration<SearchResult> answer = this.ctx.search(domain_dn, key, constraints);
            if (!answer.hasMore()) {
                throw new Exception("no results");
            }
            Attributes results = answer.next().getAttributes();
            if (debug) {
                JFLog.log("results=" + results);
            }
            for (int a = 0; a < attrs.length; ++a) {
                Object value = results.get(attrs[a]);
                if (value == null) {
                    value = "null";
                }
                values[a] = value.toString();
            }
            return values;
        }
        catch (Exception e) {
            this.lastException = e;
            JFLog.log(e);
            return null;
        }
    }

    public boolean memberOf(String domain_dn, String username, String group) {
        String[] groups;
        String[] list = this.getAttributes(domain_dn, "SAMAccountName=" + username, new String[]{"memberOf"});
        if (list == null || list.length == 0) {
            return false;
        }
        for (String grp : groups = list[0].replaceAll("\\\\,", "_").split("[,] ")) {
            int i1 = grp.indexOf(61);
            int i2 = grp.indexOf(44);
            if (i1 == -1 || i2 == -1 || !(grp = grp.substring(i1 + 1, i2)).equalsIgnoreCase(group)) continue;
            return true;
        }
        return false;
    }

    public static String build_dn(String domain) {
        StringBuilder dn = new StringBuilder();
        String[] p = domain.split("[.]");
        for (int a = 0; a < p.length; ++a) {
            if (a > 0) {
                dn.append(",");
            }
            dn.append("dc=");
            dn.append(p[a]);
        }
        return dn.toString();
    }

    public Exception getLastException() {
        return this.lastException;
    }

    private static void usage() {
        System.out.println("Usage:ldap {command} [args]");
        System.out.println(" login server domain username password");
        System.out.println(" attrs server domain username password dname key attrs...");
        System.out.println(" memberof server domain username password dname username group");
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            LDAP.usage();
        }
        LDAP ldap = new LDAP();
        try {
            switch (args[0]) {
                case "login": {
                    boolean ok = ldap.login(args[1], args[2], args[3], args[4]);
                    System.out.println("login = " + ok);
                    break;
                }
                case "attrs": {
                    boolean ok = ldap.login(args[1], args[2], args[3], args[4]);
                    if (!ok) {
                        System.out.println("login failed");
                        return;
                    }
                    int attrCount = args.length - 7;
                    String[] attrs = new String[attrCount];
                    for (int a = 0; a < attrCount; ++a) {
                        attrs[a] = args[a + 7];
                    }
                    String[] list = ldap.getAttributes(args[5], args[6], attrs);
                    if (list == null || list.length == 0) {
                        System.out.println("no attrs returned");
                        break;
                    }
                    for (String attr : list) {
                        System.out.println("attr[]=" + attr);
                    }
                    break;
                }
                case "memberof": {
                    boolean ok = ldap.login(args[1], args[2], args[3], args[4]);
                    if (!ok) {
                        System.out.println("login failed");
                        return;
                    }
                    boolean isMember = ldap.memberOf(args[5], args[6], args[7]);
                    System.out.println("memberOf = " + isMember);
                    break;
                }
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }
}

