/*
 * Decompiled with CFR 0.152.
 */
package javaforce.gl;

import javaforce.JFLog;
import javaforce.gl.Angles3;

public class Quaternion {
    public float x;
    public float y;
    public float z;
    public float w;

    public void set(float x, float y, float z, Angles3.Order order) {
        float c1 = (float)Math.cos(x / 2.0f);
        float c2 = (float)Math.cos(y / 2.0f);
        float c3 = (float)Math.cos(z / 2.0f);
        float s1 = (float)Math.sin(x / 2.0f);
        float s2 = (float)Math.sin(y / 2.0f);
        float s3 = (float)Math.sin(z / 2.0f);
        switch (order) {
            case XYZ: {
                this.x = s1 * c2 * c3 + c1 * s2 * s3;
                this.y = c1 * s2 * c3 - s1 * c2 * s3;
                this.z = c1 * c2 * s3 + s1 * s2 * c3;
                this.w = c1 * c2 * c3 - s1 * s2 * s3;
                break;
            }
            case YXZ: {
                this.x = s1 * c2 * c3 + c1 * s2 * s3;
                this.y = c1 * s2 * c3 - s1 * c2 * s3;
                this.z = c1 * c2 * s3 - s1 * s2 * c3;
                this.w = c1 * c2 * c3 + s1 * s2 * s3;
                break;
            }
            case ZXY: {
                this.x = s1 * c2 * c3 - c1 * s2 * s3;
                this.y = c1 * s2 * c3 + s1 * c2 * s3;
                this.z = c1 * c2 * s3 + s1 * s2 * c3;
                this.w = c1 * c2 * c3 - s1 * s2 * s3;
                break;
            }
            case ZYX: {
                this.x = s1 * c2 * c3 - c1 * s2 * s3;
                this.y = c1 * s2 * c3 + s1 * c2 * s3;
                this.z = c1 * c2 * s3 - s1 * s2 * c3;
                this.w = c1 * c2 * c3 + s1 * s2 * s3;
                break;
            }
            case YZX: {
                this.x = s1 * c2 * c3 + c1 * s2 * s3;
                this.y = c1 * s2 * c3 + s1 * c2 * s3;
                this.z = c1 * c2 * s3 - s1 * s2 * c3;
                this.w = c1 * c2 * c3 - s1 * s2 * s3;
                break;
            }
            case XZY: {
                this.x = s1 * c2 * c3 - c1 * s2 * s3;
                this.y = c1 * s2 * c3 - s1 * c2 * s3;
                this.z = c1 * c2 * s3 + s1 * s2 * c3;
                this.w = c1 * c2 * c3 + s1 * s2 * s3;
                break;
            }
            default: {
                JFLog.log("Error:Quaternion.set():Unknown order");
            }
        }
    }

    public void set(Angles3 a3, Angles3.Order order) {
        this.set(a3.v[0], a3.v[1], a3.v[2], order);
    }

    public String toString() {
        return String.format("%.3f,%.3f,%.3f,%.3f\r\n", Float.valueOf(this.w), Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }
}

