/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import javaforce.ConsoleOutput;
import javaforce.ansi.server.ANSI;
import javaforce.ansi.server.KeyEvents;
import javaforce.ansi.server.ProgressBar;

public class CopyPath
implements KeyEvents {
    public static String[] args;
    public ANSI ansi;
    public String src;
    public String dest;
    public int found;
    public int copied;
    public int skipped;
    public int total;
    public int done;
    public int lastdone;
    public ProgressBar progress;

    @Override
    public void keyPressed(int keyCode, int keyMods) {
    }

    @Override
    public void keyTyped(char key) {
    }

    public static void main(String[] args) {
        ANSI.enableConsoleMode();
        ConsoleOutput.install();
        CopyPath.args = args;
        int ret = 0;
        try {
            new CopyPath().run();
        }
        catch (Throwable e) {
            e.printStackTrace();
            ret = 1;
        }
        ANSI.disableConsoleMode();
        System.exit(ret);
    }

    public void usage() {
        System.out.println("CopyPath src dest");
    }

    public void run() {
        if (args.length < 2) {
            this.usage();
            return;
        }
        this.src = args[0];
        this.dest = args[1];
        File fsrc = new File(this.src);
        if (!fsrc.exists() || !fsrc.isDirectory()) {
            System.out.println("Error:src not found");
            return;
        }
        File fdest = new File(this.dest);
        if (fdest.exists() && !fdest.isDirectory()) {
            System.out.println("Error:dest not folder");
            return;
        }
        if (!fdest.exists()) {
            fdest.mkdirs();
        }
        this.ansi = new ANSI(this);
        this.progress = new ProgressBar();
        this.ansi.getConsoleSize();
        int[] pos = this.ansi.getConsolePos();
        this.progress.setPos(0, pos[1]);
        this.progress.setWidth(this.ansi.width - 1);
        this.lastdone = -1;
        this.findPath(fsrc);
        this.progress.draw();
        try {
            this.copyPath(fsrc, fdest);
            if (this.lastdone != 100) {
                this.progress.setValue(100);
                this.progress.draw();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void findPath(File src) {
        File[] files = src.listFiles();
        if (files == null) {
            return;
        }
        for (int a = 0; a < files.length; ++a) {
            if (files[a].isDirectory()) {
                this.findPath(files[a]);
                continue;
            }
            ++this.found;
        }
    }

    public void copyPath(File src, File dest) throws Exception {
        File[] files = src.listFiles();
        if (files == null) {
            return;
        }
        for (int a = 0; a < files.length; ++a) {
            String name = files[a].getName();
            if (files[a].isDirectory()) {
                File destPath = new File(dest, name);
                destPath.mkdir();
                this.copyPath(files[a], destPath);
                continue;
            }
            File destFile = new File(dest, name);
            if (destFile.exists()) {
                long srctime = files[a].lastModified();
                long desttime = destFile.lastModified();
                if (desttime >= srctime) {
                    ++this.skipped;
                    continue;
                }
            }
            Files.copy(Paths.get(files[a].getAbsolutePath(), new String[0]), Paths.get(destFile.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            ++this.copied;
            this.done = (this.copied + this.skipped) * 100 / this.found;
            if (this.lastdone == this.done) continue;
            this.lastdone = this.done;
            this.progress.setValue(this.done);
            this.progress.draw();
        }
    }
}

