/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.File;
import java.io.FileInputStream;
import javaforce.JFLog;
import javaforce.ShellProcessListener;
import javaforce.utils.BuildTools;
import javaforce.utils.InstallProject;

public class UninstallProject
implements ShellProcessListener {
    private BuildTools tools;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage:UninstallProject build.xml");
            System.exit(1);
        }
        try {
            new InstallProject().run(args[0]);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void run(String buildfile) throws Exception {
        String apptype;
        this.tools = new BuildTools();
        if (!this.tools.loadXML(buildfile)) {
            throw new Exception("error loading " + buildfile);
        }
        Object app = this.tools.getProperty("app");
        switch (apptype = this.tools.getProperty("apptype")) {
            case "client": {
                app = (String)app + "-client";
                break;
            }
            case "server": {
                app = (String)app + "-server";
            }
        }
        new File("/usr/bin/" + (String)app).delete();
        try {
            File files = new File("files.lst");
            if (files.exists()) {
                String[] lns;
                FileInputStream fis = new FileInputStream(files);
                byte[] lst = fis.readAllBytes();
                for (String ln : lns = new String(lst).replaceAll("\r", "").split("\n")) {
                    File file;
                    if (ln.length() == 0 || !(file = new File(ln)).exists()) continue;
                    file.delete();
                }
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
        this.doSubProjects();
    }

    @Override
    public void shellProcessOutput(String str) {
        System.out.print(str);
    }

    private void doSubProjects() {
        for (int a = 2; a <= 5; ++a) {
            String project = this.tools.getProperty("project" + a);
            if (project.length() == 0) continue;
            UninstallProject.main(new String[]{project + ".xml"});
        }
    }
}

