/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javaforce.JFLog;

public class Zip {
    private String command;
    private String zip;
    private ArrayList<String> files = new ArrayList();
    private FileInputStream fis;
    private ZipInputStream zis;
    private FileOutputStream fos;
    private ZipOutputStream zos;
    private final int bufsiz = 65536;
    private byte[] buffer = new byte[65536];

    public static void main(String[] args) {
        new Zip().run(args);
    }

    public void run(String[] args) {
        for (int a = 0; a < args.length; ++a) {
            String arg = args[a];
            if (arg.startsWith("-")) continue;
            if (this.command == null) {
                this.command = arg;
                continue;
            }
            if (this.zip == null) {
                this.zip = arg;
                continue;
            }
            this.files.add(arg);
        }
        if (this.command == null || this.zip == null || this.files.size() == 0) {
            this.usage();
            System.exit(2);
        }
        try {
            switch (this.command) {
                case "a": {
                    this.add();
                    break;
                }
                case "e": {
                    this.extract();
                    break;
                }
                case "d": {
                    this.delete();
                }
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void usage() {
        System.out.println("Usage: jfzip command zip [options] <files...>");
        System.out.println("  command : a=add,e=extract,d=delete");
        System.out.println("  @file = files are listed in file");
    }

    private boolean addFile(String file) {
        ZipEntry entry = new ZipEntry(file);
        try {
            long tocopy;
            int copy;
            this.zos.putNextEntry(entry);
            FileInputStream fis = new FileInputStream(file);
            for (long left = tocopy = (long)file.length(); left > 0L; left -= (long)copy) {
                copy = (int)(left > 65536L ? 65536L : left);
                int read = fis.read(this.buffer, 0, copy);
                if (read == -1) {
                    throw new Exception("bad read");
                }
                this.zos.write(this.buffer, 0, copy);
            }
            fis.close();
            this.zos.closeEntry();
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    private boolean add() throws Exception {
        if (new File(this.zip).exists()) {
            this.fis = new FileInputStream(this.zip);
            this.fos = new FileOutputStream(Files.createTempFile(this.zip, "-new", new FileAttribute[0]).toFile());
            this.zis = new ZipInputStream(this.fis);
            this.zos = new ZipOutputStream(this.fos);
        } else {
            this.fos = new FileOutputStream(this.zip);
            this.zos = new ZipOutputStream(this.fos);
        }
        for (String file : this.files) {
            if (file.startsWith("@") || this.addFile(file)) continue;
            return false;
        }
        return true;
    }

    private void extract() throws Exception {
    }

    private void delete() throws Exception {
    }
}

