/*
 * Decompiled with CFR 0.152.
 */
package javaforce.vm;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import javaforce.JFLog;
import javaforce.XML;
import javaforce.vm.Address;

public class Device
extends Address
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static boolean debug = true;
    public int type;
    public String name;
    public String desc;
    public transient String xml;
    public static final int TYPE_USB = 1;
    public static final int TYPE_PCI = 2;

    private static native String[] nlist(int var0);

    public static Device[] list(int type) {
        if (type < 1 || type > 2) {
            return null;
        }
        String[] list = Device.nlist(type);
        if (list == null) {
            list = new String[]{};
        }
        Device[] dlist = new Device[list.length];
        for (int idx = 0; idx < list.length; ++idx) {
            String devstr = list[idx];
            int eq = devstr.indexOf(61);
            if (eq == -1) continue;
            String name = devstr.substring(0, eq);
            String xml = devstr.substring(eq + 1);
            Device dev = new Device();
            dev.type = type;
            dev.name = name;
            dev.xml = xml;
            if (debug) {
                JFLog.log("Device:" + dev);
            }
            try {
                dev.decode_address();
            }
            catch (Exception e) {
                JFLog.log(e);
            }
            dlist[idx] = dev;
        }
        return dlist;
    }

    public String getType() {
        switch (this.type) {
            case 2: {
                return "pci";
            }
            case 1: {
                return "usb";
            }
        }
        return "???";
    }

    public String toString() {
        return this.name + ":" + this.desc;
    }

    private void decode_address() {
        XML _xml = new XML();
        ByteArrayInputStream bais = new ByteArrayInputStream(this.xml.getBytes());
        _xml.read(bais);
        switch (this.type) {
            case 1: {
                XML.XMLTag[] tags;
                XML.XMLTag caps = _xml.getTag(new String[]{"device", "capability"});
                block28: for (XML.XMLTag tag : tags = caps.getChildren()) {
                    String name = tag.getName();
                    String content = tag.getContent();
                    switch (name) {
                        case "bus": {
                            this.bus = content;
                            continue block28;
                        }
                        case "device": {
                            this.port = content;
                            continue block28;
                        }
                        case "product": {
                            this.desc = content;
                        }
                    }
                }
                break;
            }
            case 2: {
                XML.XMLTag[] tags;
                XML.XMLTag caps = _xml.getTag(new String[]{"device", "capability"});
                block29: for (XML.XMLTag tag : tags = caps.getChildren()) {
                    String name = tag.getName();
                    String content = tag.getContent();
                    switch (name) {
                        case "domain": {
                            this.domain = content;
                            continue block29;
                        }
                        case "bus": {
                            this.bus = content;
                            continue block29;
                        }
                        case "slot": {
                            this.slot = content;
                            continue block29;
                        }
                        case "function": {
                            this.function = content;
                            continue block29;
                        }
                        case "product": {
                            this.desc = content;
                        }
                    }
                }
                break;
            }
        }
    }

    public String toXML() {
        StringBuilder xml = new StringBuilder();
        xml.append("<hostdev mode='subsystem' type='" + this.getType() + "'>");
        xml.append("<source>");
        xml.append(this.getAddressXML());
        xml.append("</source>");
        xml.append("</hostdev>");
        return xml.toString();
    }
}

