/*
 * Decompiled with CFR 0.152.
 */
package javaforce.vm;

import java.io.File;
import java.io.Serializable;
import javaforce.ShellProcess;
import javaforce.vm.Size;
import javaforce.vm.Storage;

public class Disk
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String pool;
    public String folder;
    public String name;
    public int type;
    public Size size;
    public int boot_order;
    public String target_dev = "sd%c";
    public String target_bus = "scsi";
    public static final int TYPE_VMDK = 0;
    public static final int TYPE_QCOW2 = 1;
    public static final int TYPE_ISO = 2;
    public static final int PROVISION_THICK = 0;
    public static final int PROVISION_THIN = 1;

    public String getType() {
        switch (this.type) {
            case 1: {
                return "qcow2";
            }
            case 0: {
                return "vmdk";
            }
            case 2: {
                return "iso";
            }
        }
        return "";
    }

    public static int getType(String ext) {
        switch (ext) {
            case "qcow2": {
                return 1;
            }
            case "vmdk": {
                return 0;
            }
            case "iso": {
                return 2;
            }
        }
        return -1;
    }

    public String getPath() {
        return "/volumes/" + this.pool + "/" + this.folder + "/" + this.name + "." + this.getType();
    }

    public String getPath(String pool) {
        return "/volumes/" + pool + "/" + this.folder + "/" + this.name + "." + this.getType();
    }

    public boolean exists() {
        return new File(this.getPath()).exists();
    }

    public boolean exists(String pool) {
        return new File(this.getPath(pool)).exists();
    }

    private String getPath2() {
        String flat;
        if (this.type == 0 && new File(flat = "/volumes/" + this.pool + "/" + this.folder + "/" + this.name + "-flat." + this.getType()).exists()) {
            return flat;
        }
        return "/volumes/" + this.pool + "/" + this.folder + "/" + this.name + "." + this.getType();
    }

    private static native boolean ncreate(String var0, String var1);

    public boolean create(Storage pool, int provision) {
        ShellProcess sp = new ShellProcess();
        switch (this.type) {
            case 0: {
                String subformat = "";
                switch (provision) {
                    case 0: {
                        subformat = "monolithicFlat";
                        break;
                    }
                    default: {
                        subformat = "monolithicSparse";
                    }
                }
                sp.run(new String[]{"/usr/bin/qemu-img", "create", "-f", this.getType(), "-o", "subformat=" + subformat, this.getPath(), this.size.getSize()}, true);
                break;
            }
            case 1: {
                String preallocation = "";
                switch (provision) {
                    case 0: {
                        preallocation = "metadata";
                        break;
                    }
                    default: {
                        preallocation = "off";
                    }
                }
                sp.run(new String[]{"/usr/bin/qemu-img", "create", "-f", this.getType(), "-o", "preallocation=" + preallocation, this.getPath(), this.size.getSize()}, true);
                break;
            }
        }
        return sp.getErrorLevel() == 0;
    }

    public boolean resize(Storage pool) {
        ShellProcess sp = new ShellProcess();
        switch (this.type) {
            case 0: {
                sp.run(new String[]{"/usr/bin/qemu-img", "resize", this.getPath(), this.size.getSize()}, true);
                break;
            }
            case 1: {
                sp.run(new String[]{"/usr/bin/qemu-img", "resize", this.getPath(), this.size.getSize()}, true);
            }
        }
        return sp.getErrorLevel() == 0;
    }

    private String getDeviceType() {
        switch (this.type) {
            case 2: {
                return "cdrom";
            }
        }
        return "disk";
    }

    public String getHardwareXML() {
        StringBuilder xml = new StringBuilder();
        xml.append("<disk type='file' device='" + this.getDeviceType() + "'>");
        xml.append("<source file='" + this.getPath2() + "'>");
        xml.append("</source>");
        xml.append("<target dev='" + this.target_dev + "' bus='" + this.target_bus + "'/>");
        if (this.boot_order > 0) {
            xml.append("<boot order='" + this.boot_order + "'/>");
        }
        xml.append("</disk>");
        return xml.toString();
    }

    private String getCreateXML(int provision) {
        StringBuilder xml = new StringBuilder();
        xml.append("<volume type='file'>");
        xml.append("<name>" + this.name + "</name>");
        xml.append("<allocation unit='" + this.size.getUnitChar() + "iB'>");
        switch (provision) {
            case 0: {
                xml.append(this.size.size);
                break;
            }
            case 1: {
                xml.append("0");
            }
        }
        xml.append("</allocation>");
        xml.append("<capacity unit='" + this.size.getUnitChar() + "iB'>");
        xml.append(this.size.size);
        xml.append("</capacity>");
        xml.append("<target>");
        xml.append("<path>" + this.getPath() + "</path>");
        xml.append("<format type='" + this.getType() + "'/>");
        xml.append("</target>");
        xml.append("</volume>");
        return xml.toString();
    }

    public String toString() {
        if (this.type == 2) {
            return this.name + ":iso";
        }
        return this.name + ":" + this.size.toString();
    }
}

