/*
 * Decompiled with CFR 0.152.
 */
package javaforce.vm;

import java.io.Serializable;
import javaforce.vm.Address;
import javaforce.vm.NetworkBridge;

public class Network
extends Address
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String network;
    public String model;
    public String mac;
    public static final String MODEL_E1000 = "e1000";
    public static final String MODEL_E1000E = "e1000e";
    public static final String MODEL_NET2K = "net2k_pci";
    public static final String MODEL_RTL8139 = "rtl8139";
    public static final String MODEL_VIRTIO = "virtio-net-pci";
    public static final String MODEL_i82801 = "i82801";
    public static final String MODEL_VMXNET3 = "vmxnet3";

    public Network(String network, String model, String mac) {
        this.network = network;
        this.model = model;
        this.mac = mac;
    }

    public String toString() {
        return "Network{" + this.network + "," + this.model + "," + this.mac + "}";
    }

    public String toXML(NetworkBridge bridge, int vlan) {
        StringBuilder xml = new StringBuilder();
        xml.append("<interface type='bridge'>");
        xml.append("<source bridge='" + bridge.name + "'/>");
        if (bridge.type.equals("os")) {
            xml.append("<virtualport type='openvswitch'/>");
            if (vlan != 0) {
                xml.append("<vlan><tag id='" + vlan + "'></tag></vlan>");
            }
        }
        xml.append("<model type='" + this.model + "'/>");
        xml.append("<mac address='" + this.mac + "'/>");
        xml.append("</interface>");
        return xml.toString();
    }
}

