/*
 * Decompiled with CFR 0.152.
 */
package javaforce.vm;

import java.io.Serializable;
import javaforce.JF;
import javaforce.ShellProcess;
import javaforce.vm.NetworkBridge;
import javaforce.vm.NetworkConfig;
import javaforce.vm.NetworkPort;

public class NetworkVirtual
extends NetworkConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final boolean libvirt = false;
    public String bridge;
    public int vlan;

    protected NetworkVirtual(String name) {
        super(name);
        this.bridge = NetworkVirtual.ngetbridge(name);
    }

    public NetworkVirtual(String name, String bridge, String mac, String ip, String netmask, int vlan) {
        super(name);
        this.mac = mac;
        this.ip = ip;
        this.netmask = netmask;
        this.bridge = bridge;
        this.vlan = vlan;
    }

    @Override
    public String[] getState() {
        return new String[]{this.name, this.state.ip + "/" + this.state.netmask, this.state.mac, Integer.toString(this.vlan), this.bridge, this.state.link};
    }

    private static native String ngetbridge(String var0);

    private static native String[] nlistVirt();

    public static NetworkVirtual[] listVirtual() {
        return null;
    }

    private static native String[] nlistPort(String var0);

    public NetworkPort[] listPort() {
        return null;
    }

    private static native boolean ncreatevirt(String var0);

    public static NetworkVirtual createVirtual(String name, NetworkBridge bridge, String mac, String ip, String netmask, int vlan) {
        ShellProcess p = new ShellProcess();
        p.keepOutput(true);
        p.run(new String[]{"/usr/bin/ovs-vsctl", "add-br", name, bridge.name, Integer.toString(vlan)}, true);
        NetworkVirtual nic = new NetworkVirtual(name, bridge.name, mac, ip, netmask, vlan);
        nic.link_up();
        nic.set_ip();
        return nic;
    }

    private static native boolean ncreateport(String var0, String var1);

    public boolean createPort(String name, int vlan) {
        return false;
    }

    private static native boolean nstart(String var0);

    public boolean start() {
        return false;
    }

    private static native boolean nstop(String var0);

    public boolean stop() {
        return false;
    }

    private static native boolean nremove(String var0);

    public boolean remove() {
        ShellProcess p = new ShellProcess();
        p.keepOutput(true);
        p.run(new String[]{"/usr/bin/ovs-vsctl", "del-br", this.name}, true);
        return true;
    }

    protected static String createXML(String name, NetworkBridge bridge, String mac, String ip, String netmask, int vlan) {
        StringBuilder xml = new StringBuilder();
        xml.append("<network>");
        xml.append("<name>" + name + "</name>");
        xml.append("<uuid>" + JF.generateUUID() + "</uuid>");
        xml.append("<forward mode='bridge'/>");
        xml.append("<bridge name='" + bridge.name + "'/>");
        if (bridge.type.equals("os")) {
            xml.append("<virtualport type='openvswitch'/>");
            xml.append("<vlan><tag id='" + vlan + "'></tag></vlan>");
        }
        xml.append("</network>");
        return xml.toString();
    }
}

