/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import javaforce.JF;
import javaforce.JFLog;

public class XML {
    private static boolean debug = false;
    public XMLTag header = new XMLTag();
    public XMLTag root = new XMLTag();
    private final int XML_OPEN = 1;
    private final int XML_DATA = 2;
    private final int XML_CLOSE = 3;
    private final int XML_SINGLE = 4;
    private int type;
    private int line;
    private int pos;
    private char[] buf;
    private int indent;

    private XMLTagPart readtag() {
        boolean quote2 = false;
        boolean quote1 = false;
        boolean isAttrs = false;
        XMLTagPart tag = new XMLTagPart();
        this.type = 2;
        block4: while (this.pos < this.buf.length) {
            char ch;
            if ((ch = this.buf[this.pos++]) == '\n') {
                ++this.line;
            }
            switch (this.type) {
                case 1: 
                case 3: 
                case 4: {
                    if (ch == '\"' && !quote1) {
                        boolean bl = quote2 = !quote2;
                    }
                    if (ch != '\'' || !quote2) {
                        // empty if block
                    }
                    if (!quote1 && !quote2) {
                        if (ch == '/') {
                            if (tag.content.length() == 0) {
                                this.type = 3;
                                continue block4;
                            }
                            this.type = 4;
                            continue block4;
                        }
                        if (ch == '>') break block4;
                    }
                    if (!isAttrs && Character.isWhitespace(ch)) {
                        isAttrs = true;
                    }
                    if (isAttrs) {
                        tag.attrs = tag.attrs + ch;
                        continue block4;
                    }
                    tag.content = tag.content + ch;
                    continue block4;
                }
                case 2: {
                    if (ch == '<' && !quote2 && !quote1) {
                        if (tag.content.length() > 0) {
                            --this.pos;
                            break block4;
                        }
                        this.type = 1;
                        continue block4;
                    }
                    if (ch == '\"' && !quote1) {
                        boolean bl = quote2 = !quote2;
                    }
                    if (ch != '\'' || !quote2) {
                        // empty if block
                    }
                    tag.content = tag.content + ch;
                    continue block4;
                }
            }
        }
        if (tag.content.length() == 0) {
            return null;
        }
        if (this.type == 2) {
            tag.content = this.decodeSafe(tag.content);
        }
        return tag;
    }

    private void string2attrs(XMLTag tag, String attrs) {
        char[] ca = attrs.toCharArray();
        int length = attrs.length();
        tag.attrs.clear();
        for (int a = 0; a < length; ++a) {
            int b;
            if (Character.isWhitespace(ca[a])) continue;
            int ep = attrs.indexOf(61, a);
            if (ep == -1) {
                return;
            }
            Object name = "";
            for (b = a; b < ep; ++b) {
                name = (String)name + ca[b];
            }
            a = ep + 1;
            Object value = "";
            if (ca[a] == '\"') {
                if ((ep = attrs.indexOf(34, ++a)) == -1) {
                    return;
                }
                for (b = a; b < ep; ++b) {
                    value = (String)value + ca[b];
                }
                a = ep + 1;
            } else if (ca[a] == '\'') {
                if ((ep = attrs.indexOf(39, ++a)) == -1) {
                    return;
                }
                for (b = a; b < ep; ++b) {
                    value = (String)value + ca[b];
                }
                a = ep + 1;
            } else {
                for (ep = a; ep < length && !Character.isWhitespace(ca[ep]); ++ep) {
                }
                if (ep == length) {
                    ep = length - 1;
                }
                if (ep <= a) {
                    return;
                }
                for (b = a; b < ep; ++b) {
                    value = (String)value + ca[b];
                }
                a = ep + 1;
            }
            XMLAttr attr = new XMLAttr();
            attr.name = name;
            attr.value = this.decodeSafe((String)value);
            tag.attrs.add(attr);
        }
    }

    public boolean read(String filename) {
        boolean ret;
        try {
            FileInputStream fis = new FileInputStream(filename);
            ret = this.read(fis);
            fis.close();
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
        return ret;
    }

    public boolean read(InputStream is) {
        XMLTagPart tagpart;
        try {
            this.buf = new String(JF.readAll(is), "UTF-8").toCharArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        this.deleteAll();
        this.type = 2;
        XMLTag tag = null;
        boolean bRoot = false;
        boolean bHeader = false;
        this.line = 1;
        while ((tagpart = this.readtag()) != null) {
            switch (this.type) {
                case 1: {
                    if (tagpart.content.startsWith("?xml")) {
                        if (bHeader) {
                            JFLog.log("XML:Multiple headers found");
                            return false;
                        }
                        this.header.name = tagpart.content;
                        this.string2attrs(this.header, tagpart.attrs);
                        break;
                    }
                    if (tagpart.content.startsWith("!--")) break;
                }
                case 4: {
                    if (tag == null) {
                        if (debug) {
                            JFLog.log("root tag:" + tagpart.content);
                        }
                        if (bRoot) {
                            JFLog.log("XML:Multiple root tags found");
                            return false;
                        }
                        bRoot = true;
                        this.root.name = tagpart.content;
                        this.string2attrs(this.root, tagpart.attrs);
                        tag = this.root;
                        break;
                    }
                    XMLTag newtag = new XMLTag();
                    newtag.name = tagpart.content;
                    this.string2attrs(newtag, tagpart.attrs);
                    this.addTag(tag, newtag);
                    if (this.type == 4) {
                        newtag.isSingle = true;
                        break;
                    }
                    tag = newtag;
                    break;
                }
                case 3: {
                    if (tag == null) {
                        JFLog.log("XML:tag closed but never opened:line=" + this.line);
                        return false;
                    }
                    if (!tagpart.content.equalsIgnoreCase(tag.name)) {
                        JFLog.log("XML:tag closed doesn't match open:tag.open=" + tag.name + ":tag.close=" + tagpart.content + ":line=" + this.line);
                        return false;
                    }
                    tag = tag.getParent();
                    break;
                }
                case 2: {
                    if (tag == null) break;
                    tag.content = tag.content + tagpart.content;
                }
            }
        }
        this.buf = null;
        if (tag != null) {
            JFLog.log("XML:tag left open");
            return false;
        }
        return true;
    }

    private String attrs2string(XMLTag tag) {
        int size = tag.attrs.size();
        Object str = "";
        for (int a = 0; a < size; ++a) {
            XMLAttr attr = tag.attrs.get(a);
            String tmp = " " + attr.name + "=\"" + this.encodeSafe(attr.value) + "\"";
            str = (String)str + tmp;
        }
        return str;
    }

    private void writestr(OutputStream out, String str) {
        try {
            out.write(str.getBytes("UTF-8"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writetag(OutputStream out, XMLTag tag) {
        Object tmp = "";
        for (int a = 0; a < this.indent; ++a) {
            tmp = (String)tmp + " ";
        }
        this.writestr(out, (String)tmp);
        int size = tag.getChildCount();
        if (size > 0) {
            int a;
            String attrs = this.attrs2string(tag);
            tmp = "<" + tag.name + attrs + ">\n";
            this.writestr(out, (String)tmp);
            this.indent += 2;
            for (a = 0; a < size; ++a) {
                this.writetag(out, tag.getChildAt(a));
            }
            this.indent -= 2;
            tmp = "";
            for (a = 0; a < this.indent; ++a) {
                tmp = (String)tmp + " ";
            }
            this.writestr(out, (String)tmp);
            tmp = "</" + tag.name + ">\n";
            this.writestr(out, (String)tmp);
        } else {
            String attrs = this.attrs2string(tag);
            tmp = tag.isSingle ? "<" + tag.name + attrs + "/>\n" : "<" + tag.name + attrs + ">" + this.encodeSafe(tag.content) + "</" + tag.name + ">\n";
            this.writestr(out, (String)tmp);
        }
    }

    public boolean write(String filename) {
        boolean ret;
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            ret = this.write(fos);
            fos.close();
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
        return ret;
    }

    public boolean write(OutputStream os) {
        String tmp;
        String attrs;
        BufferedOutputStream bos = new BufferedOutputStream(os);
        if (this.root.name.length() == 0) {
            return false;
        }
        if (this.header.name.length() > 0) {
            attrs = this.attrs2string(this.header);
            tmp = "<" + this.header.name + attrs + ">\n";
            this.writestr(bos, tmp);
        }
        attrs = this.attrs2string(this.root);
        tmp = "<" + this.root.name + attrs + ">\n";
        this.writestr(bos, tmp);
        int size = this.root.getChildCount();
        this.indent = 2;
        for (int a = 0; a < size; ++a) {
            this.writetag(bos, this.root.getChildAt(a));
        }
        tmp = "</" + this.root.name + ">\n";
        this.writestr(bos, tmp);
        try {
            bos.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private void clearTag(XMLTag tag) {
        tag.name = "";
        tag.attrs = new ArrayList();
        tag.content = "";
    }

    public void deleteAll() {
        this.deleteTag(this.root);
        this.clearTag(this.header);
        this.clearTag(this.root);
    }

    public boolean deleteTag(XMLTag tag) {
        while (tag.getChildCount() > 0) {
            this.deleteTag(tag.getChildAt(0));
        }
        if (tag.getParent() == null) {
            return true;
        }
        tag.getParent().removeTag(tag);
        return true;
    }

    public XMLTag createTag() {
        return new XMLTag();
    }

    public XMLTag addTag(XMLTag parent, XMLTag tag) {
        parent.addTag(tag, parent.getChildCount());
        return tag;
    }

    public XMLTag addTag(XMLTag targetParent, String name, String attrs, String content) {
        XMLTag newtag = new XMLTag();
        newtag.name = name;
        newtag.content = content;
        this.string2attrs(newtag, attrs);
        return this.addTag(targetParent, newtag);
    }

    public XMLTag addSetTag(XMLTag targetParent, String name, String attrs, String content) {
        int len = targetParent.getChildCount();
        for (int a = 0; a < len; ++a) {
            XMLTag child = targetParent.getChildAt(a);
            if (!child.name.equals(name)) continue;
            this.setTag(child, name, attrs, content);
            return child;
        }
        return this.addTag(targetParent, name, attrs, content);
    }

    public void setRoot(String name, String attrs, String content) {
        this.root.name = name;
        this.string2attrs(this.root, attrs);
        this.root.content = content;
    }

    public String getName(XMLTag tag) {
        return tag.getName();
    }

    public void setName(XMLTag tag, String newName) {
        tag.setName(newName);
    }

    public XMLTag getTag(Object[] objs) {
        XMLTag tag = this.root;
        if (objs == null || objs.length == 0) {
            return null;
        }
        String name = tag.getName();
        if (!name.equals(objs[0].toString())) {
            JFLog.log("getTag() : root does not match : " + objs[0].toString() + "!=" + name);
            return null;
        }
        int idx = 1;
        while (idx < objs.length) {
            boolean ok = false;
            int cnt = tag.getChildCount();
            for (int i = 0; i < cnt; ++i) {
                XMLTag child = tag.getChildAt(i);
                name = child.getName();
                if (!name.equals(objs[idx].toString())) continue;
                ok = true;
                ++idx;
                tag = child;
                break;
            }
            if (ok) continue;
            JFLog.log("getTag() : child not found : " + objs[idx].toString());
            return null;
        }
        return tag;
    }

    public void setTag(XMLTag tag, String name, String attrs, String content) {
        tag.name = name;
        this.string2attrs(tag, attrs);
        tag.content = content;
    }

    public void writeClass(XMLTag tag, Object obj) {
        Class<?> c = obj.getClass();
        int childCnt = tag.getChildCount();
        for (int a = 0; a < childCnt; ++a) {
            try {
                int idx;
                Object[] array2;
                Object childObject;
                Constructor<?> ctor;
                Class<?> fc;
                XMLTag child = tag.getChildAt(a);
                int childChildcnt = child.getChildCount();
                String name = child.getName();
                Field f = c.getField(name);
                if (f == null) {
                    JFLog.log("XML:field not found:" + name);
                    continue;
                }
                if (childChildcnt > 0) {
                    fc = f.getType();
                    if (fc.isArray()) {
                        Object[] newArray;
                        Class<?> fcc = fc.getComponentType();
                        ctor = fcc.getConstructor(new Class[0]);
                        Object i = ctor.newInstance(new Object[0]);
                        this.writeClass(child, i);
                        Object[] array = (Object[])f.get(obj);
                        if (array == null || array.length == 0) {
                            newArray = (Object[])Array.newInstance(fcc, 1);
                            newArray[0] = i;
                        } else {
                            newArray = Arrays.copyOf(array, array.length + 1);
                            newArray[array.length] = i;
                        }
                        f.set(obj, newArray);
                        continue;
                    }
                    ctor = fc.getConstructor(new Class[0]);
                    childObject = ctor.newInstance(new Object[0]);
                    this.writeClass(child, childObject);
                    f.set(obj, childObject);
                    continue;
                }
                String typeString = f.toGenericString();
                if (typeString.indexOf(" int ") != -1) {
                    f.setInt(obj, Integer.valueOf(child.content));
                    continue;
                }
                if (typeString.indexOf(" short ") != -1) {
                    f.setShort(obj, (short)JF.atoi(child.content));
                    continue;
                }
                if (typeString.indexOf(" byte ") != -1) {
                    f.setByte(obj, (byte)JF.atoi(child.content));
                    continue;
                }
                if (typeString.indexOf(" float ") != -1) {
                    f.setFloat(obj, Float.valueOf(child.content).floatValue());
                    continue;
                }
                if (typeString.indexOf(" double ") != -1) {
                    f.setDouble(obj, Double.valueOf(child.content));
                    continue;
                }
                if (typeString.indexOf(" boolean ") != -1) {
                    f.setBoolean(obj, child.content.equalsIgnoreCase("true"));
                    continue;
                }
                if (typeString.indexOf(" java.lang.String ") != -1) {
                    f.set(obj, child.content);
                    continue;
                }
                if (typeString.indexOf(" int[] ") != -1) {
                    array2 = (int[])f.get(obj);
                    if (array2 == null) {
                        idx = 0;
                        array2 = new int[1];
                    } else {
                        idx = array2.length;
                        array2 = Arrays.copyOf(array2, array2.length + 1);
                    }
                    array2[idx] = Integer.valueOf(child.content);
                    f.set(obj, array2);
                    continue;
                }
                if (typeString.indexOf(" short[] ") != -1) {
                    array2 = (short[])f.get(obj);
                    if (array2 == null) {
                        idx = 0;
                        array2 = new short[1];
                    } else {
                        idx = array2.length;
                        array2 = Arrays.copyOf((short[])array2, array2.length + 1);
                    }
                    array2[idx] = Short.valueOf(child.content).shortValue();
                    f.set(obj, array2);
                    continue;
                }
                if (typeString.indexOf(" byte[] ") != -1) {
                    array2 = (byte[])f.get(obj);
                    if (array2 == null) {
                        idx = 0;
                        array2 = new byte[1];
                    } else {
                        idx = array2.length;
                        array2 = Arrays.copyOf((byte[])array2, array2.length + 1);
                    }
                    array2[idx] = Byte.valueOf(child.content).byteValue();
                    f.set(obj, array2);
                    continue;
                }
                if (typeString.indexOf(" float[] ") != -1) {
                    array2 = (float[])f.get(obj);
                    if (array2 == null) {
                        idx = 0;
                        array2 = new float[1];
                    } else {
                        idx = array2.length;
                        array2 = Arrays.copyOf((float[])array2, array2.length + 1);
                    }
                    array2[idx] = (int)Float.valueOf(child.content).floatValue();
                    f.set(obj, array2);
                    continue;
                }
                if (typeString.indexOf(" double[] ") != -1) {
                    array2 = (double[])f.get(obj);
                    if (array2 == null) {
                        idx = 0;
                        array2 = new double[1];
                    } else {
                        idx = array2.length;
                        array2 = Arrays.copyOf((double[])array2, array2.length + 1);
                    }
                    array2[idx] = (int)Double.valueOf(child.content).doubleValue();
                    f.set(obj, array2);
                    continue;
                }
                if (typeString.indexOf(" boolean[] ") != -1) {
                    array2 = (boolean[])f.get(obj);
                    if (array2 == null) {
                        idx = 0;
                        array2 = new boolean[1];
                    } else {
                        idx = array2.length;
                        array2 = Arrays.copyOf((boolean[])array2, array2.length + 1);
                    }
                    array2[idx] = child.content.equalsIgnoreCase("true") ? 1 : 0;
                    f.set(obj, array2);
                    continue;
                }
                if (typeString.indexOf(" java.lang.String[] ") != -1) {
                    array2 = (String[])f.get(obj);
                    if (array2 == null) {
                        idx = 0;
                        array2 = new String[1];
                    } else {
                        idx = array2.length;
                        array2 = (String[])Arrays.copyOf(array2, array2.length + 1);
                    }
                    array2[idx] = (int)child.content;
                    f.set(obj, array2);
                    continue;
                }
                name = child.getName();
                f = c.getField(name);
                fc = f.getType();
                ctor = fc.getConstructor(new Class[0]);
                childObject = ctor.newInstance(new Object[0]);
                this.writeClass(child, childObject);
                f.set(obj, childObject);
                continue;
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }

    public void writeClass(Object obj) {
        this.writeClass(this.root, obj);
    }

    public void readClass(XMLTag tag, Object obj) {
        Field[] fs;
        Class<?> c = obj.getClass();
        try {
            fs = c.getFields();
        }
        catch (Exception e) {
            JFLog.log(e);
            return;
        }
        int fieldcnt = fs.length;
        for (int a = 0; a < fieldcnt; ++a) {
            try {
                String typeString;
                if (fs[a].get(obj) == null) continue;
                Class<?> fc = fs[a].getType();
                boolean isArray = fc.isArray();
                String name = fs[a].getName();
                if (isArray) {
                    int b;
                    typeString = fs[a].toGenericString();
                    if (typeString.indexOf(" static ") != -1 || typeString.indexOf(" transient ") != -1) continue;
                    Object[] array = (Object[])fs[a].get(obj);
                    if (typeString.indexOf(" int[] ") != -1) {
                        Integer[] array2 = (Integer[])array;
                        for (b = 0; b < array.length; ++b) {
                            this.addTag(tag, name, "", "" + array2[b]);
                        }
                        continue;
                    }
                    if (typeString.indexOf(" short[] ") != -1) {
                        Short[] array2 = (Short[])array;
                        for (b = 0; b < array.length; ++b) {
                            this.addTag(tag, name, "", "" + array2[b]);
                        }
                        continue;
                    }
                    if (typeString.indexOf(" byte[] ") != -1) {
                        Byte[] array2 = (Byte[])array;
                        for (b = 0; b < array.length; ++b) {
                            this.addTag(tag, name, "", "" + array2[b]);
                        }
                        continue;
                    }
                    if (typeString.indexOf(" boolean[] ") != -1) {
                        Boolean[] array2 = (Boolean[])array;
                        for (b = 0; b < array.length; ++b) {
                            this.addTag(tag, name, "", array2[b] != false ? "true" : "false");
                        }
                        continue;
                    }
                    if (typeString.indexOf(" float[] ") != -1) {
                        Float[] array2 = (Float[])array;
                        for (b = 0; b < array.length; ++b) {
                            this.addTag(tag, name, "", "" + array2[b].floatValue());
                        }
                        continue;
                    }
                    if (typeString.indexOf(" double[] ") != -1) {
                        Double[] array2 = (Double[])array;
                        for (b = 0; b < array.length; ++b) {
                            this.addTag(tag, name, "", "" + array2[b]);
                        }
                        continue;
                    }
                    if (typeString.indexOf(" java.lang.String[] ") != -1) {
                        String[] array2 = (String[])array;
                        for (b = 0; b < array.length; ++b) {
                            this.addTag(tag, name, "", array2[b]);
                        }
                        continue;
                    }
                    for (int b2 = 0; b2 < array.length; ++b2) {
                        this.readClass(this.addTag(tag, name, "", ""), array[b2]);
                    }
                    continue;
                }
                typeString = fs[a].toGenericString();
                if (typeString.indexOf(" static ") != -1 || typeString.indexOf(" transient ") != -1) continue;
                if (typeString.indexOf(" int ") != -1) {
                    this.addTag(tag, name, "", "" + fs[a].getInt(obj));
                    continue;
                }
                if (typeString.indexOf(" short ") != -1) {
                    this.addTag(tag, name, "", "" + fs[a].getShort(obj));
                    continue;
                }
                if (typeString.indexOf(" byte ") != -1) {
                    this.addTag(tag, name, "", "" + fs[a].getByte(obj));
                    continue;
                }
                if (typeString.indexOf(" boolean ") != -1) {
                    this.addTag(tag, name, "", fs[a].getBoolean(obj) ? "true" : "false");
                    continue;
                }
                if (typeString.indexOf(" float ") != -1) {
                    this.addTag(tag, name, "", "" + fs[a].getFloat(obj));
                    continue;
                }
                if (typeString.indexOf(" double ") != -1) {
                    this.addTag(tag, name, "", "" + fs[a].getDouble(obj));
                    continue;
                }
                if (typeString.indexOf(" java.lang.String ") != -1) {
                    this.addTag(tag, name, "", (String)fs[a].get(obj));
                    continue;
                }
                this.readClass(this.addTag(tag, name, "", ""), fs[a].get(obj));
                continue;
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }

    public void readClass(String rootName, Object obj) {
        this.deleteAll();
        this.root.setName(rootName);
        this.readClass(this.root, obj);
    }

    private String encodeSafe(String in) {
        return in.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    private String decodeSafe(String in) {
        return in.replaceAll("&gt;", ">").replaceAll("&lt;", "<").replaceAll("&amp;", "&");
    }

    public class XMLTag {
        public String name = "";
        public ArrayList<XMLAttr> attrs;
        public String content = "";
        public XMLTag parent;
        public ArrayList<XMLTag> children = new ArrayList();
        public boolean isSingle = false;
        public boolean isNotLeaf = false;
        public boolean isLeaf = false;
        public boolean isReadOnly = false;

        public XMLTag() {
            this.attrs = new ArrayList();
        }

        public String toString() {
            return this.getName();
        }

        public XMLTag getParent() {
            return this.parent;
        }

        public int getChildCount() {
            return this.children.size();
        }

        public void addTag(XMLTag tag) {
            this.addTag(tag, this.getChildCount());
        }

        public void addTag(XMLTag tag, int at) {
            tag.parent = this;
            this.children.add(at, tag);
        }

        public void removeTag(XMLTag tag) {
            this.children.remove(tag);
        }

        public void removeTag(int idx) {
            this.children.remove(idx);
        }

        public boolean isLeaf() {
            if (this.isNotLeaf) {
                return false;
            }
            if (this.isLeaf) {
                return true;
            }
            return this.getChildCount() == 0;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String newName) {
            boolean ok = false;
            for (XMLAttr attr : this.attrs) {
                if (!attr.name.equals("name")) continue;
                attr.value = newName;
                ok = true;
                break;
            }
            if (!ok) {
                this.name = newName;
            }
        }

        public XMLTag getChildAt(int index) {
            return this.children.get(index);
        }

        public XMLTag[] getChildren() {
            return this.children.toArray(new XMLTag[this.getChildCount()]);
        }

        public String getArg(String name) {
            for (int a = 0; a < this.attrs.size(); ++a) {
                if (!this.attrs.get((int)a).name.equals(name)) continue;
                return this.attrs.get((int)a).value;
            }
            return null;
        }

        public void setArg(String name, String value) {
            for (int a = 0; a < this.attrs.size(); ++a) {
                if (!this.attrs.get((int)a).name.equals(name)) continue;
                this.attrs.get((int)a).value = value;
                return;
            }
            XMLAttr attr = new XMLAttr();
            attr.name = name;
            attr.value = value;
            this.attrs.add(attr);
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String newContent) {
            this.content = newContent;
        }
    }

    private class XMLTagPart {
        private String content = "";
        private String attrs = "";

        private XMLTagPart() {
        }
    }

    public class XMLAttr {
        public String name = "";
        public String value = "";
    }
}

