/*
 * Decompiled with CFR 0.152.
 */
package javaforce.media;

public class AudioBuffer {
    private int bufsiz;
    private short[] buf;
    private int head = 0;
    private int tail = 0;

    public AudioBuffer(int freq, int chs, int seconds) {
        this.bufsiz = freq * chs * seconds;
        this.buf = new short[this.bufsiz];
        this.clear();
    }

    public void add(short[] in, int pos, int len) {
        boolean wrap = false;
        int nhead = this.head + len;
        if (nhead >= this.bufsiz) {
            wrap = true;
            nhead -= this.bufsiz;
        }
        if (nhead == this.tail) {
            return;
        }
        if (this.head > this.tail && nhead > this.tail && wrap) {
            return;
        }
        if (this.head < this.tail && nhead > this.tail && !wrap) {
            return;
        }
        if (wrap) {
            int p1 = this.bufsiz - this.head;
            int p2 = len - p1;
            System.arraycopy(in, pos, this.buf, this.head, p1);
            System.arraycopy(in, pos + p1, this.buf, 0, p2);
        } else {
            System.arraycopy(in, pos, this.buf, this.head, len);
        }
        this.head = nhead;
    }

    public boolean get(short[] out, int pos, int len) {
        if (this.tail == this.head) {
            return false;
        }
        boolean wrap = false;
        int ntail = this.tail + len;
        if (ntail >= this.bufsiz) {
            wrap = true;
            ntail -= this.bufsiz;
        }
        if (this.tail > this.head && ntail > this.head && wrap) {
            return false;
        }
        if (this.tail < this.head && ntail > this.head && !wrap) {
            return false;
        }
        if (wrap) {
            int p1 = this.bufsiz - this.tail;
            int p2 = len - p1;
            System.arraycopy(this.buf, this.tail, out, pos, p1);
            System.arraycopy(this.buf, 0, out, pos + p1, p2);
        } else {
            System.arraycopy(this.buf, this.tail, out, pos, len);
        }
        this.tail = ntail;
        return true;
    }

    public int size() {
        int t = this.tail;
        int h = this.head;
        if (t == h) {
            return 0;
        }
        if (h > t) {
            return h - t;
        }
        return this.bufsiz - t + h;
    }

    public void clear() {
        this.tail = this.head;
    }
}

