/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ui;

import java.util.ArrayList;
import javaforce.JFLog;
import javaforce.gl.GL;
import javaforce.gl.Object3;
import javaforce.gl.Scene;
import javaforce.gl.Texture;
import javaforce.ui.Canvas;
import javaforce.ui.Color;
import javaforce.ui.Component;
import javaforce.ui.KeyEvents;
import javaforce.ui.LayoutMetrics;
import javaforce.ui.MouseEvents;
import javaforce.ui.WindowEvents;
import javaforce.ui.theme.Theme;

public class Window {
    private long id;
    private int width;
    private int height;
    private int scale = 1;
    private KeyEvents keys;
    private MouseEvents mouse;
    private WindowEvents window;
    private boolean visible;
    private Texture texture;
    private Object3 object;
    private boolean active = true;
    private Component content;
    private static ArrayList<Canvas> canvasList = new ArrayList();
    private static ArrayList<Window> windows = new ArrayList();
    private static final int KEY_TYPED = 1;
    private static final int KEY_PRESS = 2;
    private static final int KEY_RELEASE = 3;
    private static final int MOUSE_MOVE = 4;
    private static final int MOUSE_DOWN = 5;
    private static final int MOUSE_UP = 6;
    private static final int MOUSE_SCROLL = 7;
    private static final int WIN_RESIZE = 8;
    private static final int WIN_CLOSING = 9;
    public static final int STYLE_VISIBLE = 1;
    public static final int STYLE_RESIZABLE = 2;
    public static final int STYLE_TITLEBAR = 4;
    public static final int STYLE_FULLSCREEN = 8;

    private static native boolean ninit();

    public static boolean init() {
        return Window.ninit();
    }

    private void dispatchEvent(int type, int v1, int v2) {
        try {
            switch (type) {
                case 1: {
                    if (this.keys == null) break;
                    this.keys.keyTyped((char)v1);
                    break;
                }
                case 2: {
                    if (this.keys == null) break;
                    this.keys.keyPressed((char)v1);
                    break;
                }
                case 3: {
                    if (this.keys == null) break;
                    this.keys.keyReleased((char)v1);
                    break;
                }
                case 4: {
                    if (this.mouse == null) break;
                    this.mouse.mouseMove(v1 / this.scale, v2 / this.scale);
                    break;
                }
                case 5: {
                    if (this.mouse == null) break;
                    this.mouse.mouseDown(v1);
                    break;
                }
                case 6: {
                    if (this.mouse == null) break;
                    this.mouse.mouseUp(v1);
                    break;
                }
                case 7: {
                    if (this.mouse == null) break;
                    this.mouse.mouseScroll(v1, v2);
                    break;
                }
                case 8: {
                    this.resize(v1, v2);
                    if (this.window == null) break;
                    this.window.windowResize(v1 / this.scale, v2 / this.scale);
                    break;
                }
                case 9: {
                    if (this.window == null) break;
                    this.window.windowClosing();
                }
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    private static native long ncreate(int var0, String var1, int var2, int var3, Window var4, long var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean create(int style, String title, int width, int height, Window shared) {
        this.width = width;
        this.height = height;
        this.id = Window.ncreate(style, title, width, height, this, shared == null ? 0L : shared.id);
        if (this.id != 0L) {
            ArrayList<Window> arrayList = windows;
            synchronized (arrayList) {
                windows.add(this);
            }
        }
        return this.id != 0L;
    }

    private static native void ndestroy(long var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.id == 0L) {
            return;
        }
        this.active = false;
        Window.ndestroy(this.id);
        this.id = 0L;
        ArrayList<Window> arrayList = windows;
        synchronized (arrayList) {
            windows.remove(this);
        }
    }

    private static native void nsetcurrent(long var0);

    public void setCurrent() {
        Window.nsetcurrent(this.id);
    }

    private static native void nseticon(long var0, String var2, int var3, int var4);

    public void setIcon(String filename, int x, int y) {
        Window.nseticon(this.id, filename, x, y);
    }

    public void setKeyListener(KeyEvents keys) {
        this.keys = keys;
    }

    public void setMouseListener(MouseEvents mouse) {
        this.mouse = mouse;
    }

    public void setWindowListener(WindowEvents window) {
        this.window = window;
    }

    public static native void pollEvents(int var0);

    public static native void postEvent();

    public static void pollEvents() {
        Window.pollEvents(0);
    }

    private static native void nshow(long var0);

    public void show() {
        Window.nshow(this.id);
        this.visible = true;
    }

    private static native void nhide(long var0);

    public void hide() {
        Window.nhide(this.id);
        this.visible = false;
    }

    private static native void nswap(long var0);

    public void swap() {
        Window.nswap(this.id);
    }

    private static native void nhidecursor(long var0);

    public void hideCursor() {
        Window.nhidecursor(this.id);
    }

    private static native void nshowcursor(long var0);

    public void showCursor() {
        Window.nshowcursor(this.id);
    }

    private static native void nlockcursor(long var0);

    public void lockCursor() {
        Window.nlockcursor(this.id);
    }

    private static native void ngetpos(long var0, int[] var2);

    public int[] getPosition() {
        int[] ret = new int[2];
        Window.ngetpos(this.id, ret);
        return ret;
    }

    private static native void nsetpos(long var0, int var2, int var3);

    public void setPosition(int x, int y) {
        Window.nsetpos(this.id, x, y);
    }

    public int getWidth() {
        return this.width;
    }

    public int getWidthScaled() {
        return this.width / this.scale;
    }

    public int getHeight() {
        return this.height;
    }

    public int getHeightScaled() {
        return this.height / this.scale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Window[] getWindows() {
        ArrayList<Window> arrayList = windows;
        synchronized (arrayList) {
            return windows.toArray(new Window[windows.size()]);
        }
    }

    public Component getContent() {
        return this.content;
    }

    public void setContent(Component content) {
        this.content = content;
        this.keys = content;
        this.mouse = content;
        this.layout();
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        if (scale < 1) {
            scale = 1;
        }
        if (scale > 4) {
            scale = 4;
        }
        this.scale = scale;
        this.layout();
    }

    public void layout() {
        if (this.content != null) {
            this.content.layout(new LayoutMetrics(this.getWidthScaled(), this.getHeightScaled()));
        }
    }

    public void resize(int w, int h) {
        this.width = w;
        this.height = h;
        if (this.content != null) {
            this.layout();
        }
    }

    public static void registerCanvas(Canvas canvas) {
        canvasList.add(canvas);
    }

    public void render(Scene scene) {
        if (this.texture == null || this.texture.getWidth() != this.getWidthScaled() || this.texture.getHeight() != this.getHeightScaled()) {
            if (this.texture != null) {
                this.texture.unload();
                this.texture = null;
            }
            if (this.object != null) {
                this.object.freeBuffers();
                this.object = null;
            }
            this.texture = new Texture(0, this.getWidthScaled(), this.getHeightScaled());
        }
        if (this.object == null) {
            this.object = new Object3();
            this.object.createUVMap();
            int z = -1;
            this.object.addVertex(new float[]{0.0f, 0.0f, z}, new float[]{0.0f, 1.0f});
            this.object.addVertex(new float[]{1.0f, 0.0f, z}, new float[]{1.0f, 1.0f});
            this.object.addVertex(new float[]{1.0f, 1.0f, z}, new float[]{1.0f, 0.0f});
            this.object.addVertex(new float[]{0.0f, 1.0f, z}, new float[]{0.0f, 0.0f});
            this.object.addPoly(new int[]{0, 1, 3});
            this.object.addPoly(new int[]{1, 2, 3});
            this.object.copyBuffers();
        }
        canvasList.clear();
        this.texture.getImage().fill(0, 0, this.width, this.height, Color.OPAQUE + Theme.getTheme().getBackColor().getColor());
        this.content.render(this.texture.getImage());
        this.setCurrent();
        GL.clear(Color.black, this.getWidth(), this.getHeight());
        this.texture.loaded = false;
        this.texture.load();
        this.object.bindBuffers(scene);
        this.texture.bind();
        this.object.render(scene);
        GL.glFlush();
        this.swap();
    }

    public Canvas[] getCanvasList() {
        return canvasList.toArray(new Canvas[0]);
    }

    public static void redrawAll() {
        if (windows.size() == 0) {
            return;
        }
        Window.postEvent();
    }
}

